/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.compute.VirtualMachine;
import com.microsoft.azure.management.resources.Deployment;
import com.microsoft.azure.management.resources.GenericResource;
import com.microsoft.azure.vmagent.AzureVMAgent;
import com.microsoft.azure.vmagent.AzureVMCloud;
import com.microsoft.azure.vmagent.AzureVMComputer;
import com.microsoft.azure.vmagent.AzureVMManagementServiceDelegate;
import com.microsoft.azure.vmagent.Messages;
import com.microsoft.azure.vmagent.exceptions.AzureCloudException;
import com.microsoft.azure.vmagent.retry.DefaultRetryStrategy;
import com.microsoft.azure.vmagent.util.AzureUtil;
import com.microsoft.azure.vmagent.util.CleanUpAction;
import com.microsoft.azure.vmagent.util.ExecutionEngine;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Computer;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeProvisioner;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.cloudstats.CloudStatistics;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedItem;
import org.joda.time.DateTime;

@Extension
public class AzureVMAgentCleanUpTask
extends AsyncPeriodicWork {
    private static final int CLEAN_TIMEOUT_IN_MINUTES = 15;
    private static final int RECURRENCE_PERIOD_IN_MILLIS = 300000;
    private static final long SUCCESSFUL_DEPLOYMENT_TIMEOUT_IN_MINUTES = 60L;
    private static final long FAILING_DEPLOYMENT_TIMEOUT_IN_MINUTES = 480L;
    private static final int MAX_DELETE_ATTEMPTS = 3;
    private static final Logger LOGGER = Logger.getLogger(AzureVMAgentCleanUpTask.class.getName());

    public AzureVMAgentCleanUpTask() {
        super("Azure VM Agents Clean Task");
    }

    public void cleanDeployments() {
        this.cleanDeployments(60L, 480L);
    }

    public void cleanDeployments(long successTimeoutInMinutes, long failTimeoutInMinutes) {
        LOGGER.log(this.getNormalLoggingLevel(), "AzureVMAgentCleanUpTask: cleanDeployments: Cleaning deployments");
        DeploymentInfo firstBackInQueue = null;
        ConcurrentLinkedQueue<DeploymentInfo> deploymentsToClean = DeploymentRegistrar.getInstance().getDeploymentsToClean();
        while (!deploymentsToClean.isEmpty() && firstBackInQueue != deploymentsToClean.peek()) {
            DeploymentInfo info = (DeploymentInfo)deploymentsToClean.remove();
            LOGGER.log(this.getNormalLoggingLevel(), "AzureVMAgentCleanUpTask: cleanDeployments: Checking deployment {0}", info.getDeploymentName());
            AzureVMCloud cloud = this.getCloud(info.getCloudName());
            if (cloud == null) continue;
            try {
                Deployment deployment;
                Azure azureClient = cloud.getAzureClient();
                AzureVMManagementServiceDelegate delegate = cloud.getServiceDelegate();
                try {
                    deployment = (Deployment)azureClient.deployments().getByResourceGroup(info.getResourceGroupName(), info.getDeploymentName());
                }
                catch (NullPointerException e) {
                    LOGGER.log(this.getNormalLoggingLevel(), "AzureVMAgentCleanUpTask: cleanDeployments: Deployment not found, skipping");
                    continue;
                }
                if (deployment == null) {
                    LOGGER.log(this.getNormalLoggingLevel(), "AzureVMAgentCleanUpTask: cleanDeployments: Deployment not found, skipping");
                    continue;
                }
                DateTime deploymentTime = deployment.timestamp();
                LOGGER.log(this.getNormalLoggingLevel(), "AzureVMAgentCleanUpTask: cleanDeployments: Deployment created on {0}", deploymentTime.toDate());
                long deploymentTimeInMillis = deploymentTime.getMillis();
                Calendar nowTime = Calendar.getInstance(deploymentTime.getZone().toTimeZone());
                long nowTimeInMillis = nowTime.getTimeInMillis();
                long diffTime = nowTimeInMillis - deploymentTimeInMillis;
                long diffTimeInMinutes = diffTime / 60000L;
                String state = deployment.provisioningState();
                if (!state.equalsIgnoreCase("succeeded") && diffTimeInMinutes > failTimeoutInMinutes) {
                    LOGGER.log(this.getNormalLoggingLevel(), "AzureVMAgentCleanUpTask: cleanDeployments: Failed deployment older than {0} minutes, deleting", failTimeoutInMinutes);
                    azureClient.deployments().deleteByResourceGroup(info.getResourceGroupName(), info.getDeploymentName());
                    if (!StringUtils.isNotBlank((String)info.scriptUri)) continue;
                    delegate.removeStorageBlob(new URI(info.scriptUri), info.getResourceGroupName());
                    continue;
                }
                if (state.equalsIgnoreCase("succeeded") && diffTimeInMinutes > successTimeoutInMinutes) {
                    LOGGER.log(this.getNormalLoggingLevel(), "AzureVMAgentCleanUpTask: cleanDeployments: Successful deployment older than {0} minutes, deleting", successTimeoutInMinutes);
                    azureClient.deployments().deleteByResourceGroup(info.getResourceGroupName(), info.getDeploymentName());
                    if (!StringUtils.isNotBlank((String)info.scriptUri)) continue;
                    delegate.removeStorageBlob(new URI(info.scriptUri), info.getResourceGroupName());
                    continue;
                }
                LOGGER.log(this.getNormalLoggingLevel(), "AzureVMAgentCleanUpTask: cleanDeployments: Deployment newer than timeout, keeping");
                if (firstBackInQueue == null) {
                    firstBackInQueue = info;
                }
                deploymentsToClean.add(info);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "AzureVMAgentCleanUpTask: cleanDeployments: Failed to get/delete deployment: {0}", e);
                if (!info.hasAttemptsRemaining()) continue;
                info.decrementAttemptsRemaining();
                if (firstBackInQueue == null) {
                    firstBackInQueue = info;
                }
                deploymentsToClean.add(info);
            }
        }
        DeploymentRegistrar.getInstance().syncDeploymentsToClean();
        LOGGER.log(this.getNormalLoggingLevel(), "AzureVMAgentCleanUpTask: cleanDeployments: Done cleaning deployments");
    }

    public void cleanLeakedResources() {
        Jenkins instance = Jenkins.getInstance();
        if (instance == null) {
            return;
        }
        for (AzureVMCloud cloud : instance.clouds.getAll(AzureVMCloud.class)) {
            this.cleanLeakedResources(cloud, cloud.getResourceGroupName(), DeploymentRegistrar.getInstance());
        }
    }

    public List<String> getValidVMs() {
        ArrayList<String> vms = new ArrayList<String>();
        Jenkins instance = Jenkins.getInstance();
        if (instance != null) {
            for (Computer computer : instance.getComputers()) {
                if (!(computer instanceof AzureVMComputer)) continue;
                vms.add(computer.getName());
            }
        }
        return vms;
    }

    public void cleanLeakedResources(AzureVMCloud cloud, String resourceGroup, DeploymentRegistrar deploymentRegistrar) {
        try {
            List<String> validVMs = this.getValidVMs();
            Azure azureClient = cloud.getAzureClient();
            AzureVMManagementServiceDelegate serviceDelegate = cloud.getServiceDelegate();
            PagedList resources = azureClient.genericResources().listByResourceGroup(resourceGroup);
            if (resources == null || resources.isEmpty()) {
                return;
            }
            PriorityQueue<GenericResource> resourcesMarkedForDeletion = new PriorityQueue<GenericResource>(resources.size(), new Comparator<GenericResource>(){

                @Override
                public int compare(GenericResource o1, GenericResource o2) {
                    int o2Priority;
                    int o1Priority = this.getPriority(o1);
                    if (o1Priority == (o2Priority = this.getPriority(o2))) {
                        return 0;
                    }
                    return o1Priority < o2Priority ? -1 : 1;
                }

                private int getPriority(GenericResource resource) {
                    String type = resource.type();
                    if (StringUtils.containsIgnoreCase((String)type, (String)"virtualMachine")) {
                        return 1;
                    }
                    if (StringUtils.containsIgnoreCase((String)type, (String)"networkInterface")) {
                        return 2;
                    }
                    if (StringUtils.containsIgnoreCase((String)type, (String)"IPAddress")) {
                        return 3;
                    }
                    return 4;
                }
            });
            for (GenericResource resource : resources) {
                Map tags = resource.tags();
                if (!tags.containsKey("JenkinsResourceTag") || !deploymentRegistrar.getDeploymentTag().matches(new AzureUtil.DeploymentTag((String)tags.get("JenkinsResourceTag")))) continue;
                boolean shouldSkipDeletion = false;
                for (String validVM : validVMs) {
                    if (!resource.name().contains(validVM)) continue;
                    shouldSkipDeletion = true;
                    break;
                }
                if (shouldSkipDeletion || StringUtils.containsIgnoreCase((String)resource.type(), (String)"StorageAccounts") || StringUtils.containsIgnoreCase((String)resource.type(), (String)"virtualNetworks")) continue;
                resourcesMarkedForDeletion.add(resource);
            }
            while (!resourcesMarkedForDeletion.isEmpty()) {
                try {
                    GenericResource resource = resourcesMarkedForDeletion.poll();
                    if (resource == null) continue;
                    URI osDiskURI = null;
                    String managedOsDiskId = null;
                    if (StringUtils.containsIgnoreCase((String)resource.type(), (String)"virtualMachine")) {
                        if (!((VirtualMachine)azureClient.virtualMachines().getById(resource.id())).isManagedDiskEnabled()) {
                            osDiskURI = new URI(((VirtualMachine)azureClient.virtualMachines().getById(resource.id())).osUnmanagedDiskVhdUri());
                        } else {
                            managedOsDiskId = ((VirtualMachine)azureClient.virtualMachines().getById(resource.id())).osDiskId();
                        }
                    }
                    LOGGER.log(this.getNormalLoggingLevel(), "cleanLeakedResources: deleting {0} from resource group {1}", new Object[]{resource.name(), resourceGroup});
                    azureClient.genericResources().deleteById(resource.id());
                    if (osDiskURI != null) {
                        serviceDelegate.removeStorageBlob(osDiskURI, resourceGroup);
                    }
                    if (managedOsDiskId == null) continue;
                    azureClient.disks().deleteById(managedOsDiskId);
                    serviceDelegate.removeImage(azureClient, resource.name(), resourceGroup);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "AzureVMAgentCleanUpTask: cleanLeakedResources: failed to clean resource ", e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "AzureVMAgentCleanUpTask: cleanLeakedResources: failed to clean leaked resources ", e);
        }
    }

    private void cleanVMs() {
        this.cleanVMs(new ExecutionEngine());
    }

    private void cleanVMs(ExecutionEngine executionEngine) {
        for (Computer computer : Jenkins.getInstance().getComputers()) {
            if (!(computer instanceof AzureVMComputer)) continue;
            AzureVMComputer azureComputer = (AzureVMComputer)computer;
            final AzureVMAgent agentNode = (AzureVMAgent)azureComputer.getNode();
            if (!azureComputer.isOffline() || !azureComputer.isIdle()) continue;
            if (azureComputer.isSetOfflineByUser()) {
                LOGGER.log(this.getNormalLoggingLevel(), "AzureVMAgentCleanUpTask: cleanVMs: node {0} was set offline by user, skipping", agentNode.getDisplayName());
                continue;
            }
            if (agentNode.isCleanUpBlocked()) {
                LOGGER.log(this.getNormalLoggingLevel(), "AzureVMAgentCleanUpTask: cleanVMs: node {0} blocked to cleanup", agentNode.getDisplayName());
                continue;
            }
            if (!AzureVMManagementServiceDelegate.virtualMachineExists(agentNode)) {
                LOGGER.log(this.getNormalLoggingLevel(), "AzureVMAgentCleanUpTask: cleanVMs: node {0} doesn't exist, removing", agentNode.getDisplayName());
                try {
                    Jenkins.getInstance().removeNode((Node)agentNode);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "AzureVMAgentCleanUpTask: cleanVMs: node {0} could not be removed: {1}", new Object[]{agentNode.getDisplayName(), e.getMessage()});
                }
                continue;
            }
            Callable<Void> task = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (agentNode.getCleanUpAction() == CleanUpAction.DELETE) {
                        LOGGER.log(AzureVMAgentCleanUpTask.this.getNormalLoggingLevel(), "AzureVMAgentCleanUpTask: cleanVMs: deleting {0}", agentNode.getDisplayName());
                        agentNode.deprovision(agentNode.getCleanUpReason());
                    } else if (agentNode.getCleanUpAction() == CleanUpAction.SHUTDOWN) {
                        LOGGER.log(AzureVMAgentCleanUpTask.this.getNormalLoggingLevel(), "AzureVMAgentCleanUpTask: cleanVMs: shutting down {0}", agentNode.getDisplayName());
                        agentNode.shutdown(agentNode.getCleanUpReason());
                        agentNode.blockCleanUpAction();
                    } else {
                        throw new IllegalStateException("Unknown cleanup action");
                    }
                    return null;
                }
            };
            try {
                int maxRetries = 3;
                int waitInterval = 10;
                int defaultTimeOutInSeconds = 1800;
                executionEngine.executeAsync(task, new DefaultRetryStrategy(3, 10, 1800));
            }
            catch (AzureCloudException exception) {
                LOGGER.log(Level.WARNING, "AzureVMAgentCleanUpTask: cleanVMs: failed to shutdown/delete " + agentNode.getDisplayName(), exception);
                agentNode.setCleanUpAction(CleanUpAction.DELETE, Messages._Failed_Initial_Shutdown_Or_Delete());
            }
        }
    }

    public void cleanCloudStatistics() {
        Jenkins jenkins = Jenkins.getInstance();
        HashSet<ProvisioningActivity.Id> plannedNodesSet = new HashSet<ProvisioningActivity.Id>();
        for (NodeProvisioner.PlannedNode node : jenkins.unlabeledNodeProvisioner.getPendingLaunches()) {
            if (!(node instanceof TrackedItem)) continue;
            plannedNodesSet.add(((TrackedItem)node).getId());
        }
        for (Label l : jenkins.getLabels()) {
            for (NodeProvisioner.PlannedNode node : l.nodeProvisioner.getPendingLaunches()) {
                if (!(node instanceof TrackedItem)) continue;
                plannedNodesSet.add(((TrackedItem)node).getId());
            }
        }
        for (NodeProvisioner.PlannedNode node : jenkins.getNodes()) {
            if (!(node instanceof TrackedItem)) continue;
            plannedNodesSet.add(((TrackedItem)node).getId());
        }
        Collection activities = CloudStatistics.get().getNotCompletedActivities();
        for (ProvisioningActivity activity : activities) {
            if (!activity.getCurrentPhase().equals((Object)ProvisioningActivity.Phase.PROVISIONING) || plannedNodesSet.contains(activity.getId())) continue;
            Exception e = new Exception(String.format("Node %s has lost. Mark as failure", activity.getId().toString()));
            CloudStatistics.ProvisioningListener.get().onFailure(activity.getId(), (Throwable)e);
        }
    }

    public AzureVMCloud getCloud(String cloudName) {
        return Jenkins.getInstance() == null ? null : (AzureVMCloud)Jenkins.getInstance().getCloud(cloudName);
    }

    private void clean() {
        this.cleanVMs();
        this.cleanDeployments();
        this.cleanLeakedResources();
        this.cleanCloudStatistics();
    }

    public void execute(TaskListener arg0) throws InterruptedException {
        LOGGER.log(this.getNormalLoggingLevel(), "AzureVMAgentCleanUpTask: execute: start");
        Callable<Void> callClean = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AzureVMAgentCleanUpTask.this.clean();
                return null;
            }
        };
        Future<Void> result = AzureVMCloud.getThreadPool().submit(callClean);
        try {
            LOGGER.log(this.getNormalLoggingLevel(), "AzureVMAgentCleanUpTask: execute: Running clean with 5 minute timeout");
            result.get(15L, TimeUnit.MINUTES);
        }
        catch (ExecutionException executionException) {
            LOGGER.log(Level.SEVERE, "AzureVMAgentCleanUpTask: execute: Got execution exception while cleaning", executionException);
        }
        catch (TimeoutException timeoutException) {
            LOGGER.log(Level.SEVERE, "AzureVMAgentCleanUpTask: execute: Hit timeout while cleaning", timeoutException);
        }
        catch (Exception others) {
            LOGGER.log(Level.SEVERE, "AzureVMAgentCleanUpTask: execute: Hit other exception while cleaning", others);
        }
        LOGGER.log(this.getNormalLoggingLevel(), "AzureVMAgentCleanUpTask: execute: end");
    }

    public long getRecurrencePeriod() {
        return 300000L;
    }

    protected Level getNormalLoggingLevel() {
        return Level.FINE;
    }

    public static String loadProperty(String name) {
        String value = System.getProperty(name);
        if (StringUtils.isBlank((String)value)) {
            return AzureVMAgentCleanUpTask.loadEnv(name);
        }
        return value;
    }

    public static String loadEnv(String name) {
        String value = System.getenv(name);
        if (StringUtils.isBlank((String)value)) {
            return "";
        }
        return value;
    }

    public static class DeploymentRegistrar {
        private static final String OUTPUT_FILE = Paths.get(AzureVMAgentCleanUpTask.loadProperty("JENKINS_HOME"), "deployment.out").toString();
        private static DeploymentRegistrar deploymentRegistrar = null;
        private ConcurrentLinkedQueue<DeploymentInfo> deploymentsToClean = new ConcurrentLinkedQueue();

        /*
         * Loose catch block
         */
        protected DeploymentRegistrar() {
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(new FileInputStream(OUTPUT_FILE));
                this.deploymentsToClean = (ConcurrentLinkedQueue)ois.readObject();
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.WARNING, "AzureVMAgentCleanUpTask: readResolve: Cannot open deployment output file");
                this.deploymentsToClean = new ConcurrentLinkedQueue();
                IOUtils.closeQuietly((InputStream)ois);
            }
            catch (Exception e2) {
                LOGGER.log(Level.WARNING, "AzureVMAgentCleanUpTask: readResolve: Cannot deserialize deploymentsToClean", e2);
                this.deploymentsToClean = new ConcurrentLinkedQueue();
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(ois);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)ois);
            }
            IOUtils.closeQuietly((InputStream)ois);
        }

        public static synchronized DeploymentRegistrar getInstance() {
            if (deploymentRegistrar == null) {
                deploymentRegistrar = new DeploymentRegistrar();
            }
            return deploymentRegistrar;
        }

        public ConcurrentLinkedQueue<DeploymentInfo> getDeploymentsToClean() {
            return this.deploymentsToClean;
        }

        public void registerDeployment(String cloudName, String resourceGroupName, String deploymentName, String scriptUri) {
            LOGGER.log(Level.INFO, "AzureVMAgentCleanUpTask: registerDeployment: Registering deployment {0} in {1}", new Object[]{deploymentName, resourceGroupName});
            DeploymentInfo newDeploymentToClean = new DeploymentInfo(cloudName, resourceGroupName, deploymentName, scriptUri, 3);
            this.deploymentsToClean.add(newDeploymentToClean);
            this.syncDeploymentsToClean();
        }

        /*
         * Loose catch block
         */
        public synchronized void syncDeploymentsToClean() {
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(new FileOutputStream(OUTPUT_FILE));
                oos.writeObject(this.deploymentsToClean);
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.WARNING, "AzureVMAgentCleanUpTask: registerDeployment: Cannot open deployment output file" + OUTPUT_FILE);
                IOUtils.closeQuietly((OutputStream)oos);
            }
            catch (IOException e2) {
                LOGGER.log(Level.WARNING, "AzureVMAgentCleanUpTask: registerDeployment: Serialize failed", e2);
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(oos);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)oos);
            }
            IOUtils.closeQuietly((OutputStream)oos);
        }

        public AzureUtil.DeploymentTag getDeploymentTag() {
            return new AzureUtil.DeploymentTag();
        }
    }

    private static class DeploymentInfo
    implements Serializable {
        private static final long serialVersionUID = 888154365L;
        private String cloudName;
        private String deploymentName;
        private String resourceGroupName;
        private String scriptUri;
        private int attemptsRemaining;

        DeploymentInfo(String cloudName, String resourceGroupName, String deploymentName, String scriptUri, int deleteAttempts) {
            this.cloudName = cloudName;
            this.deploymentName = deploymentName;
            this.resourceGroupName = resourceGroupName;
            this.scriptUri = scriptUri;
            this.attemptsRemaining = deleteAttempts;
        }

        String getCloudName() {
            return this.cloudName;
        }

        String getDeploymentName() {
            return this.deploymentName;
        }

        String getResourceGroupName() {
            return this.resourceGroupName;
        }

        String getScriptUri() {
            return this.scriptUri;
        }

        boolean hasAttemptsRemaining() {
            return this.attemptsRemaining > 0;
        }

        void decrementAttemptsRemaining() {
            --this.attemptsRemaining;
        }
    }
}

