/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.util.AzureCredentials;
import com.microsoft.azure.vmagent.AzureVMAgentPlugin;
import com.microsoft.azure.vmagent.AzureVMAgentTemplate;
import com.microsoft.azure.vmagent.AzureVMCloud;
import com.microsoft.azure.vmagent.AzureVMComputer;
import com.microsoft.azure.vmagent.AzureVMManagementServiceDelegate;
import com.microsoft.azure.vmagent.Messages;
import com.microsoft.azure.vmagent.remote.AzureVMAgentSSHLauncher;
import com.microsoft.azure.vmagent.util.CleanUpAction;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.cloudstats.CloudStatistics;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedItem;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class AzureVMAgent
extends AbstractCloudSlave
implements TrackedItem {
    private static final long serialVersionUID = -760014706860995557L;
    private ProvisioningActivity.Id provisioningId;
    private final String cloudName;
    private final String vmCredentialsId;
    private final String azureCredentialsId;
    private final String sshPrivateKey;
    private final String sshPassPhrase;
    private final String jvmOptions;
    private boolean shutdownOnIdle;
    private final int retentionTimeInMin;
    private final String agentLaunchMethod;
    private final String initScript;
    private final String deploymentName;
    private final OperatingSystemTypes osType;
    private String publicDNSName;
    private String publicIP;
    private String privateIP;
    private int sshPort;
    private final Node.Mode mode;
    private String templateName;
    private CleanUpAction cleanUpAction;
    private Localizable cleanUpReason;
    private String resourceGroupName;
    private static final Logger LOGGER = Logger.getLogger(AzureVMAgent.class.getName());
    private final boolean executeInitScriptAsRoot;
    private final boolean doNotUseMachineIfInitFails;
    private final boolean enableMSI;
    private boolean eligibleForReuse;
    private final AzureVMAgentTemplate template;
    private long creationTime;
    private final Object publicIPAttachLock = new Object();

    @DataBoundConstructor
    public AzureVMAgent(String name, String templateName, String nodeDescription, OperatingSystemTypes osType, String remoteFS, int numExecutors, Node.Mode mode, String label, ComputerLauncher launcher, RetentionStrategy<AzureVMComputer> retentionStrategy, List<? extends NodeProperty<?>> nodeProperties, String cloudName, String vmCredentialsId, String sshPrivateKey, String sshPassPhrase, String jvmOptions, boolean shutdownOnIdle, boolean eligibleForReuse, String deploymentName, int retentionTimeInMin, String initScript, String azureCredentialsId, AzureCredentials.ServicePrincipal servicePrincipal, String agentLaunchMethod, CleanUpAction cleanUpAction, Localizable cleanUpReason, String resourceGroupName, boolean executeInitScriptAsRoot, boolean doNotUseMachineIfInitFails, boolean enableMSI, AzureVMAgentTemplate template) throws Descriptor.FormException, IOException {
        super(name, nodeDescription, remoteFS, numExecutors, mode, label, launcher, retentionStrategy, nodeProperties);
        this.cloudName = cloudName;
        this.templateName = templateName;
        this.vmCredentialsId = vmCredentialsId;
        this.azureCredentialsId = azureCredentialsId;
        this.sshPrivateKey = sshPrivateKey;
        this.sshPassPhrase = sshPassPhrase;
        this.jvmOptions = jvmOptions;
        this.shutdownOnIdle = shutdownOnIdle;
        this.eligibleForReuse = eligibleForReuse;
        this.deploymentName = deploymentName;
        this.retentionTimeInMin = retentionTimeInMin;
        this.initScript = initScript;
        this.osType = osType;
        this.mode = mode;
        this.agentLaunchMethod = agentLaunchMethod;
        this.setCleanUpAction(cleanUpAction);
        this.setCleanUpReason(cleanUpReason);
        this.resourceGroupName = resourceGroupName;
        this.executeInitScriptAsRoot = executeInitScriptAsRoot;
        this.doNotUseMachineIfInitFails = doNotUseMachineIfInitFails;
        this.enableMSI = enableMSI;
        this.template = template;
        this.creationTime = System.currentTimeMillis();
    }

    public AzureVMAgent(ProvisioningActivity.Id id, String name, String templateName, String nodeDescription, OperatingSystemTypes osType, String remoteFS, int numExecutors, Node.Mode mode, String label, String cloudName, String vmCredentialsId, String sshPrivateKey, String sshPassPhrase, String jvmOptions, boolean shutdownOnIdle, boolean eligibleForReuse, String deploymentName, RetentionStrategy<AzureVMComputer> retentionStrategy, String initScript, String azureCredentialsId, String agentLaunchMethod, CleanUpAction cleanUpAction, Localizable cleanUpReason, String resourceGroupName, boolean executeInitScriptAsRoot, boolean doNotUseMachineIfInitFails, boolean enableMSI, AzureVMAgentTemplate template, String fqdn) throws Descriptor.FormException, IOException {
        this(name, templateName, nodeDescription, osType, remoteFS, numExecutors, mode, label, agentLaunchMethod.equalsIgnoreCase("SSH") ? new AzureVMAgentSSHLauncher() : new JNLPLauncher(), retentionStrategy, Arrays.asList(new EnvironmentVariablesNodeProperty(new EnvironmentVariablesNodeProperty.Entry[]{new EnvironmentVariablesNodeProperty.Entry("FQDN", fqdn)})), cloudName, vmCredentialsId, sshPrivateKey, sshPassPhrase, jvmOptions, shutdownOnIdle, eligibleForReuse, deploymentName, template.getRetentionTimeInMin(), initScript, azureCredentialsId, null, agentLaunchMethod, cleanUpAction, cleanUpReason, resourceGroupName, executeInitScriptAsRoot, doNotUseMachineIfInitFails, enableMSI, template);
        this.provisioningId = id;
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public Node.Mode getMode() {
        return this.mode;
    }

    public String getVMCredentialsId() {
        return this.vmCredentialsId;
    }

    public String getSshPrivateKey() {
        return this.sshPrivateKey;
    }

    public OperatingSystemTypes getOsType() {
        return this.osType;
    }

    public String getSshPassPhrase() {
        return this.sshPassPhrase;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public CleanUpAction getCleanUpAction() {
        return this.cleanUpAction;
    }

    public Localizable getCleanUpReason() {
        return this.cleanUpReason;
    }

    private void setCleanUpAction(CleanUpAction cleanUpAction) {
        if (cleanUpAction == CleanUpAction.DEFAULT) {
            cleanUpAction = this.isShutdownOnIdle() ? CleanUpAction.SHUTDOWN : CleanUpAction.DELETE;
        }
        this.cleanUpAction = cleanUpAction;
    }

    private void setCleanUpReason(Localizable cleanUpReason) {
        this.cleanUpReason = cleanUpReason;
    }

    public void clearCleanUpAction() {
        this.setCleanUpAction(CleanUpAction.DEFAULT);
        this.setCleanUpReason(null);
    }

    public void blockCleanUpAction() {
        this.setCleanUpAction(CleanUpAction.BLOCK);
        this.setCleanUpReason(null);
    }

    public boolean isCleanUpBlocked() {
        return this.getCleanUpAction() == CleanUpAction.BLOCK;
    }

    public void setCleanUpAction(CleanUpAction action, Localizable reason) {
        if (action != CleanUpAction.DELETE && action != CleanUpAction.SHUTDOWN) {
            throw new IllegalStateException("Only use this method to set explicit cleanup operations");
        }
        AzureVMComputer computer = (AzureVMComputer)this.toComputer();
        if (computer != null) {
            computer.setTemporarilyOffline(true, OfflineCause.create((Localizable)reason));
        }
        this.setCleanUpAction(action);
        this.setCleanUpReason(reason);
    }

    public String getJvmOptions() {
        return this.jvmOptions;
    }

    public boolean isShutdownOnIdle() {
        return this.shutdownOnIdle;
    }

    public void setShutdownOnIdle(boolean shutdownOnIdle) {
        this.shutdownOnIdle = shutdownOnIdle;
    }

    public boolean isEligibleForReuse() {
        return this.eligibleForReuse;
    }

    public void setEligibleForReuse(boolean eligibleForReuse) {
        this.eligibleForReuse = eligibleForReuse;
    }

    public String getPublicDNSName() {
        return this.publicDNSName;
    }

    public void setPublicDNSName(String publicDNSName) {
        this.publicDNSName = publicDNSName;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(int sshPort) {
        this.sshPort = sshPort;
    }

    public String getPublicIP() {
        return this.publicIP;
    }

    public void setPublicIP(String publicIP) {
        this.publicIP = publicIP;
    }

    public String getPrivateIP() {
        return this.privateIP;
    }

    public void setPrivateIP(String privateIP) {
        this.privateIP = privateIP;
    }

    public int getRetentionTimeInMin() {
        return this.retentionTimeInMin;
    }

    public String getInitScript() {
        return this.initScript;
    }

    public String getAgentLaunchMethod() {
        return this.agentLaunchMethod;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    public boolean getExecuteInitScriptAsRoot() {
        return this.executeInitScriptAsRoot;
    }

    public boolean getDoNotUseMachineIfInitFails() {
        return this.doNotUseMachineIfInitFails;
    }

    public boolean isEnableMSI() {
        return this.enableMSI;
    }

    public AzureVMAgentTemplate getTemplate() {
        return this.template;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    protected void _terminate(TaskListener arg0) throws IOException, InterruptedException {
        LOGGER.log(Level.INFO, "AzureVMAgent: _terminate: called for agent {0}", this.getNodeName());
        ProvisioningActivity activity = CloudStatistics.get().getActivityFor((TrackedItem)this);
        if (activity != null) {
            activity.enterIfNotAlready(ProvisioningActivity.Phase.COMPLETED);
        }
    }

    public AbstractCloudComputer<AzureVMAgent> createComputer() {
        LOGGER.log(Level.INFO, "AzureVMAgent: createComputer: start for agent {0}", this.getDisplayName());
        return new AzureVMComputer(this);
    }

    @CheckForNull
    public AzureVMCloud getCloud() {
        return (AzureVMCloud)Jenkins.getInstance().getCloud(this.cloudName);
    }

    public synchronized void shutdown(Localizable reason) {
        if (this.isEligibleForReuse()) {
            LOGGER.log(Level.INFO, "AzureVMAgent: shutdown: agent {0} is always shut down", this.getDisplayName());
            return;
        }
        LOGGER.log(Level.INFO, "AzureVMAgent: shutdown: Add suspended status for node {0}", this.getNodeName());
        this.getComputer().setAcceptingTasks(false);
        this.getComputer().disconnect(OfflineCause.create((Localizable)reason));
        LOGGER.log(Level.INFO, "AzureVMAgent: shutdown: shutting down agent {0}", this.getDisplayName());
        AzureVMManagementServiceDelegate serviceDelegate = this.getServiceDelegate();
        if (serviceDelegate != null) {
            serviceDelegate.shutdownVirtualMachine(this);
        }
        this.setEligibleForReuse(true);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("Reason", reason == null ? "Unknown reason" : reason.toString());
        AzureVMAgentPlugin.sendEvent("VMAgent", "ShutDown", properties);
    }

    public synchronized void deprovision(Localizable reason) throws Exception {
        if (Jenkins.getInstance().getNode(this.name) == null || this.getComputer() == null) {
            return;
        }
        LOGGER.log(Level.INFO, "AzureVMAgent: deprovision: Deprovision called for agent {0}, for reason: {1}", new Object[]{this.getDisplayName(), reason == null ? "Unknown reason" : reason.toString()});
        this.getComputer().setAcceptingTasks(false);
        this.getComputer().disconnect(OfflineCause.create((Localizable)reason));
        AzureVMManagementServiceDelegate.terminateVirtualMachine(this);
        LOGGER.log(Level.INFO, "AzureVMAgent: deprovision: {0} has been deprovisioned. Remove node ...", this.getDisplayName());
        AzureVMCloud parentCloud = this.getCloud();
        if (parentCloud != null) {
            parentCloud.adjustVirtualMachineCount(-1);
        }
        Jenkins.getInstance().removeNode((Node)this);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("Reason", reason == null ? "Unknown reason" : reason.toString());
        AzureVMAgentPlugin.sendEvent("VMAgent", "Deprovision", properties);
    }

    @CheckForNull
    public AzureVMManagementServiceDelegate getServiceDelegate() {
        AzureVMCloud cloud = this.getCloud();
        if (cloud != null) {
            return cloud.getServiceDelegate();
        }
        return null;
    }

    public boolean isVMAliveOrHealthy() throws Exception {
        AzureVMManagementServiceDelegate serviceDelegate = this.getServiceDelegate();
        if (serviceDelegate != null) {
            return serviceDelegate.isVMAliveOrHealthy(this);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String attachPublicIP() {
        if (!this.publicIP.isEmpty()) {
            return this.publicIP;
        }
        Object object = this.publicIPAttachLock;
        synchronized (object) {
            try {
                AzureVMCloud azureVMCloud = this.getCloud();
                AzureVMManagementServiceDelegate serviceDelegate = this.getServiceDelegate();
                if (azureVMCloud != null && serviceDelegate != null) {
                    serviceDelegate.attachPublicIP(this, azureVMCloud.getAzureAgentTemplate(this.templateName));
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, String.format("AzureVMAgent: error while trying to attach a public IP to %s", this.getNodeName()), e);
            }
            return this.publicIP;
        }
    }

    public String toString() {
        return "AzureVMAgent [\n\tcloudName=" + this.cloudName + "\n\tVMCredentialsId=" + this.vmCredentialsId + "\n\tjvmOptions=" + this.jvmOptions + "\n\tshutdownOnIdle=" + this.shutdownOnIdle + "\n\tretentionTimeInMin=" + this.retentionTimeInMin + "\n\tagentLaunchMethod=" + this.agentLaunchMethod + "\n\tinitScript=" + this.initScript + "\n\tdeploymentName=" + this.deploymentName + "\n\tosType=" + this.osType + "\n\tpublicDNSName=" + this.publicDNSName + "\n\tsshPort=" + this.sshPort + "\n\tmode=" + this.mode + "\n\ttemplateName=" + this.templateName + "\n\tcleanUpAction=" + (Object)((Object)this.cleanUpAction) + "\n]";
    }

    @Nullable
    public ProvisioningActivity.Id getId() {
        return this.provisioningId;
    }

    @Extension
    public static final class AzureVMAgentDescriptor
    extends Slave.SlaveDescriptor {
        public String getDisplayName() {
            return "Azure VM Agent";
        }

        public boolean isInstantiable() {
            return false;
        }

        public FormValidation doAttachPublicIP(@QueryParameter String vmAgentName) {
            AzureVMAgent vmAgent = (AzureVMAgent)Jenkins.getInstance().getNode(vmAgentName);
            String publicIP = "";
            if (vmAgent != null) {
                publicIP = vmAgent.attachPublicIP();
            }
            if (publicIP.isEmpty()) {
                return FormValidation.error((String)Messages.Azure_VM_Agent_Attach_Public_IP_Failure());
            }
            return FormValidation.ok((String)(Messages.Azure_VM_Agent_Attach_Public_IP_Success() + " ( " + publicIP + " ) "));
        }
    }
}

