/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.azureeventgridnotifier;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jenkinsci.plugins.azureeventgridnotifier.PublishEnvVarAction;

public class Utils {
    private static final String REGEX = "\\$\\{(.+?)}";

    public static String fillTemplate(String template, AbstractBuild build, TaskListener listener) {
        List<String> tokens = Utils.extractTokens(template);
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (String token : tokens) {
            String varValue = "";
            try {
                varValue = Utils.getEnvVar(build.getEnvironment(listener), token);
            }
            catch (Exception e) {
                listener.getLogger().println(e.getMessage());
            }
            replacements.put(token, varValue);
        }
        return Utils.tokenizeText(template, replacements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static String executePost(String targetURL, Map<String, String> headers, String urlParameters) {
        connection = null;
        try {
            url = new URL(targetURL);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Content-Length", Integer.toString(urlParameters.getBytes(StandardCharsets.UTF_8).length));
            connection.setRequestProperty("Content-Language", "en-US");
            for (Map.Entry<String, String> header : headers.entrySet()) {
                connection.setRequestProperty(header.getKey(), header.getValue());
            }
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(urlParameters);
            wr.close();
            is = connection.getInputStream();
            rd = new BufferedReader(new InputStreamReader(is, "utf-8"));
            response = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                response.append(line);
                response.append('\r');
            }
            rd.close();
            var10_17 = response.toString();
            return var10_17;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (connection == null) ** GOTO lbl48
            is = connection.getErrorStream();
            rd = null;
            try {
                rd = new BufferedReader(new InputStreamReader(is, "utf-8"));
                response = new StringBuilder();
                while ((line = rd.readLine()) != null) {
                    response.append(line);
                    response.append('\r');
                }
                rd.close();
                var9_16 = response.toString();
                return var9_16;
            }
            catch (Exception e1) {
                e1.printStackTrace();
lbl48:
                // 2 sources

                var5_7 = null;
            }
            return var5_7;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static void setEnvironmentVariables(AbstractBuild build, HashMap<String, String> environmentVariables) {
        for (Map.Entry<String, String> var : environmentVariables.entrySet()) {
            build.addAction((Action)new PublishEnvVarAction(var.getKey(), var.getValue()));
        }
    }

    private static List<String> extractTokens(String text) {
        ArrayList<String> tokens = new ArrayList<String>();
        Pattern pattern = Pattern.compile(REGEX);
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            tokens.add(matcher.group(0).replaceAll("\\$", "").replaceAll("\\{", "").replaceAll("}", ""));
        }
        return tokens;
    }

    private static String tokenizeText(String text, HashMap<String, String> replacements) {
        Pattern pattern = Pattern.compile(REGEX);
        Matcher matcher = pattern.matcher(text);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (matcher.find()) {
            String replacement = replacements.get(matcher.group(1));
            builder.append(text.substring(i, matcher.start()));
            if (replacement == null) {
                builder.append(matcher.group(0));
            } else {
                builder.append(replacement);
            }
            i = matcher.end();
        }
        builder.append(text.substring(i, text.length()));
        return builder.toString();
    }

    private static String getEnvVar(EnvVars envVars, String var) {
        String env = System.getenv(var);
        if (envVars != null && (env == null || env.equals(""))) {
            env = (String)envVars.get((Object)var);
        }
        return env;
    }

    public String getREGEX() {
        return REGEX;
    }
}

