/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.azureeventgridnotifier;

import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.azureeventgridnotifier.BuildPhase;
import org.jenkinsci.plugins.azureeventgridnotifier.MessageData;
import org.jenkinsci.plugins.azureeventgridnotifier.MessageTemplate;
import org.jenkinsci.plugins.azureeventgridnotifier.Utils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class AzureEventGridNotifier
extends Notifier {
    private static final Logger LOG = Logger.getLogger(AzureEventGridNotifier.class.getName());
    private final String topicEndpoint;
    private final String topicKey;
    private final String subjectTemplate;
    private final String messageTemplate;
    private boolean sendNotificationOnStart;
    private boolean notifyOnEveryBuild = true;

    @DataBoundConstructor
    public AzureEventGridNotifier(String topicEndpoint, String topicKey, String subjectTemplate, String messageTemplate, boolean sendNotificationOnStart, boolean notifyOnEveryBuild) {
        this.topicEndpoint = topicEndpoint;
        this.topicKey = topicKey;
        this.subjectTemplate = subjectTemplate;
        this.messageTemplate = messageTemplate;
        this.sendNotificationOnStart = sendNotificationOnStart;
        this.notifyOnEveryBuild = notifyOnEveryBuild;
    }

    public static AzureEventGridNotifier getNotifier(AbstractProject project) {
        Map map = project.getPublishersList().toMap();
        for (Publisher publisher : map.values()) {
            if (!(publisher instanceof AzureEventGridNotifier)) continue;
            return (AzureEventGridNotifier)publisher;
        }
        return null;
    }

    public String getTopicEndpoint() {
        return this.topicEndpoint;
    }

    public String getTopicKey() {
        return this.topicKey;
    }

    public String getSubjectTemplate() {
        return this.subjectTemplate;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public boolean isSendNotificationOnStart() {
        return this.sendNotificationOnStart;
    }

    public boolean isNotifyOnEveryBuild() {
        return this.notifyOnEveryBuild;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public void onStarted(AbstractBuild<?, ?> build, TaskListener listener) {
        if (this.isSendNotificationOnStart()) {
            LOG.info("Prepare Event Grid notification for build started...");
            this.send(build, listener, BuildPhase.STARTED);
        }
    }

    public void onCompleted(AbstractBuild build, TaskListener listener) {
        boolean isNotifyOnEveryBuild = this.isNotifyOnEveryBuild();
        boolean previousBuildSuccessful = this.isPreviousBuildSuccess(build);
        if (isNotifyOnEveryBuild || !isNotifyOnEveryBuild && !previousBuildSuccessful) {
            LOG.info("Prepare Event Grid notification for build completed...");
            this.send(build, listener, BuildPhase.COMPLETED);
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        this.onStarted(build, (TaskListener)listener);
        return true;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.onCompleted(build, (TaskListener)listener);
        return true;
    }

    private void send(AbstractBuild build, TaskListener listener, BuildPhase phase) {
        int length = 100;
        MessageData data = this.setMessageData(build, listener, phase, this.messageTemplate);
        Result result = build.getResult();
        if (result == null) {
            return;
        }
        String subject = StringUtils.isEmpty((String)this.subjectTemplate) ? this.truncate(String.format("Build %s: %s", phase == BuildPhase.STARTED ? "STARTED" : result.toString(), build.getFullDisplayName()), 100) : Utils.fillTemplate(this.subjectTemplate, build, listener);
        LOG.info("Setup Event Grid '" + this.topicEndpoint + "' ...");
        try {
            MessageTemplate message = new MessageTemplate();
            message.setSubject(subject);
            message.setData(data);
            ObjectMapper mapper = new ObjectMapper();
            ArrayList<MessageTemplate> messages = new ArrayList<MessageTemplate>();
            messages.add(message);
            String body = mapper.writeValueAsString(messages);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("aeg-sas-key", this.topicKey);
            String response = Utils.executePost(this.topicEndpoint, headers, body);
            LOG.info(response);
            listener.getLogger().println("Published Event Grid notification: " + body);
        }
        catch (Exception e) {
            listener.error("Failed to send Event Grid notification: " + e.getMessage());
        }
    }

    private boolean isPreviousBuildSuccess(AbstractBuild build) {
        return build.getResult() == Result.SUCCESS && this.findPreviousBuildResult(build) == Result.SUCCESS;
    }

    private Result findPreviousBuildResult(AbstractBuild b) {
        do {
            if ((b = b.getPreviousBuild()) != null && !b.isBuilding()) continue;
            return null;
        } while (b.getResult() == Result.ABORTED || b.getResult() == Result.NOT_BUILT);
        return b.getResult();
    }

    private String truncate(String s, int toLength) {
        if (s.length() > toLength) {
            return s.substring(0, toLength);
        }
        return s;
    }

    private MessageData setMessageData(AbstractBuild build, TaskListener listener, BuildPhase phase, String template) {
        MessageData data = new MessageData();
        Result result = build.getResult();
        if (result == null) {
            return data;
        }
        String phaseString = phase == BuildPhase.STARTED ? "STARTED" : result.toString();
        String artifactPaths = this.artifactPaths(build.getArtifacts());
        HashMap<String, String> envVars = new HashMap<String, String>();
        envVars.put("BUILD_PHASE_NAME", phase.name());
        envVars.put("BUILD_PHASE", phaseString);
        envVars.put("BUILD_DURATION", Long.toString(build.getDuration()));
        envVars.put("BUILD_ARTIFACTS", artifactPaths);
        Utils.setEnvironmentVariables(build, envVars);
        data.setBuildPhase(phase.name());
        data.setArtifactsPaths(artifactPaths);
        data.setBuildResult(phaseString);
        data.setBuildDuration(Long.toString(build.getDuration()));
        data.setCustomMessage(Utils.fillTemplate(template, build, listener));
        return data;
    }

    private String artifactPaths(List<Run.Artifact> artifacts) {
        ArrayList<String> paths = new ArrayList<String>();
        for (Run.Artifact artifact : artifacts) {
            paths.add(artifact.getDisplayPath());
        }
        return StringUtils.join(paths, (String)"\n");
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(AzureEventGridNotifier.class);
            this.load();
        }

        public String getDisplayName() {
            return "Azure Event Grid Notifier";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

