/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.keyvault;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.azure.keyvault.models.SecretBundle;
import com.microsoft.azure.util.AzureCredentials;
import com.microsoft.jenkins.keyvault.KeyVaultClientAuthenticator;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.ListBoxModel;

public class BaseSecretCredentials
extends BaseStandardCredentials {
    private static final long serialVersionUID = 1L;
    private transient SecretGetter secretGetter = SecretGetter.DEFAULT;
    private final String servicePrincipalId;
    private final String secretIdentifier;

    public BaseSecretCredentials(CredentialsScope scope, String id, String description, String servicePrincipalId, String secretIdentifier) {
        super(scope, id, description);
        this.servicePrincipalId = servicePrincipalId;
        this.secretIdentifier = secretIdentifier;
    }

    public String getServicePrincipalId() {
        return this.servicePrincipalId;
    }

    public String getSecretIdentifier() {
        return this.secretIdentifier;
    }

    protected SecretBundle getKeyVaultSecret() {
        if (this.secretGetter == null) {
            this.secretGetter = SecretGetter.DEFAULT;
        }
        return this.secretGetter.getKeyVaultSecret(this.servicePrincipalId, this.secretIdentifier);
    }

    @VisibleForTesting
    void setSecretGetter(SecretGetter secretGetter) {
        this.secretGetter = secretGetter;
    }

    protected static abstract class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        protected DescriptorImpl() {
        }

        public ListBoxModel doFillServicePrincipalIdItems(Item owner) {
            return new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM, owner, AzureCredentials.class);
        }
    }

    static interface SecretGetter {
        public static final SecretGetter DEFAULT = new SecretGetter(){

            @Override
            public SecretBundle getKeyVaultSecret(String aServicePrincipalId, String aSecretIdentifier) {
                AzureCredentials.ServicePrincipal servicePrincipal = AzureCredentials.getServicePrincipal(aServicePrincipalId);
                KeyVaultClient client = new KeyVaultClient((ServiceClientCredentials)new KeyVaultClientAuthenticator(servicePrincipal.getClientId(), servicePrincipal.getClientSecret()));
                return client.getSecret(aSecretIdentifier);
            }
        };

        public SecretBundle getKeyVaultSecret(String var1, String var2);
    }
}

