/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.util;

import com.microsoft.azure.AzureEnvironment;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

public final class AzureEnvUtil {
    static boolean resolveOverride(AzureEnvironment environment, AzureEnvironment.Endpoint endpoint, String stored) {
        if (StringUtils.isBlank((String)stored)) {
            return false;
        }
        String defaultValue = (String)environment.endpoints().get(endpoint.identifier());
        if (StringUtils.isBlank((String)defaultValue)) {
            environment.endpoints().put(endpoint.identifier(), stored);
            return true;
        }
        if (AzureEnvUtil.isOverridden(defaultValue, stored)) {
            environment.endpoints().put(endpoint.identifier(), stored);
            return true;
        }
        return false;
    }

    static boolean isOverridden(String defaultURL, String overrideURL) {
        return StringUtils.isNotBlank((String)overrideURL) && !defaultURL.replaceAll("/+$", "").equalsIgnoreCase(overrideURL.replaceAll("/+$", ""));
    }

    static AzureEnvironment resolveAzureEnv(String envName) {
        AzureEnvironment env = "Azure".equalsIgnoreCase(envName) ? AzureEnvironment.AZURE : ("Azure China".equalsIgnoreCase(envName) ? AzureEnvironment.AZURE_CHINA : ("Azure Germany".equalsIgnoreCase(envName) ? AzureEnvironment.AZURE_GERMANY : ("Azure US Government".equalsIgnoreCase(envName) ? AzureEnvironment.AZURE_US_GOVERNMENT : AzureEnvironment.AZURE)));
        return new AzureEnvironment(new HashMap(env.endpoints()));
    }

    private AzureEnvUtil() {
    }

    public static class Constants {
        static final String ENV_AZURE = "Azure";
        static final String ENV_AZURE_CHINA = "Azure China";
        static final String ENV_AZURE_GERMANY = "Azure Germany";
        static final String ENV_AZURE_US_GOVERNMENT = "Azure US Government";
    }
}

