/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.acs.util;

import com.microsoft.jenkins.acs.Messages;
import com.microsoft.jenkins.azurecommons.Constants;
import hudson.EnvVars;
import hudson.Util;
import hudson.util.VariableResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public final class DeployHelper {
    private DeployHelper() {
    }

    public static String generateRandomDeploymentFileName(String suffix) {
        return "acsDep" + Calendar.getInstance().getTimeInMillis() + "." + suffix;
    }

    public static String escapeSingleQuote(String arg) {
        return arg.replaceAll("[']", "'\"'\"'");
    }

    public static String encodeURIPath(String path) {
        try {
            URI uri = new URI(null, null, path, null);
            return uri.toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String removeVariables(String value) {
        return DeployHelper.replaceVariables(value, "");
    }

    public static String replaceVariables(String value, final String replacement) {
        return Util.replaceMacro((String)value, (VariableResolver)new VariableResolver<String>(){

            public String resolve(String name) {
                return replacement;
            }
        });
    }

    public static boolean checkURIForMarathon(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return false;
        }
        if (path.indexOf(92) >= 0 || path.indexOf(39) >= 0 || path.indexOf(0) >= 0) {
            return false;
        }
        return path.equals(DeployHelper.encodeURIPath(path));
    }

    public static ByteArrayInputStream replaceMacro(InputStream original, EnvVars envVars, boolean enabled) throws IOException {
        try {
            String content = IOUtils.toString((InputStream)original, (Charset)Constants.UTF8);
            if (enabled) {
                content = Util.replaceMacro((String)content, (Map)envVars);
            }
            if (content != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content.getBytes(Constants.UTF8));
                return byteArrayInputStream;
            }
            throw new IllegalArgumentException(Messages.JobContext_nullContent());
        }
        finally {
            original.close();
        }
    }

    public static <T> T getProperty(Object properties, String path, Class<T> type) {
        return DeployHelper.getProperty(properties, "", path, type);
    }

    private static <T> T getProperty(Object properties, String visited, String remain, Class<T> type) {
        if (StringUtils.isBlank((String)remain)) {
            return type.cast(properties);
        }
        if (properties == null || !(properties instanceof Map)) {
            throw new IllegalArgumentException(visited + " is not a map: " + properties);
        }
        Map map = (Map)properties;
        String[] parts = remain.split("\\.", 2);
        remain = parts.length == 2 ? parts[1] : "";
        visited = StringUtils.isEmpty((String)visited) ? parts[0] : visited + "." + parts[0];
        return DeployHelper.getProperty(map.get(parts[0]), visited, remain, type);
    }
}

