/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.acs.util;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.ApplicationTokenCredentials;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.util.AzureCredentials;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public final class DependencyMigration {
    public static AzureTokenCredentials buildAzureTokenCredentials(AzureCredentials.ServicePrincipal servicePrincipal) {
        return new ApplicationTokenCredentials(servicePrincipal.getClientId(), servicePrincipal.getTenant(), servicePrincipal.getClientSecret(), DependencyMigration.buildAzureEnvironment(servicePrincipal));
    }

    public static AzureEnvironment buildAzureEnvironment(AzureCredentials.ServicePrincipal servicePrincipal) {
        String graphEndpoint;
        String resourceManagerEndpoint;
        String activeDirectoryEndpoint;
        String managementEndpoint = servicePrincipal.getServiceManagementURL();
        AzureEnvironment env = DependencyMigration.resolveEnvironment(managementEndpoint, activeDirectoryEndpoint = servicePrincipal.getAuthenticationEndpoint(), resourceManagerEndpoint = servicePrincipal.getResourceManagerEndpoint(), graphEndpoint = servicePrincipal.getGraphEndpoint());
        if (env == null) {
            HashMap<String, String> endpoints = new HashMap<String, String>(AzureEnvironment.AZURE.endpoints());
            endpoints.put("managementEndpointUrl", managementEndpoint);
            endpoints.put("activeDirectoryEndpointUrl", activeDirectoryEndpoint);
            endpoints.put("resourceManagerEndpointUrl", resourceManagerEndpoint);
            endpoints.put("activeDirectoryGraphResourceId", graphEndpoint);
            env = new AzureEnvironment(endpoints);
        }
        return env;
    }

    private static AzureEnvironment resolveEnvironment(String managementEndpointUrl, String activeDirectoryEndpointUrl, String resourceManagerEndpointUrl, String graphEndpointUrl) {
        for (AzureEnvironment env : AzureEnvironment.knownEnvironments()) {
            if (!DependencyMigration.sameUrl(env.managementEndpoint(), managementEndpointUrl) || !DependencyMigration.sameUrl(env.activeDirectoryEndpoint(), activeDirectoryEndpointUrl) || !DependencyMigration.sameUrl(env.resourceManagerEndpoint(), resourceManagerEndpointUrl) || !DependencyMigration.sameUrl(env.graphEndpoint(), graphEndpointUrl)) continue;
            return env;
        }
        return null;
    }

    private static boolean sameUrl(String base, String target) {
        if (StringUtils.isBlank((CharSequence)target)) {
            return false;
        }
        String enrichedBase = base;
        if (!base.endsWith("/")) {
            enrichedBase = base + '/';
        }
        String enrichedTarget = target;
        if (!target.endsWith("/")) {
            enrichedTarget = target + '/';
        }
        return enrichedBase.equals(enrichedTarget);
    }

    private DependencyMigration() {
    }
}

