/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.acs.util;

import com.microsoft.azure.management.containerservice.ContainerServiceOrchestratorTypes;
import com.microsoft.azure.management.network.Protocol;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public final class Constants {
    public static final String PLUGIN_NAME = "AzureJenkinsACS";
    public static final String INVALID_OPTION = "*";
    public static final String KUBECONFIG_FILE = ".kube/config";
    public static final String KUBECONFIG_PREFIX = "kubeconfig-";
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final int PRIORITY_STEP = 10;
    public static final int LOWEST_PRIORITY = 4096;
    public static final Pattern URI_SCHEME_PREFIX = Pattern.compile("^[a-z][a-z0-9+.\\-]*://", 2);
    public static final int KUBERNETES_NAME_LENGTH_LIMIT = 253;
    public static final Pattern KUBERNETES_NAME_PATTERN = Pattern.compile("^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$");
    public static final String KUBERNETES_SECRET_NAME_PREFIX = "acs-plugin-";
    public static final String KUBERNETES_SECRET_NAME_PROP = "KUBERNETES_SECRET_NAME";
    public static final String MARATHON_DOCKER_CFG_ARCHIVE = "docker.tar.gz";
    public static final String MARATHON_DOCKER_CFG_ARCHIVE_URI = "MARATHON_DOCKER_CFG_ARCHIVE_URI";
    public static final Protocol UDP = Protocol.fromString((String)"Udp");
    public static final Set<ContainerServiceOrchestratorTypes> SUPPORTED_ORCHESTRATOR = Collections.unmodifiableSet(new HashSet<ContainerServiceOrchestratorTypes>(Arrays.asList(ContainerServiceOrchestratorTypes.KUBERNETES, ContainerServiceOrchestratorTypes.DCOS, ContainerServiceOrchestratorTypes.SWARM)));
    public static final Set<String> SUPPORTED_ORCHESTRATOR_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(ContainerServiceOrchestratorTypes.KUBERNETES.toString(), ContainerServiceOrchestratorTypes.DCOS.toString(), ContainerServiceOrchestratorTypes.SWARM.toString())));
    public static final String AKS = "AKS";
    public static final String AKS_PROVIDER = "Microsoft.ContainerService";
    public static final String AKS_RESOURCE_TYPE = "managedClusters";
    public static final int DEFAULT_SSH_PORT = 22;
    public static final int DCOS_SSH_PORT = 2200;
    public static final int KUBERNETES_SSH_PORT = 22;
    public static final int SWARM_SSH_PORT = 2200;
    public static final String AI_ACS = "ACS";
    public static final String AI_SWARM = "Swarm";
    public static final String AI_KUBERNETES = "Kubernetes";
    public static final String AI_DCOS = "DCOS";
    public static final String AI_CUSTOM = "Custom";
    public static final String AI_AKS = "AKS";
    public static final String AI_RUN = "Run";
    public static final String AI_ORCHESTRATOR = "Orchestrator";
    public static final String AI_START_DEPLOY = "StartDeploy";
    public static final String AI_DEPLOYED = "Deployed";
    public static final String AI_DEPLOY_FAILED = "DeployFailed";
    public static final String AI_MESSAGE = "ErrorMessage";
    public static final String AI_FQDN = "FQDN";
    public static final String AI_RESOURCE_NAME = "ResourceName";

    public static int sshPort(ContainerServiceOrchestratorTypes type) {
        if (ContainerServiceOrchestratorTypes.DCOS.equals((Object)type)) {
            return 2200;
        }
        if (ContainerServiceOrchestratorTypes.KUBERNETES.equals((Object)type)) {
            return 22;
        }
        if (ContainerServiceOrchestratorTypes.SWARM.equals((Object)type)) {
            return 2200;
        }
        return -1;
    }

    private Constants() {
    }
}

