/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.acs.util;

import com.microsoft.azure.management.Azure;
import com.microsoft.azure.util.AzureBaseCredentials;
import com.microsoft.azure.util.AzureCredentialUtil;
import com.microsoft.jenkins.acs.AzureACSPlugin;
import com.microsoft.jenkins.azurecommons.core.AzureClientFactory;
import com.microsoft.jenkins.azurecommons.core.credentials.TokenCredentialData;
import hudson.model.Item;
import okhttp3.Interceptor;

public final class AzureHelper {
    public static TokenCredentialData getToken(Item owner, String credentialId) {
        AzureBaseCredentials credential = AzureCredentialUtil.getCredential((Item)owner, (String)credentialId);
        if (credential == null) {
            throw new IllegalStateException(String.format("Can't find credential in scope %s with id: %s", owner, credentialId));
        }
        return TokenCredentialData.deserialize((byte[])credential.serializeToTokenData());
    }

    public static Azure buildClient(Item owner, String credentialId) {
        TokenCredentialData token = AzureHelper.getToken(owner, credentialId);
        return AzureHelper.buildClient(token);
    }

    public static Azure buildClient(TokenCredentialData token) {
        return AzureClientFactory.getClient((TokenCredentialData)token, (AzureClientFactory.Configurer)new AzureClientFactory.Configurer(){

            public Azure.Configurable configure(Azure.Configurable configurable) {
                return (Azure.Configurable)((Azure.Configurable)configurable.withInterceptor((Interceptor)new AzureACSPlugin.AzureTelemetryInterceptor())).withUserAgent(AzureClientFactory.getUserAgent((String)"AzureJenkinsACS", (String)AzureHelper.class.getPackage().getImplementationVersion()));
            }
        });
    }

    private AzureHelper() {
    }
}

