/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.acs.orchestrators;

import com.microsoft.azure.management.network.Protocol;
import com.microsoft.jenkins.acs.Messages;
import com.microsoft.jenkins.acs.orchestrators.DeploymentConfig;
import com.microsoft.jenkins.acs.orchestrators.ServicePort;
import com.microsoft.jenkins.acs.util.Constants;
import hudson.FilePath;
import hudson.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.Yaml;

public class SwarmDeploymentConfig
extends DeploymentConfig {
    private static final Pattern PATTERN_PORT_SPEC = Pattern.compile("^(((?<host>[a-fA-F\\d.:]+):)?(?<ext>[\\d]*)(-(?<extEnd>[\\d]+))?:)?(?<int>[\\d]+)(-(?<intEnd>[\\d]+))?(?<proto>/(udp|tcp))?$");

    public SwarmDeploymentConfig(FilePath[] configFiles) {
        super(configFiles);
    }

    @Override
    public String getResourcePrefix() {
        return "swarm";
    }

    @Override
    public List<ServicePort> getServicePorts() throws IOException, DeploymentConfig.InvalidFormatException, InterruptedException {
        FilePath[] configFiles;
        ArrayList<ServicePort> servicePorts = new ArrayList<ServicePort>();
        for (FilePath configFile : configFiles = this.getConfigFiles()) {
            try (InputStream cfgFile = configFile.read();){
                Yaml yaml = new Yaml();
                Map root = (Map)yaml.load(cfgFile);
                boolean isLegacyVersion = !root.containsKey("version");
                Map services = null;
                if (isLegacyVersion) {
                    services = root;
                } else {
                    services = (Map)root.get("services");
                    if (services == null) {
                        throw new DeploymentConfig.InvalidFormatException(Messages.SwarmDeploymentConfig_invalidConfigFormatNodeNotFound(configFile.getRemote(), "services"));
                    }
                }
                for (Object service : services.values()) {
                    Object portsNode = ((Map)service).get("ports");
                    if (!(portsNode instanceof List)) continue;
                    List ports = (List)portsNode;
                    for (Object portNode : ports) {
                        if (portNode instanceof String) {
                            servicePorts.addAll(this.parsePortShortSyntax((String)portNode));
                            continue;
                        }
                        if (portNode instanceof Map) {
                            servicePorts.addAll(this.parsePortLongSyntax((Map)portNode));
                            continue;
                        }
                        throw new DeploymentConfig.InvalidFormatException(Messages.SwarmDeploymentConfig_invalidPortDefinition(portNode.toString(), configFile.getRemote()));
                    }
                }
            }
        }
        return servicePorts;
    }

    private List<ServicePort> parsePortShortSyntax(String def) throws DeploymentConfig.InvalidFormatException {
        int inter;
        Matcher m = PATTERN_PORT_SPEC.matcher(def);
        if (!m.matches()) {
            throw new DeploymentConfig.InvalidFormatException(Messages.SwarmDeploymentConfig_invalidPortSyntax(def));
        }
        String interText = m.group("int");
        String interEndText = m.group("intEnd");
        String extText = m.group("ext");
        String extEndText = m.group("extEnd");
        String protocolText = Util.fixNull((String)m.group("proto"));
        int interEnd = inter = Integer.parseInt(interText);
        if (interEndText != null) {
            interEnd = Integer.parseInt(interEndText);
        }
        int ext = inter;
        if (extText != null) {
            ext = Integer.parseInt(extText);
        }
        int extEnd = extEndText != null ? Integer.parseInt(extEndText) : (interEnd == inter ? ext : interEnd);
        Protocol protocol = Protocol.TCP;
        if (protocolText.equalsIgnoreCase("/udp")) {
            protocol = Constants.UDP;
        }
        if (extEnd - ext != interEnd - inter) {
            throw new DeploymentConfig.InvalidFormatException(Messages.SwarmDeploymentConfig_portRangesDontMatchInLength(def));
        }
        ArrayList<ServicePort> servicePorts = new ArrayList<ServicePort>();
        for (int p = ext; p <= extEnd; ++p) {
            servicePorts.add(new ServicePort(p, inter + p - ext, protocol));
        }
        return servicePorts;
    }

    private List<ServicePort> parsePortLongSyntax(Map node) throws DeploymentConfig.InvalidFormatException {
        String protocolText;
        Object targetNode = node.get("target");
        if (targetNode == null || !(targetNode instanceof Integer)) {
            throw new DeploymentConfig.InvalidFormatException(Messages.SwarmDeploymentConfig_noTargetPort());
        }
        Object publishedNode = node.get("published");
        if (publishedNode == null || !(publishedNode instanceof Integer)) {
            throw new DeploymentConfig.InvalidFormatException(Messages.SwarmDeploymentConfig_noPublishedPort());
        }
        Object protocolNode = node.get("protocol");
        Protocol protocol = Protocol.TCP;
        if (protocolNode != null && protocolNode instanceof String && (protocolText = (String)protocolNode).equalsIgnoreCase("udp")) {
            protocol = Constants.UDP;
        }
        return Arrays.asList(new ServicePort((Integer)publishedNode, (Integer)targetNode, protocol));
    }
}

