/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.acs.orchestrators;

import com.microsoft.azure.management.network.LoadBalancingRule;
import com.microsoft.azure.management.network.Protocol;
import com.microsoft.azure.management.network.TransportProtocol;
import com.microsoft.jenkins.acs.util.Constants;

public class ServicePort {
    private final int hostPort;
    private final int containerPort;
    private final Protocol protocol;

    public ServicePort(int hostPort, int containerPort, Protocol protocol) {
        this.hostPort = hostPort;
        this.containerPort = containerPort;
        this.protocol = protocol;
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public int getContainerPort() {
        return this.containerPort;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public TransportProtocol getTransportProtocol() {
        if (this.protocol.equals((Object)Protocol.TCP)) {
            return TransportProtocol.TCP;
        }
        if (this.protocol.equals((Object)Constants.UDP)) {
            return TransportProtocol.UDP;
        }
        return TransportProtocol.fromString((String)this.protocol.toString());
    }

    public boolean matchesLoadBalancingRule(LoadBalancingRule rule) {
        return rule.frontendPort() == this.hostPort && ((TransportProtocol)rule.protocol()).equals((Object)this.getTransportProtocol());
    }

    public String toString() {
        return String.format("%d:%d/%s", this.hostPort, this.containerPort, this.protocol);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServicePort)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ServicePort other = (ServicePort)obj;
        return this.hostPort == other.hostPort && this.containerPort == other.containerPort && this.protocol == other.protocol;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

