/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.acs.orchestrators;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.management.network.Protocol;
import com.microsoft.jenkins.acs.Messages;
import com.microsoft.jenkins.acs.orchestrators.DeploymentConfig;
import com.microsoft.jenkins.acs.orchestrators.ServicePort;
import com.microsoft.jenkins.acs.util.Constants;
import hudson.FilePath;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MarathonDeploymentConfig
extends DeploymentConfig {
    public MarathonDeploymentConfig(FilePath[] configFiles) {
        super(configFiles);
    }

    @Override
    public String getResourcePrefix() {
        return "dcos";
    }

    @Override
    public List<ServicePort> getServicePorts() throws IOException, InterruptedException, DeploymentConfig.InvalidFormatException {
        ArrayList<ServicePort> servicePorts = new ArrayList<ServicePort>();
        for (FilePath configFile : this.getConfigFiles()) {
            try (InputStream cfgFile = configFile.read();){
                JsonNode node;
                ObjectMapper mapper = new ObjectMapper();
                try {
                    node = mapper.readTree(cfgFile);
                }
                catch (JsonProcessingException e) {
                    throw new DeploymentConfig.InvalidFormatException((Exception)((Object)e));
                }
                if (node == null) {
                    throw new DeploymentConfig.InvalidFormatException("no content");
                }
                String[] fieldKeys = new String[]{"container", "docker", "portMappings"};
                for (int i = 0; i < fieldKeys.length; ++i) {
                    String fieldKey = fieldKeys[i];
                    if ((node = node.get(fieldKey)) != null) continue;
                    throw new DeploymentConfig.InvalidFormatException(Messages.MarathonDeploymentConfig_invalidConfigFormatNodeNotFound(configFile.getRemote(), fieldKey));
                }
                Iterator elements = node.elements();
                while (elements.hasNext()) {
                    JsonNode element = (JsonNode)elements.next();
                    JsonNode containerPortNode = element.get("containerPort");
                    if (containerPortNode == null) {
                        throw new DeploymentConfig.InvalidFormatException(Messages.MarathonDeploymentConfig_invalidConfigFormatNodeNotFound(configFile.getRemote(), "container.docker.portMapping[].containerPort"));
                    }
                    int containerPort = containerPortNode.asInt();
                    JsonNode hostPortNode = element.get("hostPort");
                    if (hostPortNode == null) {
                        throw new DeploymentConfig.InvalidFormatException(Messages.MarathonDeploymentConfig_invalidConfigFormatNodeNotFound(configFile.getRemote(), "container.docker.portMapping[].hostPort"));
                    }
                    int hostPort = hostPortNode.asInt();
                    Protocol protocol = Protocol.TCP;
                    JsonNode protocolNode = element.get("protocol");
                    if (protocolNode != null && protocolNode.asText().equalsIgnoreCase("udp")) {
                        protocol = Constants.UDP;
                    }
                    servicePorts.add(new ServicePort(hostPort, containerPort, protocol));
                }
            }
        }
        return servicePorts;
    }
}

