/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.acs.orchestrators;

import com.microsoft.azure.management.containerservice.ContainerServiceOrchestratorTypes;
import com.microsoft.jenkins.acs.Messages;
import com.microsoft.jenkins.acs.orchestrators.KubernetesDeploymentConfig;
import com.microsoft.jenkins.acs.orchestrators.MarathonDeploymentConfig;
import com.microsoft.jenkins.acs.orchestrators.ServicePort;
import com.microsoft.jenkins.acs.orchestrators.SwarmDeploymentConfig;
import hudson.EnvVars;
import hudson.FilePath;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public abstract class DeploymentConfig
implements Serializable {
    private FilePath[] configFiles;

    public DeploymentConfig(FilePath[] configFiles) {
        this.configFiles = (FilePath[])Arrays.stream(configFiles).toArray(FilePath[]::new);
    }

    public FilePath[] getConfigFiles() {
        return (FilePath[])Arrays.stream(this.configFiles).toArray(FilePath[]::new);
    }

    public abstract String getResourcePrefix();

    public abstract List<ServicePort> getServicePorts() throws IOException, InvalidFormatException, InterruptedException;

    public static class Factory
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String configFilePaths;

        public Factory(String configFilePaths) {
            this.configFilePaths = configFilePaths;
        }

        public DeploymentConfig build(ContainerServiceOrchestratorTypes type, FilePath workspace, EnvVars envVars) throws IOException, InterruptedException {
            String expandedConfigFilePaths = envVars.expand(this.configFilePaths);
            FilePath[] configFiles = workspace.list(expandedConfigFilePaths);
            if (configFiles.length == 0) {
                throw new IllegalArgumentException(Messages.ACSDeploymentContext_noConfigFilesFound(this.configFilePaths));
            }
            if (ContainerServiceOrchestratorTypes.DCOS.equals((Object)type)) {
                return new MarathonDeploymentConfig(configFiles);
            }
            if (ContainerServiceOrchestratorTypes.KUBERNETES.equals((Object)type)) {
                return new KubernetesDeploymentConfig(configFiles);
            }
            if (ContainerServiceOrchestratorTypes.SWARM.equals((Object)type)) {
                return new SwarmDeploymentConfig(configFiles);
            }
            throw new IllegalArgumentException(Messages.ACSDeploymentContext_orchestratorNotSupported(type));
        }

        public DeploymentConfig buildForAKS(FilePath workspace, EnvVars envVars) throws IOException, InterruptedException {
            String expandedConfigFilePaths = envVars.expand(this.configFilePaths);
            FilePath[] configFiles = workspace.list(expandedConfigFilePaths);
            if (configFiles.length == 0) {
                throw new IllegalArgumentException(Messages.ACSDeploymentContext_noConfigFilesFound(this.configFilePaths));
            }
            return new KubernetesDeploymentConfig(configFiles);
        }
    }

    public static final class InvalidFormatException
    extends Exception {
        public InvalidFormatException(String msg) {
            super(msg);
        }

        public InvalidFormatException(Exception ex) {
            super(ex);
        }
    }
}

