/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.acs.commands;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.microsoft.azure.management.containerservice.ContainerServiceOrchestratorTypes;
import com.microsoft.jenkins.acs.AzureACSPlugin;
import com.microsoft.jenkins.acs.Messages;
import com.microsoft.jenkins.acs.orchestrators.DeploymentConfig;
import com.microsoft.jenkins.acs.util.DeployHelper;
import com.microsoft.jenkins.azurecommons.JobContext;
import com.microsoft.jenkins.azurecommons.command.CommandState;
import com.microsoft.jenkins.azurecommons.command.IBaseCommandData;
import com.microsoft.jenkins.azurecommons.command.ICommand;
import com.microsoft.jenkins.azurecommons.remote.SSHClient;
import com.microsoft.jenkins.azurecommons.telemetry.AppInsightsUtils;
import com.microsoft.jenkins.kubernetes.credentials.ResolvedDockerRegistryEndpoint;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.List;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public class SwarmDeploymentCommand
implements ICommand<ISwarmDeploymentCommandData>,
Serializable {
    private static final long serialVersionUID = 1L;

    public void execute(ISwarmDeploymentCommandData context) {
        JobContext jobContext = context.getJobContext();
        final FilePath workspace = jobContext.getWorkspace();
        final TaskListener taskListener = jobContext.getTaskListener();
        final EnvVars envVars = context.getEnvVars();
        final String host = context.getMgmtFQDN();
        final SSHUserPrivateKey sshCredentials = context.getSshCredentials();
        final boolean enableSubstitution = context.isEnableConfigSubstitution();
        final boolean swarmRemoveContainerFirst = context.isSwarmRemoveContainersFirst();
        final DeploymentConfig.Factory configFactory = new DeploymentConfig.Factory(context.getConfigFilePaths());
        final ContainerServiceOrchestratorTypes orchestratorType = context.getOrchestratorType();
        try {
            final List<ResolvedDockerRegistryEndpoint> registryCredentials = context.resolvedDockerRegistryEndpoints((Item)jobContext.getRun().getParent());
            CommandState state = (CommandState)workspace.act((Callable)new MasterToSlaveCallable<CommandState, Exception>(){
                private static final long serialVersionUID = 1L;

                public CommandState call() throws Exception {
                    PrintStream logger = taskListener.getLogger();
                    DeploymentConfig deploymentConfig = configFactory.build(orchestratorType, workspace, envVars);
                    FilePath[] configFiles = deploymentConfig.getConfigFiles();
                    SSHClient client = new SSHClient(host, 2200, (StandardUsernameCredentials)sshCredentials).withLogger(logger);
                    try (SSHClient connected = client.connect();){
                        SwarmDeploymentCommand.prepareCredentialsForSwarm(connected, registryCredentials, logger);
                        for (FilePath configFile : configFiles) {
                            String deployedFilename = DeployHelper.generateRandomDeploymentFileName("yml");
                            logger.println(Messages.SwarmDeploymentCommand_copyConfigFileTo(configFile.getRemote(), connected.getHost(), deployedFilename));
                            connected.copyTo((InputStream)DeployHelper.replaceMacro(configFile.read(), envVars, enableSubstitution), deployedFilename);
                            String escapedName = DeployHelper.escapeSingleQuote(deployedFilename);
                            if (swarmRemoveContainerFirst) {
                                logger.println(Messages.SwarmDeploymentCommand_removingDockerContainers());
                                try {
                                    connected.execRemote(String.format("DOCKER_HOST=:2375 docker-compose -f '%s' down", escapedName));
                                }
                                catch (SSHClient.ExitStatusException ex) {
                                    logger.println(ex.getMessage());
                                }
                            }
                            logger.println(Messages.SwarmDeploymentCommand_updatingDockerContainers());
                            connected.execRemote(String.format("DOCKER_HOST=:2375 docker-compose -f '%s' up -d", escapedName));
                            logger.println(Messages.SwarmDeploymentCommand_removeTempFile(deployedFilename));
                            connected.execRemote(String.format("rm -f -- '%s'", escapedName));
                        }
                    }
                    return CommandState.Success;
                }
            });
            String action = state.isError() ? "DeployFailed" : "Deployed";
            AzureACSPlugin.sendEventFor(action, "Swarm", jobContext.getRun(), "FQDN", AppInsightsUtils.hash((String)host));
            context.setCommandState(state);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            context.logError(e);
            AzureACSPlugin.sendEventFor("DeployFailed", "Swarm", jobContext.getRun(), "FQDN", AppInsightsUtils.hash((String)host), "ErrorMessage", e.getMessage());
        }
    }

    @VisibleForTesting
    static void prepareCredentialsForSwarm(SSHClient client, List<ResolvedDockerRegistryEndpoint> registryCredentials, PrintStream logger) throws Exception {
        for (ResolvedDockerRegistryEndpoint endpoint : registryCredentials) {
            String auth = StringUtils.trimToEmpty((String)endpoint.getToken().getToken());
            if (StringUtils.isEmpty((String)auth)) {
                throw new IllegalArgumentException(Messages.SwarmDeploymentConfig_noAuthTokenFor(endpoint));
            }
            String decoded = new String(Base64.decodeBase64((String)auth), "UTF-8");
            String[] parts = decoded.split(":", 2);
            if (parts.length != 2) {
                throw new IllegalArgumentException(Messages.SwarmDeploymentConfig_malformedAuthTokenFor(endpoint));
            }
            String username = parts[0];
            String password = parts[1];
            String server = endpoint.getUrl().toString();
            String command = String.format("docker login -u '%s' -p '%s' '%s'", DeployHelper.escapeSingleQuote(username), DeployHelper.escapeSingleQuote(password), DeployHelper.escapeSingleQuote(server));
            logger.println(Messages.SwarmDeploymentConfig_addCredentialsFor(server));
            client.execRemote(command, false, false);
        }
    }

    public static interface ISwarmDeploymentCommandData
    extends IBaseCommandData {
        public String getMgmtFQDN();

        public SSHUserPrivateKey getSshCredentials();

        public String getConfigFilePaths();

        public ContainerServiceOrchestratorTypes getOrchestratorType();

        public boolean isEnableConfigSubstitution();

        public boolean isSwarmRemoveContainersFirst();

        public List<ResolvedDockerRegistryEndpoint> resolvedDockerRegistryEndpoints(Item var1) throws IOException;
    }
}

