/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.acs.commands;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.jcraft.jsch.JSchException;
import com.microsoft.azure.management.containerservice.ContainerServiceOrchestratorTypes;
import com.microsoft.jenkins.acs.AzureACSPlugin;
import com.microsoft.jenkins.acs.Messages;
import com.microsoft.jenkins.acs.orchestrators.DeploymentConfig;
import com.microsoft.jenkins.acs.util.DeployHelper;
import com.microsoft.jenkins.acs.util.JsonHelper;
import com.microsoft.jenkins.azurecommons.EnvironmentInjector;
import com.microsoft.jenkins.azurecommons.JobContext;
import com.microsoft.jenkins.azurecommons.command.CommandState;
import com.microsoft.jenkins.azurecommons.command.IBaseCommandData;
import com.microsoft.jenkins.azurecommons.command.ICommand;
import com.microsoft.jenkins.azurecommons.remote.SSHClient;
import com.microsoft.jenkins.azurecommons.telemetry.AppInsightsUtils;
import com.microsoft.jenkins.kubernetes.credentials.ResolvedDockerRegistryEndpoint;
import com.microsoft.jenkins.kubernetes.util.DockerConfigBuilder;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang.StringUtils;

public class MarathonDeploymentCommand
implements ICommand<IMarathonDeploymentCommandData>,
Serializable {
    private static final long serialVersionUID = 1L;

    public void execute(IMarathonDeploymentCommandData context) {
        JobContext jobContext = context.getJobContext();
        final TaskListener taskListener = jobContext.getTaskListener();
        final String host = context.getMgmtFQDN();
        final SSHUserPrivateKey sshCredentials = context.getSshCredentials();
        final FilePath workspace = jobContext.getWorkspace();
        final EnvVars envVars = context.getEnvVars();
        final String dockerCredentialsPath = context.getDcosDockerCredentialsPath();
        final boolean dcosDockerCredenditalsPathShared = context.isDcosDockerCredenditalsPathShared();
        final boolean enableSubstitution = context.isEnableConfigSubstitution();
        final String credentialsDirectoryName = MarathonDeploymentCommand.nameForBuild(jobContext);
        final DeploymentConfig.Factory deploymentConfigFactory = new DeploymentConfig.Factory(context.getConfigFilePaths());
        final ContainerServiceOrchestratorTypes orchestratorType = context.getOrchestratorType();
        try {
            final List<ResolvedDockerRegistryEndpoint> dockerCredentials = context.resolvedDockerRegistryEndpoints((Item)jobContext.getRun().getParent());
            TaskResult taskResult = (TaskResult)workspace.act((Callable)new MasterToSlaveCallable<TaskResult, Exception>(){
                private static final long serialVersionUID = 1L;

                public TaskResult call() throws Exception {
                    TaskResult result = new TaskResult();
                    PrintStream logger = taskListener.getLogger();
                    DeploymentConfig config = deploymentConfigFactory.build(orchestratorType, workspace, envVars);
                    FilePath[] configPaths = config.getConfigFiles();
                    if (configPaths == null || configPaths.length == 0) {
                        logger.println(Messages.MarathonDeploymentCommand_configNotFound());
                        result.commandState = CommandState.HasError;
                        return result;
                    }
                    SSHClient client = new SSHClient(host, 2200, (StandardUsernameCredentials)sshCredentials).withLogger(logger);
                    try (SSHClient connected = client.connect();){
                        Map<String, String> extraEnvVars = MarathonDeploymentCommand.this.copyCredentialsToAgents(connected, sshCredentials.getUsername(), workspace, dockerCredentialsPath, dcosDockerCredenditalsPathShared, credentialsDirectoryName, dockerCredentials, envVars, logger);
                        result.extraEnvVars.putAll(extraEnvVars);
                        for (FilePath configPath : configPaths) {
                            String deployedFilename = DeployHelper.generateRandomDeploymentFileName("json");
                            logger.println(Messages.MarathonDeploymentCommand_copyConfigFileTo(configPath.toURI(), connected.getHost(), deployedFilename));
                            ByteArrayInputStream in = DeployHelper.replaceMacro(configPath.read(), envVars, enableSubstitution);
                            connected.copyTo((InputStream)in, deployedFilename);
                            in.reset();
                            String appId = JsonHelper.getMarathonAppId(in);
                            logger.println(Messages.MarathonDeploymentCommand_deletingApp(appId));
                            connected.execRemote(String.format("curl -i -X DELETE 'http://localhost/marathon/v2/apps/%s'", DeployHelper.escapeSingleQuote(appId)));
                            logger.println(Messages.MarathonDeploymentCommand_deployingApp(deployedFilename, appId));
                            connected.execRemote(String.format("curl -i -H 'Content-Type: application/json' -d@'%s' http://localhost/marathon/v2/apps?force=true", DeployHelper.escapeSingleQuote(deployedFilename)));
                            logger.println(Messages.MarathonDeploymentCommand_removeTempFile(deployedFilename));
                            connected.execRemote(String.format("rm -f -- '%s'", DeployHelper.escapeSingleQuote(deployedFilename)));
                            result.commandState = CommandState.Success;
                        }
                    }
                    return result;
                }
            });
            for (Map.Entry entry : taskResult.extraEnvVars.entrySet()) {
                EnvironmentInjector.inject((Run)jobContext.getRun(), (EnvVars)envVars, (String)((String)entry.getKey()), entry.getValue());
            }
            String action = taskResult.commandState.isError() ? "DeployFailed" : "Deployed";
            AzureACSPlugin.sendEventFor(action, "DCOS", jobContext.getRun(), "FQDN", AppInsightsUtils.hash((String)host));
            context.setCommandState(taskResult.commandState);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            context.logError(e);
            AzureACSPlugin.sendEventFor("DeployFailed", "DCOS", jobContext.getRun(), "FQDN", AppInsightsUtils.hash((String)host), "ErrorMessage", e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Map<String, String> copyCredentialsToAgents(SSHClient client, String linuxAdminUsername, FilePath workspace, String dockerCredentialsPath, boolean dcosDockerCredenditalsPathShared, String credentialsDirectoryName, List<ResolvedDockerRegistryEndpoint> dockerCredentials, EnvVars envVars, PrintStream logger) throws Exception {
        if (dockerCredentials.isEmpty()) {
            return ImmutableMap.of();
        }
        DockerConfigBuilder configBuilder = new DockerConfigBuilder(dockerCredentials);
        FilePath dockercfg = configBuilder.buildArchive(workspace);
        try {
            String remotePath = MarathonDeploymentCommand.prepareCredentialsPath(dockerCredentialsPath, credentialsDirectoryName, envVars, linuxAdminUsername);
            String dockerArchivePath = remotePath + "/" + "docker.tar.gz";
            List<String> agents = MarathonDeploymentCommand.getAgentNodes(client);
            for (String agent : agents) {
                logger.println(Messages.MarathonDeploymentCommand_prepareDockerCredentialsFor(agent));
                SSHClient forwardClient = client.forwardSSH(agent, 22).withLogger(logger);
                SSHClient connected = forwardClient.connect();
                Throwable throwable = null;
                try {
                    connected.execRemote(String.format("mkdir -p -- '%s'", DeployHelper.escapeSingleQuote(remotePath)));
                    logger.println(Messages.MarathonDeploymentCommand_copyDockerCfgTo(dockercfg.getRemote(), agent, dockerArchivePath));
                    connected.copyTo(dockercfg.read(), dockerArchivePath);
                    if (!dcosDockerCredenditalsPathShared) continue;
                    logger.println(Messages.MarathonDeploymentCommand_skipAsPathShared());
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (connected == null) continue;
                    if (throwable != null) {
                        try {
                            connected.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    connected.close();
                }
            }
            if (!DeployHelper.checkURIForMarathon(dockerArchivePath)) {
                logger.println(Messages.MarathonDeploymentCommand_uriNotAccepted());
            }
            String archiveUri = "file://" + DeployHelper.encodeURIPath(dockerArchivePath);
            logger.println(Messages.MarathonDeploymentCommand_injectEnvironmentVar("MARATHON_DOCKER_CFG_ARCHIVE_URI", archiveUri));
            envVars.put("MARATHON_DOCKER_CFG_ARCHIVE_URI", archiveUri);
            ImmutableMap immutableMap = ImmutableMap.of((Object)"MARATHON_DOCKER_CFG_ARCHIVE_URI", (Object)archiveUri);
            return immutableMap;
        }
        finally {
            dockercfg.delete();
        }
    }

    private static List<String> getAgentNodes(SSHClient client) throws Exception {
        String command = "curl http://leader.mesos:1050/system/health/v1/nodes";
        String output = client.execRemote("curl http://leader.mesos:1050/system/health/v1/nodes");
        List<String> hosts = MarathonDeploymentCommand.getAgentNodes(output);
        if (hosts.isEmpty()) {
            throw new JSchException(Messages.MarathonDeploymentCommand_noAgentFound());
        }
        return hosts;
    }

    @VisibleForTesting
    static List<String> getAgentNodes(String json) {
        JsonNode root;
        ObjectMapper mapper = new ObjectMapper();
        try {
            root = mapper.readTree(json);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot parse JSON object from: " + json, e);
        }
        ArrayList<String> agentNodes = new ArrayList<String>();
        JsonNode nodes = root.get("nodes");
        if (nodes == null || nodes.getNodeType() != JsonNodeType.ARRAY) {
            return agentNodes;
        }
        ArrayNode nodesArray = (ArrayNode)nodes;
        for (JsonNode node : nodesArray) {
            if ("master".equals(node.get("role").textValue())) continue;
            agentNodes.add(node.get("host_ip").textValue());
        }
        return agentNodes;
    }

    @VisibleForTesting
    static String prepareCredentialsPath(String dcosDockerCredentialsPath, String credentialsDirectoryName, EnvVars envVars, String linuxAdminUsername) {
        String name = StringUtils.trimToEmpty((String)envVars.expand(dcosDockerCredentialsPath));
        if (StringUtils.isNotBlank((String)name)) {
            if (name.charAt(0) != '/') {
                throw new IllegalArgumentException(Messages.MarathonDeploymentCommand_relativePathNotAllowed(name));
            }
            if ((name = name.replaceAll("/+$", "")).isEmpty()) {
                name = "/";
            }
            return name;
        }
        return "/home/" + linuxAdminUsername + "/acs-plugin-dcos.docker/" + credentialsDirectoryName;
    }

    @VisibleForTesting
    static String nameForBuild(JobContext jobContext) {
        String runName = StringUtils.trimToEmpty((String)(jobContext.getRun().getParent().getName() + jobContext.getRun().getDisplayName()));
        if (StringUtils.isBlank((String)runName)) {
            runName = UUID.randomUUID().toString();
        }
        return "acs-plugin-dcos-" + runName.replaceAll("[^0-9a-zA-Z]", "-").toLowerCase();
    }

    public static interface IMarathonDeploymentCommandData
    extends IBaseCommandData {
        public String getMgmtFQDN();

        public SSHUserPrivateKey getSshCredentials();

        public String getConfigFilePaths();

        public ContainerServiceOrchestratorTypes getOrchestratorType();

        public boolean isEnableConfigSubstitution();

        public String getDcosDockerCredentialsPath();

        public boolean isDcosDockerCredenditalsPathShared();

        public List<ResolvedDockerRegistryEndpoint> resolvedDockerRegistryEndpoints(Item var1) throws IOException;
    }

    private static class TaskResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private CommandState commandState = CommandState.Unknown;
        private final Map<String, String> extraEnvVars = new HashMap<String, String>();

        private TaskResult() {
        }
    }
}

