/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.acs.commands;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.microsoft.azure.management.containerservice.ContainerServiceOrchestratorTypes;
import com.microsoft.jenkins.acs.AzureACSPlugin;
import com.microsoft.jenkins.acs.Messages;
import com.microsoft.jenkins.acs.orchestrators.DeploymentConfig;
import com.microsoft.jenkins.azurecommons.EnvironmentInjector;
import com.microsoft.jenkins.azurecommons.JobContext;
import com.microsoft.jenkins.azurecommons.command.CommandState;
import com.microsoft.jenkins.azurecommons.command.IBaseCommandData;
import com.microsoft.jenkins.azurecommons.command.ICommand;
import com.microsoft.jenkins.azurecommons.remote.SSHClient;
import com.microsoft.jenkins.azurecommons.telemetry.AppInsightsUtils;
import com.microsoft.jenkins.kubernetes.credentials.ResolvedDockerRegistryEndpoint;
import com.microsoft.jenkins.kubernetes.wrapper.KubernetesClientWrapper;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.util.VariableResolver;
import io.kubernetes.client.openapi.ApiClient;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang.StringUtils;

public abstract class KubernetesDeploymentCommandBase<T extends IKubernetesDeploymentCommandData>
implements ICommand<T> {
    public void execute(T context) {
        KubernetesDeployWorker worker = new KubernetesDeployWorker();
        this.doExecute(context, worker);
    }

    void doExecute(T context, KubernetesDeployWorker worker) {
        JobContext jobContext = context.getJobContext();
        FilePath workspace = jobContext.getWorkspace();
        EnvVars envVars = context.getEnvVars();
        String managementFqdn = context.getMgmtFQDN();
        String aiType = AzureACSPlugin.normalizeContainerSerivceType(context.getContainerServiceType());
        worker.setWorkspace(workspace);
        worker.setTaskListener(jobContext.getTaskListener());
        worker.setEnvVars(envVars);
        worker.setManagementFqdn(managementFqdn);
        worker.setSshCredentials(context.getSshCredentials());
        worker.setSecretNameCfg(context.getSecretName());
        worker.setDefaultSecretName(jobContext.getRun().getDisplayName());
        worker.setKubernetesNamespaceCfg(StringUtils.trimToNull((String)Util.replaceMacro((String)context.getSecretNamespace(), (Map)envVars)));
        worker.setEnableSubstitution(context.isEnableConfigSubstitution());
        worker.setConfigFactory(new DeploymentConfig.Factory(context.getConfigFilePaths()));
        worker.setOrchestratorType(context.getOrchestratorType());
        try {
            List<ResolvedDockerRegistryEndpoint> registryCredentials = context.resolvedDockerRegistryEndpoints((Item)jobContext.getRun().getParent());
            worker.setRegistryCredentials(registryCredentials);
            TaskResult taskResult = (TaskResult)workspace.act((Callable)worker);
            for (Map.Entry<String, String> entry : taskResult.getExtraEnvVars().entrySet()) {
                EnvironmentInjector.inject((Run)jobContext.getRun(), (EnvVars)envVars, (String)entry.getKey(), (Object)entry.getValue());
            }
            String action = taskResult.getCommandState().isError() ? "DeployFailed" : "Deployed";
            AzureACSPlugin.sendEventFor(action, aiType, jobContext.getRun(), "FQDN", AppInsightsUtils.hash((String)taskResult.getMasterHost()));
            context.setCommandState(taskResult.getCommandState());
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            context.logError(e);
            AzureACSPlugin.sendEventFor("DeployFailed", aiType, jobContext.getRun(), "FQDN", AppInsightsUtils.hash((String)managementFqdn), "ErrorMessage", e.getMessage());
        }
    }

    public static interface IKubernetesDeploymentCommandData
    extends IBaseCommandData {
        public String getMgmtFQDN();

        public SSHUserPrivateKey getSshCredentials();

        public String getSecretNamespace();

        public String getConfigFilePaths();

        public ContainerServiceOrchestratorTypes getOrchestratorType();

        public String getContainerServiceType();

        public String getContainerServiceName();

        public boolean isEnableConfigSubstitution();

        public String getSecretName();

        public List<ResolvedDockerRegistryEndpoint> resolvedDockerRegistryEndpoints(Item var1) throws IOException;
    }

    static class KubernetesDeployWorker
    extends MasterToSlaveCallable<TaskResult, Exception> {
        private static final long serialVersionUID = -1307651925021528450L;
        private TaskListener taskListener;
        private DeploymentConfig.Factory configFactory;
        private transient ContainerServiceOrchestratorTypes orchestratorType;
        private FilePath workspace;
        private EnvVars envVars;
        private String managementFqdn;
        private SSHUserPrivateKey sshCredentials;
        private List<ResolvedDockerRegistryEndpoint> registryCredentials;
        private String secretNameCfg;
        private String defaultSecretName;
        private String kubernetesNamespaceCfg;
        private boolean enableSubstitution;

        KubernetesDeployWorker() {
        }

        protected FilePath[] resolveConfigFiles() throws IOException, InterruptedException {
            DeploymentConfig deploymentConfig = this.configFactory.build(this.orchestratorType, this.workspace, this.envVars);
            return deploymentConfig.getConfigFiles();
        }

        protected void prepareKubeconfig(FilePath kubeconfigFile) throws Exception {
            SSHClient sshClient = new SSHClient(this.managementFqdn, 22, (StandardUsernameCredentials)this.sshCredentials).withLogger(this.taskListener.getLogger());
            try (SSHClient connected = sshClient.connect();
                 OutputStream out = kubeconfigFile.write();){
                connected.copyFrom(".kube/config", out);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TaskResult call() throws Exception {
            TaskResult result = new TaskResult();
            PrintStream logger = this.taskListener.getLogger();
            FilePath[] configFiles = this.resolveConfigFiles();
            FilePath kubeconfigFile = this.workspace.createTempFile("kubeconfig-", "");
            try {
                this.prepareKubeconfig(kubeconfigFile);
                KubernetesClientWrapper clientWrapper = new KubernetesClientWrapper(kubeconfigFile.getRemote()).withLogger(logger);
                if (!this.registryCredentials.isEmpty()) {
                    String secretName = KubernetesClientWrapper.prepareSecretName((String)this.secretNameCfg, (String)this.defaultSecretName, (EnvVars)this.envVars);
                    clientWrapper.createOrReplaceSecrets(this.kubernetesNamespaceCfg, secretName, this.registryCredentials);
                    logger.println(Messages.KubernetesDeploymentCommand_injectSecretName("KUBERNETES_SECRET_NAME", secretName));
                    this.envVars.put("KUBERNETES_SECRET_NAME", secretName);
                    result.getExtraEnvVars().put("KUBERNETES_SECRET_NAME", secretName);
                }
                if (this.enableSubstitution) {
                    clientWrapper.withVariableResolver((VariableResolver)new VariableResolver.ByMap((Map)this.envVars));
                }
                result.setMasterHost(this.getMasterHost(clientWrapper));
                clientWrapper.apply(configFiles);
                result.setCommandState(CommandState.Success);
                TaskResult taskResult = result;
                return taskResult;
            }
            finally {
                logger.println(Messages.KubernetesDeploymentCommand_deleteConfigFile(kubeconfigFile.getRemote()));
                try {
                    if (!kubeconfigFile.delete()) {
                        logger.println(Messages.KubernetesDeploymentCommand_failedToDeleteFile(kubeconfigFile.getRemote()));
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.println(Messages.KubernetesDeploymentCommand_failedToDeleteFile(e.getMessage()));
                }
                catch (Exception e) {
                    logger.println(Messages.KubernetesDeploymentCommand_failedToDeleteFile(e.getMessage()));
                }
            }
        }

        String getMasterHost(KubernetesClientWrapper wrapper) {
            String unknown = "Unknown";
            if (wrapper == null) {
                return "Unknown";
            }
            ApiClient client = wrapper.getClient();
            if (client == null) {
                return "Unknown";
            }
            return client.getBasePath();
        }

        public TaskListener getTaskListener() {
            return this.taskListener;
        }

        public void setTaskListener(TaskListener taskListener) {
            this.taskListener = taskListener;
        }

        public DeploymentConfig.Factory getConfigFactory() {
            return this.configFactory;
        }

        public void setConfigFactory(DeploymentConfig.Factory configFactory) {
            this.configFactory = configFactory;
        }

        public ContainerServiceOrchestratorTypes getOrchestratorType() {
            return this.orchestratorType;
        }

        public void setOrchestratorType(ContainerServiceOrchestratorTypes orchestratorType) {
            this.orchestratorType = orchestratorType;
        }

        public FilePath getWorkspace() {
            return this.workspace;
        }

        public void setWorkspace(FilePath workspace) {
            this.workspace = workspace;
        }

        public EnvVars getEnvVars() {
            return this.envVars;
        }

        public void setEnvVars(EnvVars envVars) {
            this.envVars = envVars;
        }

        public String getManagementFqdn() {
            return this.managementFqdn;
        }

        public void setManagementFqdn(String managementFqdn) {
            this.managementFqdn = managementFqdn;
        }

        public SSHUserPrivateKey getSshCredentials() {
            return this.sshCredentials;
        }

        public void setSshCredentials(SSHUserPrivateKey sshCredentials) {
            this.sshCredentials = sshCredentials;
        }

        public List<ResolvedDockerRegistryEndpoint> getRegistryCredentials() {
            return this.registryCredentials;
        }

        public void setRegistryCredentials(List<ResolvedDockerRegistryEndpoint> registryCredentials) {
            this.registryCredentials = registryCredentials;
        }

        public String getSecretNameCfg() {
            return this.secretNameCfg;
        }

        public void setSecretNameCfg(String secretNameCfg) {
            this.secretNameCfg = secretNameCfg;
        }

        public String getDefaultSecretName() {
            return this.defaultSecretName;
        }

        public void setDefaultSecretName(String defaultSecretName) {
            this.defaultSecretName = defaultSecretName;
        }

        public String getKubernetesNamespaceCfg() {
            return this.kubernetesNamespaceCfg;
        }

        public void setKubernetesNamespaceCfg(String kubernetesNamespaceCfg) {
            this.kubernetesNamespaceCfg = kubernetesNamespaceCfg;
        }

        public boolean isEnableSubstitution() {
            return this.enableSubstitution;
        }

        public void setEnableSubstitution(boolean enableSubstitution) {
            this.enableSubstitution = enableSubstitution;
        }
    }

    static class TaskResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private CommandState commandState = CommandState.Unknown;
        private Map<String, String> extraEnvVars = new HashMap<String, String>();
        private String masterHost;

        TaskResult() {
        }

        CommandState getCommandState() {
            return this.commandState;
        }

        void setCommandState(CommandState commandState) {
            this.commandState = commandState;
        }

        Map<String, String> getExtraEnvVars() {
            return this.extraEnvVars;
        }

        public void setExtraEnvVars(Map<String, String> extraEnvVars) {
            this.extraEnvVars = extraEnvVars;
        }

        String getMasterHost() {
            return this.masterHost;
        }

        void setMasterHost(String masterHost) {
            this.masterHost = masterHost;
        }
    }
}

