/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.acs.commands;

import com.google.common.annotations.VisibleForTesting;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.containerservice.ContainerService;
import com.microsoft.azure.management.containerservice.ContainerServiceOrchestratorTypes;
import com.microsoft.jenkins.acs.AzureACSPlugin;
import com.microsoft.jenkins.acs.Messages;
import com.microsoft.jenkins.acs.util.AzureHelper;
import com.microsoft.jenkins.azurecommons.JobContext;
import com.microsoft.jenkins.azurecommons.command.CommandState;
import com.microsoft.jenkins.azurecommons.command.IBaseCommandData;
import com.microsoft.jenkins.azurecommons.command.ICommand;
import com.microsoft.jenkins.azurecommons.core.credentials.TokenCredentialData;
import com.microsoft.jenkins.azurecommons.telemetry.AppInsightsUtils;
import hudson.FilePath;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.PrintStream;
import java.io.Serializable;
import jenkins.security.MasterToSlaveCallable;

public class GetContainerServiceInfoCommand
implements ICommand<IGetContainerServiceInfoCommandData>,
Serializable {
    private static final long serialVersionUID = 1L;

    public void execute(IGetContainerServiceInfoCommandData context) {
        JobContext jobContext = context.getJobContext();
        Item owner = jobContext.getOwner();
        FilePath workspace = jobContext.getWorkspace();
        final TaskListener taskListener = jobContext.getTaskListener();
        final TokenCredentialData token = AzureHelper.getToken(owner, context.getAzureCredentialsId());
        final String resourceGroupName = context.getResourceGroupName();
        final String containerServiceName = context.getContainerServiceName();
        String containerServiceType = context.getContainerServiceType();
        final ContainerServiceOrchestratorTypes configuredType = context.getOrchestratorType();
        String aiType = AzureACSPlugin.normalizeContainerSerivceType(containerServiceType);
        Azure azureClient = AzureHelper.buildClient(token);
        AzureACSPlugin.sendEventFor("StartDeploy", aiType, jobContext.getRun(), "Subscription", AppInsightsUtils.hash((String)azureClient.subscriptionId()), "ResourceGroup", AppInsightsUtils.hash((String)resourceGroupName), "ContainerServiceName", AppInsightsUtils.hash((String)containerServiceName));
        if ("AKS".equals(containerServiceType)) {
            context.setCommandState(CommandState.Success);
            return;
        }
        context.logStatus(Messages.GetContainserServiceInfoCommand_getFQDN());
        try {
            TaskResult taskResult = (TaskResult)workspace.act((Callable)new MasterToSlaveCallable<TaskResult, RuntimeException>(){

                public TaskResult call() throws RuntimeException {
                    PrintStream logger = taskListener.getLogger();
                    Azure azureClient = AzureHelper.buildClient(token);
                    return GetContainerServiceInfoCommand.this.getAcsInfo(azureClient, resourceGroupName, containerServiceName, configuredType, logger);
                }
            });
            context.setCommandState(taskResult.commandState);
            if (taskResult.commandState.isError()) {
                return;
            }
            context.setMgmtFQDN(taskResult.fqdn);
        }
        catch (Exception ex) {
            if (ex instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            context.logError(ex);
            AzureACSPlugin.sendEventFor("GetInfoFailure", aiType, jobContext.getRun(), "ErrorMessage", ex.getMessage());
        }
    }

    @VisibleForTesting
    TaskResult getAcsInfo(Azure azureClient, String resourceGroupName, String containerServiceName, ContainerServiceOrchestratorTypes configuredType, PrintStream logger) {
        TaskResult result = new TaskResult();
        ContainerService containerService = (ContainerService)azureClient.containerServices().getByResourceGroup(resourceGroupName, containerServiceName);
        if (containerService == null) {
            logger.println(Messages.GetContainserServiceInfoCommand_containerServiceNotFound(containerServiceName, resourceGroupName));
            result.commandState = CommandState.HasError;
            return result;
        }
        ContainerServiceOrchestratorTypes orchestratorType = containerService.orchestratorType();
        logger.println(Messages.GetContainserServiceInfoCommand_orchestratorType(orchestratorType));
        result.orchestratorType = orchestratorType;
        if (configuredType == null || orchestratorType != configuredType) {
            logger.println(Messages.GetContainserServiceInfoCommand_orchestratorTypeNotMatch(containerServiceName, orchestratorType, configuredType));
            result.commandState = CommandState.HasError;
            return result;
        }
        String fqdn = containerService.masterFqdn();
        logger.println(Messages.GetContainserServiceInfoCommand_fqdn(fqdn));
        result.fqdn = fqdn;
        String adminUser = containerService.linuxRootUsername();
        logger.println(Messages.GetContainserServiceInfoCommand_adminUser(adminUser));
        result.adminUsername = adminUser;
        result.commandState = CommandState.Success;
        return result;
    }

    public static interface IGetContainerServiceInfoCommandData
    extends IBaseCommandData {
        public String getAzureCredentialsId();

        public String getResourceGroupName();

        public String getContainerServiceName();

        public void setMgmtFQDN(String var1);

        public ContainerServiceOrchestratorTypes getOrchestratorType();

        public String getContainerServiceType();
    }

    @VisibleForTesting
    static class TaskResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private CommandState commandState = CommandState.Unknown;
        private transient ContainerServiceOrchestratorTypes orchestratorType;
        private String fqdn;
        private String adminUsername;

        TaskResult() {
        }

        public CommandState getCommandState() {
            return this.commandState;
        }

        public ContainerServiceOrchestratorTypes getOrchestratorType() {
            return this.orchestratorType;
        }

        public String getFqdn() {
            return this.fqdn;
        }

        public String getAdminUsername() {
            return this.adminUsername;
        }
    }
}

