/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.acs.commands;

import com.google.common.annotations.VisibleForTesting;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.containerservice.ContainerServiceOrchestratorTypes;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.LoadBalancerBackend;
import com.microsoft.azure.management.network.LoadBalancerFrontend;
import com.microsoft.azure.management.network.LoadBalancingRule;
import com.microsoft.azure.management.network.LoadDistribution;
import com.microsoft.azure.management.network.NetworkSecurityGroup;
import com.microsoft.azure.management.network.NetworkSecurityRule;
import com.microsoft.azure.management.network.SecurityRuleAccess;
import com.microsoft.azure.management.network.SecurityRuleDirection;
import com.microsoft.jenkins.acs.Messages;
import com.microsoft.jenkins.acs.orchestrators.DeploymentConfig;
import com.microsoft.jenkins.acs.orchestrators.ServicePort;
import com.microsoft.jenkins.acs.util.AzureHelper;
import com.microsoft.jenkins.azurecommons.JobContext;
import com.microsoft.jenkins.azurecommons.command.CommandState;
import com.microsoft.jenkins.azurecommons.command.IBaseCommandData;
import com.microsoft.jenkins.azurecommons.command.ICommand;
import com.microsoft.jenkins.azurecommons.core.credentials.TokenCredentialData;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jenkins.security.MasterToSlaveCallable;

public class EnablePortCommand
implements ICommand<IEnablePortCommandData>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int LOAD_BALANCER_IDLE_TIMEOUT_IN_MINUTES = 5;

    public void execute(IEnablePortCommandData context) {
        JobContext jobContext = context.getJobContext();
        Item owner = jobContext.getOwner();
        final FilePath workspace = jobContext.getWorkspace();
        final TaskListener taskListener = jobContext.getTaskListener();
        final EnvVars envVars = context.getEnvVars();
        final DeploymentConfig.Factory configFactory = new DeploymentConfig.Factory(context.getConfigFilePaths());
        final ContainerServiceOrchestratorTypes orchestratorType = context.getOrchestratorType();
        String azureCredentialsId = context.getAzureCredentialsId();
        final String resourceGroupName = context.getResourceGroupName();
        try {
            final TokenCredentialData token = AzureHelper.getToken(owner, azureCredentialsId);
            CommandState state = (CommandState)workspace.act((Callable)new MasterToSlaveCallable<CommandState, Exception>(){

                public CommandState call() throws Exception {
                    PrintStream logger = taskListener.getLogger();
                    Azure azureClient = AzureHelper.buildClient(token);
                    DeploymentConfig config = configFactory.build(orchestratorType, workspace, envVars);
                    String resourcePrefix = config.getResourcePrefix();
                    List<ServicePort> servicePorts = config.getServicePorts();
                    EnablePortCommand.createSecurityRules(azureClient, resourceGroupName, resourcePrefix, servicePorts, logger);
                    EnablePortCommand.createLoadBalancerRules(azureClient, resourceGroupName, resourcePrefix, servicePorts, logger);
                    return CommandState.Success;
                }
            });
            context.setCommandState(state);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            context.logError(e);
        }
    }

    @VisibleForTesting
    static int filterPortsToOpen(Collection<NetworkSecurityRule> rules, Set<Integer> portsToOpen, PrintStream logger) throws InvalidConfigException {
        int maxPriority = Integer.MIN_VALUE;
        for (NetworkSecurityRule rule : rules) {
            int priority = rule.priority();
            if (priority > maxPriority) {
                maxPriority = priority;
            }
            if (!SecurityRuleDirection.INBOUND.equals((Object)rule.direction()) || !SecurityRuleAccess.ALLOW.equals((Object)rule.access())) continue;
            String ruleDestPortRange = rule.destinationPortRange();
            if (ruleDestPortRange.equals("*")) {
                logger.println(Messages.EnablePortCommand_securityRuleAlreadyAllowAll(rule.name(), ruleDestPortRange));
                portsToOpen.clear();
                break;
            }
            if (ruleDestPortRange.contains("-")) {
                String[] parts = ruleDestPortRange.split("-", 2);
                int portStart = 0;
                int portEnd = 0;
                try {
                    portStart = Integer.parseInt(parts[0]);
                    portEnd = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigException(Messages.EnablePortCommand_securityRuleInvalidDestinationPortRange(ruleDestPortRange));
                }
                Iterator<Integer> it = portsToOpen.iterator();
                while (it.hasNext()) {
                    int port = it.next();
                    if (port < portStart || port > portEnd) continue;
                    logger.println(Messages.EnablePortCommand_securityRuleAlreadyAllowSingle(rule.name(), ruleDestPortRange, String.valueOf(port)));
                    it.remove();
                }
                continue;
            }
            int port = Integer.parseInt(ruleDestPortRange);
            if (!portsToOpen.remove(port)) continue;
            logger.println(Messages.EnablePortCommand_securityRuleAlreadyAllowSingle(rule.name(), ruleDestPortRange, String.valueOf(port)));
        }
        return maxPriority;
    }

    static void createSecurityRules(Azure azureClient, String resourceGroupName, String resourcePrefix, List<ServicePort> servicePorts, PrintStream logger) throws IOException, InvalidConfigException {
        if (servicePorts.isEmpty()) {
            return;
        }
        HashSet<Integer> portsToOpen = new HashSet<Integer>();
        for (ServicePort servicePort : servicePorts) {
            portsToOpen.add(servicePort.getHostPort());
        }
        PagedList nsgs = azureClient.networkSecurityGroups().listByResourceGroup(resourceGroupName);
        NetworkSecurityGroup nsgPublicAgent = null;
        for (NetworkSecurityGroup nsg : nsgs) {
            if (!nsg.name().startsWith(resourcePrefix + "-agent-public-nsg-")) continue;
            nsgPublicAgent = nsg;
            break;
        }
        if (nsgPublicAgent == null) {
            logger.println(Messages.EnablePortCommand_securityGroupNotFound());
            return;
        }
        int maxPriority = EnablePortCommand.filterPortsToOpen(nsgPublicAgent.securityRules().values(), portsToOpen, logger);
        NetworkSecurityGroup.Update update = (NetworkSecurityGroup.Update)nsgPublicAgent.update();
        Iterator iterator = portsToOpen.iterator();
        while (iterator.hasNext()) {
            int port = (Integer)iterator.next();
            logger.println(Messages.EnablePortCommand_securityRuleNotFound(String.valueOf(port)));
            if ((maxPriority += 10) > 4096) {
                throw new InvalidConfigException(Messages.EnablePortCommand_exceedMaxPriority());
            }
            String ruleName = "Allow_" + port;
            logger.println(Messages.EnablePortCommand_creatingRule(String.valueOf(port), ruleName));
            update.defineRule(ruleName).allowInbound().fromAddress("Internet").fromAnyPort().toAnyAddress().toPort(port).withAnyProtocol().withDescription(Messages.EnablePortCommand_allowTraffic(String.valueOf(port))).withPriority(maxPriority).attach();
        }
        update.apply();
    }

    static void createLoadBalancerRules(Azure azureClient, String resourceGroupName, String resourcePrefix, List<ServicePort> servicePorts, PrintStream logger) throws IOException, InvalidConfigException {
        if (servicePorts.isEmpty()) {
            return;
        }
        PagedList balancers = azureClient.loadBalancers().listByResourceGroup(resourceGroupName);
        LoadBalancer loadBalancer = null;
        for (LoadBalancer balancer : balancers) {
            String balancerName = balancer.name();
            if (!balancerName.startsWith(resourcePrefix + "-agent-lb-")) continue;
            if (balancer.backends().size() != 1 || balancer.frontends().size() != 1) {
                throw new InvalidConfigException(Messages.EnablePortCommand_missMatch());
            }
            loadBalancer = balancer;
            break;
        }
        if (loadBalancer == null) {
            logger.println(Messages.EnablePortCommand_lbNotFound());
            return;
        }
        LoadBalancerFrontend frontend = (LoadBalancerFrontend)loadBalancer.frontends().values().iterator().next();
        LoadBalancerBackend backend = (LoadBalancerBackend)loadBalancer.backends().values().iterator().next();
        LoadBalancer.Update update = (LoadBalancer.Update)loadBalancer.update();
        for (ServicePort servicePort : servicePorts) {
            boolean ruleFound = false;
            for (LoadBalancingRule rule : loadBalancer.loadBalancingRules().values()) {
                if (!servicePort.matchesLoadBalancingRule(rule)) continue;
                logger.println(Messages.EnablePortCommand_lbFound(String.valueOf(servicePort.getHostPort()), servicePort.getProtocol()));
                ruleFound = true;
                break;
            }
            if (ruleFound) continue;
            String ruleName = "JLBRule" + servicePort.getProtocol().toString() + servicePort.getHostPort();
            logger.println(Messages.EnablePortCommand_creatingLB(String.valueOf(servicePort.getHostPort()), ruleName));
            String probeName = "tcpPort" + servicePort.getHostPort() + "Probe";
            ((LoadBalancingRule.UpdateDefinitionStages.WithAttach)((LoadBalancingRule.UpdateDefinitionStages.WithBackend)((LoadBalancingRule.UpdateDefinitionStages.WithFrontendPort)((LoadBalancingRule.UpdateDefinitionStages.WithFrontend)((LoadBalancer.Update)update.defineTcpProbe(probeName).withPort(servicePort.getHostPort()).attach()).defineLoadBalancingRule(ruleName).withProtocol((Object)servicePort.getTransportProtocol())).fromFrontend(frontend.name())).fromFrontendPort(servicePort.getHostPort())).toBackend(backend.name()).toBackendPort(servicePort.getHostPort())).withProbe(probeName).withIdleTimeoutInMinutes(5).withLoadDistribution(LoadDistribution.DEFAULT).attach();
        }
        update.apply();
    }

    public static interface IEnablePortCommandData
    extends IBaseCommandData {
        public String getAzureCredentialsId();

        public String getConfigFilePaths();

        public String getResourceGroupName();

        public ContainerServiceOrchestratorTypes getOrchestratorType();
    }

    static final class InvalidConfigException
    extends Exception {
        InvalidConfigException(String message) {
            super(message);
        }
    }
}

