/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.acs.commands;

import com.microsoft.azure.management.containerservice.ContainerServiceOrchestratorTypes;
import com.microsoft.jenkins.acs.Messages;
import com.microsoft.jenkins.acs.commands.AKSDeploymentCommand;
import com.microsoft.jenkins.acs.commands.KubernetesDeploymentCommand;
import com.microsoft.jenkins.acs.commands.MarathonDeploymentCommand;
import com.microsoft.jenkins.acs.commands.SwarmDeploymentCommand;
import com.microsoft.jenkins.acs.util.Constants;
import com.microsoft.jenkins.azurecommons.command.CommandState;
import com.microsoft.jenkins.azurecommons.command.IBaseCommandData;
import com.microsoft.jenkins.azurecommons.command.ICommand;
import com.microsoft.jenkins.azurecommons.command.INextCommandAware;

public class DeploymentChoiceCommand
implements ICommand<IDeploymentChoiceCommandData>,
INextCommandAware {
    private String containerServiceType;

    public void execute(IDeploymentChoiceCommandData context) {
        String type = context.getContainerServiceType();
        if (type == null) {
            context.logError(Messages.DeploymentChoiceCommand_containerServiceTypeNotFound());
            return;
        }
        if (!"AKS".equals(type) && !Constants.SUPPORTED_ORCHESTRATOR_NAMES.contains(type)) {
            context.logError(Messages.DeploymentChoiceCommand_orchestratorNotSupported(type));
            return;
        }
        this.containerServiceType = type;
        context.setCommandState(CommandState.Success);
    }

    public Class nextCommand() {
        if (ContainerServiceOrchestratorTypes.KUBERNETES.toString().equals(this.containerServiceType)) {
            return KubernetesDeploymentCommand.class;
        }
        if (ContainerServiceOrchestratorTypes.DCOS.toString().equals(this.containerServiceType)) {
            return MarathonDeploymentCommand.class;
        }
        if (ContainerServiceOrchestratorTypes.SWARM.toString().equals(this.containerServiceType)) {
            return SwarmDeploymentCommand.class;
        }
        if ("AKS".equals(this.containerServiceType)) {
            return AKSDeploymentCommand.class;
        }
        throw new IllegalStateException(Messages.DeploymentChoiceCommand_orchestratorNotSupported(this.containerServiceType));
    }

    public static interface IDeploymentChoiceCommandData
    extends IBaseCommandData {
        public String getContainerServiceType();
    }
}

