/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.acs.commands;

import com.microsoft.azure.management.Azure;
import com.microsoft.jenkins.acs.commands.KubernetesDeploymentCommandBase;
import com.microsoft.jenkins.acs.orchestrators.DeploymentConfig;
import com.microsoft.jenkins.acs.util.AzureHelper;
import com.microsoft.jenkins.azurecommons.core.credentials.TokenCredentialData;
import hudson.FilePath;
import hudson.model.Item;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang3.ArrayUtils;

public class AKSDeploymentCommand
extends KubernetesDeploymentCommandBase<IAKSDeploymentCommandData> {
    @Override
    public void execute(IAKSDeploymentCommandData context) {
        Item owner = context.getJobContext().getOwner();
        TokenCredentialData token = AzureHelper.getToken(owner, context.getAzureCredentialsId());
        AKSDeployWorker deployer = new AKSDeployWorker();
        deployer.setToken(token);
        deployer.setResourceGroupName(context.getResourceGroupName());
        deployer.setContainerServiceName(context.getContainerServiceName());
        this.doExecute(context, deployer);
    }

    public static interface IAKSDeploymentCommandData
    extends KubernetesDeploymentCommandBase.IKubernetesDeploymentCommandData {
        public String getAzureCredentialsId();

        public String getResourceGroupName();
    }

    static class AKSDeployWorker
    extends KubernetesDeploymentCommandBase.KubernetesDeployWorker {
        private TokenCredentialData token;
        private String resourceGroupName;
        private String containerServiceName;

        AKSDeployWorker() {
        }

        @Override
        protected FilePath[] resolveConfigFiles() throws IOException, InterruptedException {
            DeploymentConfig deploymentConfig = this.getConfigFactory().buildForAKS(this.getWorkspace(), this.getEnvVars());
            return deploymentConfig.getConfigFiles();
        }

        @Override
        protected void prepareKubeconfig(FilePath kubeconfigFile) throws Exception {
            Azure azureClient = AzureHelper.buildClient(this.token);
            byte[] adminKubeConfigContent = azureClient.kubernetesClusters().getAdminKubeConfigContent(this.getResourceGroupName(), this.getContainerServiceName());
            if (ArrayUtils.isEmpty((byte[])adminKubeConfigContent)) {
                throw new IllegalStateException("Null user kubeconfig returned from Azure");
            }
            try (OutputStream out = kubeconfigFile.write();){
                out.write(adminKubeConfigContent);
            }
        }

        public String getResourceGroupName() {
            return this.resourceGroupName;
        }

        public void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        public String getContainerServiceName() {
            return this.containerServiceName;
        }

        public void setContainerServiceName(String containerServiceName) {
            this.containerServiceName = containerServiceName;
        }

        public TokenCredentialData getToken() {
            return this.token;
        }

        public void setToken(TokenCredentialData token) {
            this.token = token;
        }
    }
}

