/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.acs;

import com.microsoft.jenkins.azurecommons.telemetry.AppInsightsClientFactory;
import com.microsoft.jenkins.azurecommons.telemetry.AppInsightsUtils;
import com.microsoft.jenkins.azurecommons.telemetry.AzureHttpRecorder;
import hudson.Plugin;
import hudson.model.Run;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class AzureACSPlugin
extends Plugin {
    public static void sendEventFor(String action, String orchestrator, Run<?, ?> run, String ... properties) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("Orchestrator", orchestrator);
        props.put("Run", AppInsightsUtils.hash((String)(run == null ? null : run.getUrl())));
        for (int i = 1; i < properties.length; i += 2) {
            props.put(properties[i - 1], properties[i]);
        }
        AzureACSPlugin.sendEvent("ACS", action, props);
    }

    public static void sendEvent(String item, String action, String ... properties) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (int i = 1; i < properties.length; i += 2) {
            props.put(properties[i - 1], properties[i]);
        }
        AzureACSPlugin.sendEvent(item, action, props);
    }

    public static void sendEvent(String item, String action, Map<String, String> properties) {
        AppInsightsClientFactory.getInstance(AzureACSPlugin.class).sendEvent(item, action, properties, false);
    }

    public static String normalizeContainerSerivceType(String type) {
        if ("Kubernetes".equalsIgnoreCase(type)) {
            return "Kubernetes";
        }
        if ("DCOS".equalsIgnoreCase(type)) {
            return "DCOS";
        }
        if ("Swarm".equalsIgnoreCase(type)) {
            return "Swarm";
        }
        if ("AKS".equalsIgnoreCase(type)) {
            return "AKS";
        }
        return "Custom";
    }

    public static class AzureTelemetryInterceptor
    implements Interceptor {
        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            Response response = chain.proceed(request);
            new AzureHttpRecorder(AppInsightsClientFactory.getInstance(AzureACSPlugin.class)).record(new AzureHttpRecorder.HttpRecordable().withHttpCode(response.code()).withHttpMessage(response.message()).withHttpMethod(request.method()).withRequestUri(request.url().uri()).withRequestId(response.header("x-ms-request-id")));
            return response;
        }
    }
}

