/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.acs;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.containerservice.ContainerService;
import com.microsoft.azure.management.containerservice.ContainerServiceOrchestratorTypes;
import com.microsoft.azure.management.resources.GenericResource;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.util.AzureBaseCredentials;
import com.microsoft.azure.util.AzureCredentialUtil;
import com.microsoft.jenkins.acs.ACSDeploymentBuilder;
import com.microsoft.jenkins.acs.Messages;
import com.microsoft.jenkins.acs.commands.AKSDeploymentCommand;
import com.microsoft.jenkins.acs.commands.DeploymentChoiceCommand;
import com.microsoft.jenkins.acs.commands.EnablePortCommand;
import com.microsoft.jenkins.acs.commands.GetContainerServiceInfoCommand;
import com.microsoft.jenkins.acs.commands.KubernetesDeploymentCommand;
import com.microsoft.jenkins.acs.commands.KubernetesDeploymentCommandBase;
import com.microsoft.jenkins.acs.commands.MarathonDeploymentCommand;
import com.microsoft.jenkins.acs.commands.SwarmDeploymentCommand;
import com.microsoft.jenkins.acs.util.AzureHelper;
import com.microsoft.jenkins.acs.util.Constants;
import com.microsoft.jenkins.acs.util.DeployHelper;
import com.microsoft.jenkins.azurecommons.JobContext;
import com.microsoft.jenkins.azurecommons.command.BaseCommandContext;
import com.microsoft.jenkins.azurecommons.command.CommandService;
import com.microsoft.jenkins.azurecommons.command.IBaseCommandData;
import com.microsoft.jenkins.azurecommons.command.ICommand;
import com.microsoft.jenkins.azurecommons.remote.SSHClient;
import com.microsoft.jenkins.kubernetes.credentials.ResolvedDockerRegistryEndpoint;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryToken;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ACSDeploymentContext
extends BaseCommandContext
implements GetContainerServiceInfoCommand.IGetContainerServiceInfoCommandData,
EnablePortCommand.IEnablePortCommandData,
MarathonDeploymentCommand.IMarathonDeploymentCommandData,
KubernetesDeploymentCommandBase.IKubernetesDeploymentCommandData,
SwarmDeploymentCommand.ISwarmDeploymentCommandData,
DeploymentChoiceCommand.IDeploymentChoiceCommandData,
AKSDeploymentCommand.IAKSDeploymentCommandData {
    private final String azureCredentialsId;
    private final String resourceGroupName;
    private final String containerService;
    private final String sshCredentialsId;
    private final String configFilePaths;
    private boolean enableConfigSubstitution;
    private boolean swarmRemoveContainersFirst;
    private String secretNamespace;
    private String secretName;
    private String dcosDockerCredentialsPath;
    private boolean dcosDockerCredenditalsPathShared;
    private List<DockerRegistryEndpoint> containerRegistryCredentials;
    private transient String mgmtFQDN;
    private transient ContainerServiceOrchestratorTypes orchestratorType;
    private transient SSHUserPrivateKey sshCredentials;

    @DataBoundConstructor
    public ACSDeploymentContext(String azureCredentialsId, String resourceGroupName, String containerService, String sshCredentialsId, String configFilePaths) {
        this.azureCredentialsId = azureCredentialsId;
        this.resourceGroupName = StringUtils.trimToEmpty((String)resourceGroupName);
        this.containerService = StringUtils.trimToEmpty((String)containerService);
        this.sshCredentialsId = sshCredentialsId;
        this.configFilePaths = StringUtils.trimToEmpty((String)configFilePaths);
    }

    public StepExecution startImpl(StepContext context) throws Exception {
        return new ExecutionImpl(new ACSDeploymentBuilder(this), context);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Override
    public String getAzureCredentialsId() {
        return this.azureCredentialsId;
    }

    @Override
    public String getConfigFilePaths() {
        return this.configFilePaths;
    }

    public String getSshCredentialsId() {
        return this.sshCredentialsId;
    }

    @Override
    public SSHUserPrivateKey getSshCredentials() {
        if (this.sshCredentials == null) {
            this.sshCredentials = ACSDeploymentContext.getSshCredentials(this.getSshCredentialsId());
        }
        return this.sshCredentials;
    }

    @Override
    public void setMgmtFQDN(String fqdn) {
        this.mgmtFQDN = fqdn;
    }

    @Override
    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String getMgmtFQDN() {
        return this.mgmtFQDN;
    }

    public IBaseCommandData getDataForCommand(ICommand command) {
        return this;
    }

    @Override
    public ContainerServiceOrchestratorTypes getOrchestratorType() {
        if (this.orchestratorType == null) {
            this.orchestratorType = ContainerServiceOrchestratorTypes.fromString((String)ACSDeploymentContext.getOrchestratorType(this.containerService));
        }
        return this.orchestratorType;
    }

    @Override
    public String getContainerServiceType() {
        String type = ACSDeploymentContext.getOrchestratorType(this.containerService);
        return type;
    }

    public String getContainerService() {
        return this.containerService;
    }

    @Override
    public String getContainerServiceName() {
        return ACSDeploymentContext.getContainerServiceName(this.getContainerService());
    }

    @Override
    public String getSecretNamespace() {
        if (StringUtils.isBlank((String)this.secretNamespace)) {
            return this.getDescriptor().getDefaultSecretNamespace();
        }
        return this.secretNamespace;
    }

    @DataBoundSetter
    public void setSecretNamespace(String secretNamespace) {
        this.secretNamespace = this.getDescriptor().getDefaultSecretNamespace().equals(secretNamespace) ? null : StringUtils.trimToEmpty((String)secretNamespace);
    }

    @Override
    public boolean isSwarmRemoveContainersFirst() {
        return this.swarmRemoveContainersFirst;
    }

    @DataBoundSetter
    public void setSwarmRemoveContainersFirst(boolean swarmRemoveContainersFirst) {
        this.swarmRemoveContainersFirst = swarmRemoveContainersFirst;
    }

    @Override
    public boolean isEnableConfigSubstitution() {
        return this.enableConfigSubstitution;
    }

    @DataBoundSetter
    public void setEnableConfigSubstitution(boolean enableConfigSubstitution) {
        this.enableConfigSubstitution = enableConfigSubstitution;
    }

    @Override
    public String getSecretName() {
        return this.secretName;
    }

    @DataBoundSetter
    public void setSecretName(String secretName) {
        this.secretName = StringUtils.trimToEmpty((String)secretName);
    }

    @Override
    public String getDcosDockerCredentialsPath() {
        return this.dcosDockerCredentialsPath;
    }

    @DataBoundSetter
    public void setDcosDockerCredentialsPath(String dcosDockerCredentialsPath) {
        this.dcosDockerCredentialsPath = StringUtils.trimToEmpty((String)dcosDockerCredentialsPath);
    }

    @Override
    public boolean isDcosDockerCredenditalsPathShared() {
        return this.dcosDockerCredenditalsPathShared;
    }

    @DataBoundSetter
    public void setDcosDockerCredenditalsPathShared(boolean dcosDockerCredenditalsPathShared) {
        this.dcosDockerCredenditalsPathShared = dcosDockerCredenditalsPathShared;
    }

    public List<DockerRegistryEndpoint> getContainerRegistryCredentials() {
        if (this.containerRegistryCredentials == null) {
            return new ArrayList<DockerRegistryEndpoint>(0);
        }
        return this.containerRegistryCredentials;
    }

    @DataBoundSetter
    public void setContainerRegistryCredentials(List<DockerRegistryEndpoint> containerRegistryCredentials) {
        ArrayList<DockerRegistryEndpoint> endpoints = new ArrayList<DockerRegistryEndpoint>();
        for (DockerRegistryEndpoint endpoint : containerRegistryCredentials) {
            String credentialsId = StringUtils.trimToNull((String)endpoint.getCredentialsId());
            if (credentialsId == null) continue;
            String registryUrl = StringUtils.trimToNull((String)endpoint.getUrl());
            if (registryUrl != null && !Constants.URI_SCHEME_PREFIX.matcher(registryUrl).find()) {
                registryUrl = "http://" + registryUrl;
            }
            endpoint = new DockerRegistryEndpoint(registryUrl, credentialsId);
            endpoints.add(endpoint);
        }
        this.containerRegistryCredentials = endpoints;
    }

    @Override
    public List<ResolvedDockerRegistryEndpoint> resolvedDockerRegistryEndpoints(Item context) throws IOException {
        ArrayList<ResolvedDockerRegistryEndpoint> endpoints = new ArrayList<ResolvedDockerRegistryEndpoint>();
        List<DockerRegistryEndpoint> configured = this.getContainerRegistryCredentials();
        for (DockerRegistryEndpoint endpoint : configured) {
            DockerRegistryToken token = endpoint.getToken(context);
            if (token == null) {
                throw new IllegalArgumentException("No credentials found for " + endpoint);
            }
            endpoints.add(new ResolvedDockerRegistryEndpoint(endpoint.getEffectiveUrl(), token));
        }
        return endpoints;
    }

    public void configure(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        CommandService commandService = CommandService.builder().withTransition(GetContainerServiceInfoCommand.class, DeploymentChoiceCommand.class).withSingleCommand(KubernetesDeploymentCommand.class).withSingleCommand(AKSDeploymentCommand.class).withTransition(MarathonDeploymentCommand.class, EnablePortCommand.class).withTransition(SwarmDeploymentCommand.class, EnablePortCommand.class).withStartCommand(GetContainerServiceInfoCommand.class).build();
        JobContext jobContext = new JobContext(run, workspace, launcher, listener);
        super.configure(jobContext, commandService);
    }

    private static SSHUserPrivateKey getSshCredentials(String id) {
        if (StringUtils.isBlank((String)id)) {
            return null;
        }
        SSHUserPrivateKey creds = (SSHUserPrivateKey)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(BasicSSHUserPrivateKey.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)id));
        return creds;
    }

    public static String getContainerServiceName(String containerService) {
        if (StringUtils.isBlank((String)containerService)) {
            throw new IllegalArgumentException(Messages.ACSDeploymentContext_blankContainerService());
        }
        String[] part = containerService.split("\\|");
        return part[0].trim();
    }

    public static String getOrchestratorType(String containerService) {
        String type;
        if (StringUtils.isBlank((String)containerService)) {
            throw new IllegalArgumentException(Messages.ACSDeploymentContext_blankContainerServiceType());
        }
        String[] parts = containerService.split("\\|");
        if (parts.length == 2 && StringUtils.isNotEmpty((String)(type = parts[1].trim()))) {
            return type;
        }
        throw new IllegalArgumentException(Messages.ACSDeploymentContext_blankContainerServiceType());
    }

    public static String validate(String azureCredentialsId, String resourceGroup, String containerService, String sshCredentialsId) {
        return ACSDeploymentContext.validate(azureCredentialsId, resourceGroup, containerService, sshCredentialsId, CredentailsFinder.DEFAULT);
    }

    @VisibleForTesting
    static String validate(String azureCredentialsId, String resourceGroup, String containerService, String sshCredentialsId, CredentailsFinder credentailsFinder) {
        AzureBaseCredentials credential = credentailsFinder.getCredential(azureCredentialsId);
        if (credential == null) {
            return Messages.ACSDeploymentContext_missingCredentials();
        }
        if (StringUtils.isBlank((String)resourceGroup) || "*".equals(resourceGroup)) {
            return Messages.ACSDeploymentContext_missingResourceGroup();
        }
        if (StringUtils.isBlank((String)containerService) || "*".equals(containerService)) {
            return Messages.ACSDeploymentContext_missingContainerServiceName();
        }
        try {
            String orchestratorTypeName = ACSDeploymentContext.getOrchestratorType(containerService);
            if ("AKS".equals(orchestratorTypeName)) {
                return null;
            }
            if (StringUtils.isBlank((String)sshCredentialsId) || credentailsFinder.getSshCredentials(sshCredentialsId) == null) {
                return Messages.ACSDeploymentContext_missingSSHCredentials();
            }
            ContainerServiceOrchestratorTypes orchestratorType = ContainerServiceOrchestratorTypes.fromString((String)orchestratorTypeName);
            if (!Constants.SUPPORTED_ORCHESTRATOR.contains(orchestratorType)) {
                return Messages.ACSDeploymentContext_orchestratorNotSupported(orchestratorTypeName);
            }
        }
        catch (IllegalArgumentException e) {
            return Messages.ACSDeploymentContext_validationError(e.getMessage());
        }
        return null;
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public ListBoxModel doFillAzureCredentialsIdItems(@AncestorInPath Item owner) {
            StandardListBoxModel model = new StandardListBoxModel();
            model.add(Messages.ACSDeploymentContext_selectAzureCredentials(), "*");
            model.includeAs(ACL.SYSTEM, owner, AzureBaseCredentials.class);
            return model;
        }

        public FormValidation doVerifyConfiguration(@AncestorInPath Item owner, @QueryParameter String azureCredentialsId, @QueryParameter String resourceGroupName, @QueryParameter String containerService, @QueryParameter String sshCredentialsId) {
            String validateResult = ACSDeploymentContext.validate(azureCredentialsId, resourceGroupName, containerService, sshCredentialsId);
            if (validateResult != null) {
                return FormValidation.error((String)validateResult);
            }
            try {
                Azure azureClient = AzureHelper.buildClient(owner, azureCredentialsId);
                ResourceGroup group = (ResourceGroup)azureClient.resourceGroups().getByName(resourceGroupName);
                if (group == null) {
                    return FormValidation.error((String)Messages.ACSDeploymentContext_resourceGroupNotFound());
                }
                String containerServiceType = ACSDeploymentContext.getOrchestratorType(containerService);
                String containerServiceName = ACSDeploymentContext.getContainerServiceName(containerService);
                if ("AKS".equals(containerServiceType)) {
                    GenericResource resource = azureClient.genericResources().get(resourceGroupName, "Microsoft.ContainerService", "managedClusters", containerServiceName);
                    if (resource == null) {
                        return FormValidation.error((String)Messages.ACSDeploymentContext_containerServiceNotFound());
                    }
                    return FormValidation.ok((String)Messages.ACSDeploymentContext_validationSuccess());
                }
                ContainerService container = (ContainerService)azureClient.containerServices().getByResourceGroup(resourceGroupName, containerServiceName);
                if (container == null) {
                    return FormValidation.error((String)Messages.ACSDeploymentContext_containerServiceNotFound());
                }
                if (!container.orchestratorType().toString().equalsIgnoreCase(containerServiceType)) {
                    return FormValidation.error((String)Messages.ACSDeploymentContext_containerServiceTypeMissMatch());
                }
                try {
                    SSHClient sshClient = new SSHClient(container.masterFqdn(), Constants.sshPort(container.orchestratorType()), (StandardUsernameCredentials)ACSDeploymentContext.getSshCredentials(sshCredentialsId));
                    try (SSHClient ignore = sshClient.connect();){
                        sshClient.execRemote("ls");
                    }
                }
                catch (Exception e) {
                    return FormValidation.error((String)Messages.ACSDeploymentContext_sshFailure(e.getMessage()));
                }
                return FormValidation.ok((String)Messages.ACSDeploymentContext_validationSuccess());
            }
            catch (Exception e) {
                return FormValidation.error((String)Messages.ACSDeploymentContext_validationError(e.getMessage()));
            }
        }

        public ListBoxModel doFillResourceGroupNameItems(@AncestorInPath Item owner, @QueryParameter String azureCredentialsId) {
            ListBoxModel model = new ListBoxModel();
            if (StringUtils.isBlank((String)azureCredentialsId) || "*".equals(azureCredentialsId)) {
                model.add(Messages.ACSDeploymentContext_selectAzureCredentialsFirst(), "*");
                return model;
            }
            try {
                Azure azureClient = AzureHelper.buildClient(owner, azureCredentialsId);
                for (ResourceGroup resourceGroup : azureClient.resourceGroups().list()) {
                    model.add(resourceGroup.name());
                }
            }
            catch (Exception ex) {
                model.add(Messages.ACSDeploymentContext_failedToLoadResourceGroups(ex.getMessage()), "*");
            }
            if (model.isEmpty()) {
                model.add(Messages.ACSDeploymentContext_noResourceGroupFound(), "*");
            }
            return model;
        }

        public ListBoxModel doFillContainerServiceItems(@AncestorInPath Item owner, @QueryParameter String azureCredentialsId, @QueryParameter String resourceGroupName) {
            ListBoxModel model = new ListBoxModel();
            if (StringUtils.isBlank((String)azureCredentialsId) || "*".equals(azureCredentialsId) || StringUtils.isBlank((String)resourceGroupName) || "*".equals(resourceGroupName)) {
                model.add(Messages.ACSDeploymentContext_selectAzureCredentialsAndGroupFirst(), "*");
                return model;
            }
            try {
                String value;
                Azure azureClient = AzureHelper.buildClient(owner, azureCredentialsId);
                PagedList containerServices = azureClient.containerServices().listByResourceGroup(resourceGroupName);
                for (ContainerService containerService : containerServices) {
                    ContainerServiceOrchestratorTypes orchestratorType = containerService.orchestratorType();
                    if (!Constants.SUPPORTED_ORCHESTRATOR.contains(orchestratorType)) continue;
                    value = String.format("%s | %s", containerService.name(), containerService.orchestratorType());
                    model.add(value);
                }
                PagedList resources = azureClient.genericResources().listByResourceGroup(resourceGroupName);
                for (GenericResource resource : resources) {
                    if (!"Microsoft.ContainerService".equals(resource.resourceProviderNamespace()) || !"managedClusters".equals(resource.resourceType())) continue;
                    value = String.format("%s | %s", resource.name(), "AKS");
                    model.add(value);
                }
            }
            catch (Exception ex) {
                model.add(Messages.ACSDeploymentContext_failedToLoadContainerServices(ex.getMessage()), "*");
            }
            if (model.isEmpty()) {
                model.add(Messages.ACSDeploymentContext_noContainerServiceFound(), "*");
            }
            return model;
        }

        public FormValidation doCheckConfigFilePaths(@QueryParameter String value) {
            if (value == null || value.length() == 0) {
                return FormValidation.error((String)Messages.ACSDeploymentContext_configFilePathsRequired());
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillSshCredentialsIdItems(@AncestorInPath Item owner) {
            AbstractIdCredentialsListBoxModel m = new StandardListBoxModel().includeAs(ACL.SYSTEM, owner, SSHUserPrivateKey.class);
            return m;
        }

        public FormValidation doCheckSecretName(@QueryParameter String containerService, @QueryParameter String value) {
            ContainerServiceOrchestratorTypes orchestratorType;
            String name = StringUtils.trimToEmpty((String)value);
            if (StringUtils.isEmpty((String)name)) {
                return FormValidation.ok();
            }
            try {
                orchestratorType = ContainerServiceOrchestratorTypes.fromString((String)ACSDeploymentContext.getOrchestratorType(containerService));
            }
            catch (IllegalArgumentException e) {
                return FormValidation.ok();
            }
            if (orchestratorType != ContainerServiceOrchestratorTypes.KUBERNETES) {
                return FormValidation.ok();
            }
            String variableStripped = DeployHelper.removeVariables(name);
            if (variableStripped.length() > 253) {
                return FormValidation.error((String)Messages.ACSDeploymentContext_secretNameTooLong());
            }
            String variableReplaced = DeployHelper.replaceVariables(name, "a");
            if (Constants.KUBERNETES_NAME_PATTERN.matcher(variableReplaced).matches()) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.ACSDeploymentContext_secretNameNotMatch(Constants.KUBERNETES_NAME_PATTERN.pattern()));
        }

        public FormValidation doCheckDcosDockerCredentialsPath(@QueryParameter String containerService, @QueryParameter String value) {
            ContainerServiceOrchestratorTypes orchestratorType;
            String path = StringUtils.trimToEmpty((String)value);
            if (StringUtils.isEmpty((String)path)) {
                return FormValidation.ok();
            }
            try {
                orchestratorType = ContainerServiceOrchestratorTypes.fromString((String)ACSDeploymentContext.getOrchestratorType(containerService));
            }
            catch (IllegalArgumentException e) {
                return FormValidation.ok();
            }
            if (orchestratorType != ContainerServiceOrchestratorTypes.DCOS) {
                return FormValidation.ok();
            }
            char first = path.charAt(0);
            if (first != '/' && first != '$') {
                return FormValidation.error((String)Messages.ACSDeploymentContext_onlyAbsolutePathAllowed());
            }
            String variableStripped = DeployHelper.removeVariables(path);
            if (StringUtils.isEmpty((String)variableStripped)) {
                return FormValidation.ok();
            }
            if (!DeployHelper.checkURIForMarathon(variableStripped)) {
                return FormValidation.ok((String)Messages.ACSDeploymentContext_uriNotAccepted());
            }
            return FormValidation.ok();
        }

        public String getDefaultSecretNamespace() {
            return "default";
        }

        public String getDefaultRunOn() {
            return "Success";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class, Launcher.class, TaskListener.class);
        }

        public String getFunctionName() {
            return "acsDeploy";
        }

        public String getDisplayName() {
            return Messages.plugin_displayName();
        }
    }

    @VisibleForTesting
    static interface CredentailsFinder {
        public static final CredentailsFinder DEFAULT = new CredentailsFinder(){

            @Override
            public AzureBaseCredentials getCredential(String credentialsId) {
                return AzureCredentialUtil.getCredential2((String)credentialsId);
            }

            @Override
            public SSHUserPrivateKey getSshCredentials(String credentialsId) {
                return ACSDeploymentContext.getSshCredentials(credentialsId);
            }
        };

        public AzureBaseCredentials getCredential(String var1);

        public SSHUserPrivateKey getSshCredentials(String var1);
    }

    private static final class ExecutionImpl
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final transient SimpleBuildStep delegate;

        ExecutionImpl(SimpleBuildStep delegate, StepContext context) {
            super(context);
            this.delegate = delegate;
        }

        protected Void run() throws Exception {
            StepContext context = this.getContext();
            FilePath workspace = (FilePath)context.get(FilePath.class);
            workspace.mkdirs();
            this.delegate.perform((Run)context.get(Run.class), workspace, (Launcher)context.get(Launcher.class), (TaskListener)context.get(TaskListener.class));
            return null;
        }

        @Nonnull
        public String getStatus() {
            String base = super.getStatus();
            if (this.delegate != null) {
                return this.delegate.getClass().getName() + ": " + base;
            }
            return base;
        }
    }
}

