/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.acs;

import com.microsoft.jenkins.acs.ACSDeploymentContext;
import com.microsoft.jenkins.acs.Messages;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import java.io.IOException;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;

public class ACSDeploymentBuilder
extends Builder
implements SimpleBuildStep {
    private ACSDeploymentContext context;

    @DataBoundConstructor
    public ACSDeploymentBuilder(ACSDeploymentContext context) {
        this.context = context;
    }

    public ACSDeploymentContext getContext() {
        return this.context;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().println(Messages.ACSDeploymentBuilder_starting());
        this.context.configure(run, workspace, launcher, listener);
        this.context.executeCommands();
        if (this.context.getLastCommandState().isError()) {
            run.setResult(Result.FAILURE);
            throw new AbortException(Messages.ACSDeploymentBuilder_endWithErrorState(this.context.getCommandState()));
        }
        listener.getLogger().println(Messages.ACSDeploymentBuilder_finished());
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.plugin_displayName();
        }
    }
}

