/*
 * Decompiled with CFR 0.152.
 */
package com.ribose.jenkins.plugin.awscodecommittrigger.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;

public final class StringUtils {
    public static final Pattern SQS_URL_PATTERN = Pattern.compile("^(?:http(?:s)?://)?(?<endpoint>sqs\\..+?\\.amazonaws\\.com)/(?<id>.+?)/(?<name>.*)$");
    public static final Pattern CODE_COMMIT_PATTERN = Pattern.compile("^(?:(https|ssh)?://)?(?<endpoint>git-codecommit\\..+?\\.amazonaws\\.com)/(?<version>.+?)/repos/(?<repoName>.*)$");
    private static final Pattern VERSION_PATTERN = Pattern.compile("\\d*\\^.|\\d+");

    public static List<String> parseCsvString(String str) {
        ArrayList<String> result = new ArrayList<String>();
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)str)) {
            List<String> strs = Arrays.asList(str.split("\\s*,\\s*"));
            for (String s : strs) {
                String item = s.replaceAll("\"", "").replaceAll("'", "").trim();
                if (item.length() <= 0) continue;
                result.add(item);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @CheckForNull
    public static String findByUniqueJsonKey(String jsonString, String uniqueKey) {
        jsonString = jsonString.trim();
        uniqueKey = uniqueKey.trim();
        String regex = String.format("\"%s\"\\s*:\\s*[^\"]*\"([^\"]+)\"", uniqueKey);
        Pattern p = Pattern.compile(regex);
        Matcher matcher = p.matcher(jsonString);
        String value = null;
        if (matcher.find() && matcher.groupCount() > 0) {
            value = matcher.group(1);
        }
        return value;
    }

    private static String findValueByPatter(String string, Pattern pattern, String groupName) {
        String value = null;
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            value = matcher.group(groupName);
        }
        return value;
    }

    public static String getSqsQueueName(String queueUrl) {
        return StringUtils.findValueByPatter(queueUrl, SQS_URL_PATTERN, "name");
    }

    public static String getSqsEndpoint(String queueUrl) {
        return StringUtils.findValueByPatter(queueUrl, SQS_URL_PATTERN, "endpoint");
    }

    public static String getCodeCommitRepoName(String codeCommitUrl) {
        return StringUtils.findValueByPatter(codeCommitUrl, CODE_COMMIT_PATTERN, "repoName");
    }

    public static boolean isCodeCommitRepo(String url) {
        if (org.apache.commons.lang.StringUtils.isBlank((String)url)) {
            return false;
        }
        String repoName = StringUtils.getCodeCommitRepoName(url);
        return !org.apache.commons.lang.StringUtils.isEmpty((String)repoName);
    }
}

