/*
 * Decompiled with CFR 0.152.
 */
package com.ribose.jenkins.plugin.awscodecommittrigger.threading;

import com.amazonaws.services.sqs.model.Message;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.SQSQueue;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.SQSQueueListener;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.SQSQueueMonitor;
import com.ribose.jenkins.plugin.awscodecommittrigger.logging.Log;
import com.ribose.jenkins.plugin.awscodecommittrigger.net.SQSChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

public class SQSQueueMonitorImpl
implements SQSQueueMonitor {
    private static final Log log = Log.get(SQSQueueMonitorImpl.class);
    private final ExecutorService executor;
    private final SQSQueue queue;
    private final SQSChannel channel;
    private final Object listenersLock = new Object();
    private final List<SQSQueueListener> listeners;
    private final AtomicBoolean isRunning = new AtomicBoolean();
    private volatile boolean isShutDown;

    public SQSQueueMonitorImpl(ExecutorService executor, SQSQueue queue, SQSChannel channel) {
        this.executor = executor;
        this.queue = queue;
        this.channel = channel;
        this.listeners = new ArrayList<SQSQueueListener>();
    }

    private SQSQueueMonitorImpl(ExecutorService executor, SQSQueue queue, SQSChannel channel, List<SQSQueueListener> listeners) {
        this.executor = executor;
        this.queue = queue;
        this.channel = channel;
        this.listeners = listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQSQueueMonitor clone(SQSQueue queue, SQSChannel channel) {
        Object object = this.listenersLock;
        synchronized (object) {
            return new SQSQueueMonitorImpl(this.executor, queue, channel, this.listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(SQSQueueListener listener) {
        assert (listener.getQueueUuid().equals(this.channel.getQueueUuid()));
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.listeners.add(listener) && this.listeners.size() == 1) {
                this.isShutDown = false;
                this.execute();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(SQSQueueListener listener) {
        if (listener == null) {
            return false;
        }
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.listeners.remove(listener) && this.listeners.isEmpty()) {
                this.shutDown();
                return true;
            }
        }
        return false;
    }

    @Override
    public void run() {
        block11: {
            block9: {
                block10: {
                    block7: {
                        block8: {
                            if (!this.isShutDown) break block7;
                            if (this.isRunning.compareAndSet(true, false)) break block8;
                            log.warning("Monitor for %s already stopped", this.queue);
                        }
                        this.execute();
                        return;
                    }
                    if (this.isRunning.compareAndSet(false, true)) break block9;
                    log.warning("Monitor for %s already started", this.queue);
                    if (this.isRunning.compareAndSet(true, false)) break block10;
                    log.warning("Monitor for %s already stopped", this.queue);
                }
                this.execute();
                return;
            }
            try {
                log.debug("Start monitor for %s", this.queue);
                this.processMessages();
                if (this.isRunning.compareAndSet(true, false)) break block11;
            }
            catch (Exception e) {
                block12: {
                    try {
                        log.warning("Monitor for %s stopped, error: %s", this.queue, e);
                        this.isShutDown = true;
                        if (this.isRunning.compareAndSet(true, false)) break block12;
                    }
                    catch (Throwable throwable) {
                        if (!this.isRunning.compareAndSet(true, false)) {
                            log.warning("Monitor for %s already stopped", this.queue);
                        }
                        this.execute();
                        throw throwable;
                    }
                    log.warning("Monitor for %s already stopped", this.queue);
                }
                this.execute();
            }
            log.warning("Monitor for %s already stopped", this.queue);
        }
        this.execute();
    }

    @Override
    public void shutDown() {
        log.debug("Shut down monitor for %s", this.channel);
        this.isShutDown = true;
    }

    @Override
    public boolean isShutDown() {
        return this.isShutDown;
    }

    @Override
    public SQSQueue getQueue() {
        return this.queue;
    }

    @Override
    public SQSChannel getChannel() {
        return this.channel;
    }

    private void execute() {
        if (!this.isShutDown) {
            this.executor.execute(this);
        }
    }

    private void processMessages() {
        if (this.isShutDown) {
            return;
        }
        List<Message> messages = this.channel.getMessages();
        List<Message> proceedMessages = this.notifyListeners(messages);
        log.debug("Received %d messages, proceed %d messages", messages.size(), proceedMessages.size());
        this.channel.deleteMessages(messages);
    }

    private List<Message> notifyListeners(List<Message> messages) {
        ArrayList<Message> proceedMessages = new ArrayList<Message>();
        if (!messages.isEmpty()) {
            List<SQSQueueListener> listeners = this.getListeners();
            for (SQSQueueListener listener : listeners) {
                List<Message> msgs = listener.handleMessages(messages);
                proceedMessages.addAll(msgs);
            }
        }
        return proceedMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SQSQueueListener> getListeners() {
        Object object = this.listenersLock;
        synchronized (object) {
            return new ArrayList<SQSQueueListener>(this.listeners);
        }
    }
}

