/*
 * Decompiled with CFR 0.152.
 */
package com.ribose.jenkins.plugin.awscodecommittrigger.net;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.SQSQueue;
import com.ribose.jenkins.plugin.awscodecommittrigger.logging.Log;
import com.ribose.jenkins.plugin.awscodecommittrigger.net.RequestFactory;
import com.ribose.jenkins.plugin.awscodecommittrigger.net.SQSChannel;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;

public class SQSChannelImpl
implements SQSChannel {
    private static final Log log = Log.get(SQSChannelImpl.class);
    private final AmazonSQS sqs;
    private final SQSQueue queue;
    private final RequestFactory factory;
    private final AtomicInteger requestCount = new AtomicInteger(0);

    public SQSChannelImpl(AmazonSQS sqs, SQSQueue queue, RequestFactory factory) {
        this.sqs = sqs;
        this.queue = queue;
        this.factory = factory;
    }

    @Override
    public List<Message> getMessages() {
        log.debug("Star polling messages", new Object[0]);
        List messages = Collections.emptyList();
        try {
            log.debug("Requests count %d for %s", this.requestCount.incrementAndGet(), this.queue);
            ReceiveMessageRequest request = this.factory.createReceiveMessageRequest(this.queue);
            ReceiveMessageResult result = this.sqs.receiveMessage(request);
            log.debug("Send request to receive messages from queue %s", this.queue);
            if (result != null) {
                messages = result.getMessages();
            }
        }
        catch (AmazonServiceException e) {
            log.error("Poll request error", new Object[]{e});
            throw e;
        }
        return messages;
    }

    @Override
    public void deleteMessages(List<Message> messages) {
        if (CollectionUtils.isEmpty(messages)) {
            return;
        }
        DeleteMessageBatchResult result = this.deleteMessageBatch(messages);
        if (result == null) {
            return;
        }
        List failed = result.getFailed();
        List success = result.getSuccessful();
        log.debug("Delete %d message(s) (%d failed) from %s", success.size(), failed.size(), this.queue);
    }

    @Override
    public String getQueueUuid() {
        return this.queue.getUuid();
    }

    private DeleteMessageBatchResult deleteMessageBatch(List<Message> messages) {
        try {
            DeleteMessageBatchRequest request = this.factory.createDeleteMessageBatchRequest(this.queue, messages);
            log.debug("Send request to delete messages from queue %s", this.queue);
            return this.sqs.deleteMessageBatch(request);
        }
        catch (AmazonServiceException e) {
            log.warning("Unable delete messages from queue %s, error: %s", new Object[]{this.queue, e});
            return null;
        }
    }
}

