/*
 * Decompiled with CFR 0.152.
 */
package com.ribose.jenkins.plugin.awscodecommittrigger.model;

import com.amazonaws.services.sqs.model.Message;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.Event;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.MessageParser;
import com.ribose.jenkins.plugin.awscodecommittrigger.logging.Log;
import com.ribose.jenkins.plugin.awscodecommittrigger.model.entities.codecommit.CodeCommit;
import com.ribose.jenkins.plugin.awscodecommittrigger.model.entities.codecommit.CodeCommitEvent;
import com.ribose.jenkins.plugin.awscodecommittrigger.model.entities.codecommit.MessageBody;
import com.ribose.jenkins.plugin.awscodecommittrigger.model.entities.codecommit.Record;
import com.ribose.jenkins.plugin.awscodecommittrigger.model.entities.codecommit.Records;
import com.ribose.jenkins.plugin.awscodecommittrigger.model.entities.codecommit.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CodeCommitMessageParser
implements MessageParser {
    private static final Log log = Log.get(CodeCommitMessageParser.class);
    private static final String EVENT_SOURCE_CODECOMMIT = "aws:codecommit";
    private static final Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

    @Override
    public List<Event> parseMessage(Message message) {
        List<Event> events = Collections.emptyList();
        try {
            log.info("Retrieved message-id: %s", message.getMessageId());
            log.debug("Parse Message:\n%s", message.toString());
            String messageBody = message.getBody();
            log.debug("Retrieved message-body: %s", messageBody);
            MessageBody body = (MessageBody)gson.fromJson(messageBody, MessageBody.class);
            String recordsJson = body.getMessage();
            if (StringUtils.isBlank((String)recordsJson)) {
                log.warning("Message contains no text => Try to parse message-body instead", new Object[0]);
                recordsJson = messageBody;
            }
            events = this.parseEvents(StringUtils.defaultString((String)recordsJson));
        }
        catch (JsonSyntaxException e) {
            log.error("JSON syntax exception, cannot parse message: %s", new Object[]{e});
        }
        return events;
    }

    private List<Event> parseEvents(String recordsJson) {
        if (!recordsJson.startsWith("{") || !recordsJson.endsWith("}")) {
            log.warning("Message text is no JSON", new Object[0]);
            return Collections.emptyList();
        }
        return this.parseRecords(recordsJson);
    }

    private List<Event> parseRecords(String json) {
        Records records = (Records)gson.fromJson(json, Records.class);
        ArrayList<Event> events = new ArrayList<Event>(records.size());
        for (Record record : records) {
            this.parseEvents(events, record);
        }
        return events;
    }

    private void parseEvents(List<Event> events, Record record) {
        if (!this.isCodeCommitEvent(record)) {
            return;
        }
        CodeCommit codeCommit = record.getCodecommit();
        for (Reference reference : codeCommit.getReferences()) {
            CodeCommitEvent event = new CodeCommitEvent(record, reference);
            events.add(event);
        }
    }

    private boolean isCodeCommitEvent(Record record) {
        return StringUtils.equals((String)EVENT_SOURCE_CODECOMMIT, (String)record.getEventSource());
    }
}

