/*
 * Decompiled with CFR 0.152.
 */
package com.ribose.jenkins.plugin.awscodecommittrigger.logging;

import com.ribose.jenkins.plugin.awscodecommittrigger.SQSTriggerQueue;
import com.ribose.jenkins.plugin.awscodecommittrigger.model.job.SQSJob;
import hudson.model.Job;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

public class Log {
    private transient StreamHandler streamHandler;
    private transient Logger logger;
    private transient Class clazz;
    private transient boolean autoFormat = true;

    private Log(Class clazz) {
        this.clazz = clazz;
        this.logger = Logger.getLogger(this.clazz.getName());
    }

    public static Log get(Class clazz) {
        return new Log(clazz);
    }

    public static Log get(Class clazz, PrintStream out, boolean autoFormat) throws IOException {
        Log log = Log.get(clazz);
        log.autoFormat = autoFormat;
        log.streamHandler = new StreamHandler(out, new SimpleFormatter());
        log.logger.addHandler(log.streamHandler);
        return log;
    }

    public void error(String message, Object ... args) {
        this.write(Level.SEVERE, message, args);
    }

    public void error(String message, SQSJob job, Object ... args) {
        this.error(message, (Job)job.getJenkinsJob(), args);
    }

    public void error(String message, Job job, Object ... args) {
        this.write(Level.SEVERE, message, job, args);
    }

    public void info(String message, Object ... args) {
        this.write(Level.INFO, message, args);
    }

    public void info(String message, Job job, Object ... args) {
        this.write(Level.INFO, message, job, args);
    }

    public void info(String message, SQSJob job, Object ... args) {
        this.info(message, (Job)job.getJenkinsJob(), args);
    }

    public void debug(String message, Object ... args) {
        this.write(Level.CONFIG, message, args);
    }

    public void debug(String message, Job job, Object ... args) {
        this.write(Level.CONFIG, message, job, args);
    }

    public void debug(String message, SQSJob job, Object ... args) {
        this.debug(message, (Job)job.getJenkinsJob(), args);
    }

    public void warning(String message, Object ... args) {
        this.write(Level.WARNING, message, args);
    }

    private void write(Level level, String message, String jobName, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof SQSTriggerQueue) {
                args[i] = ((SQSTriggerQueue)args[i]).getUrl();
                continue;
            }
            if (!(args[i] instanceof Throwable)) continue;
            args[i] = ExceptionUtils.getStackTrace((Throwable)((Throwable)args[i]));
        }
        StringBuilder source = new StringBuilder();
        if (this.autoFormat) {
            String id = String.format("%06X", Thread.currentThread().getId());
            source.append("[").append(this.clazz.getCanonicalName()).append("]").append("[thread-").append(id).append("]");
            if (StringUtils.isNotBlank((String)jobName)) {
                source.append("[job-").append(jobName).append("]");
            }
        }
        String msg = String.format(message, args);
        if (level == Level.CONFIG) {
            msg = "[DEBUG] " + msg;
        } else if (level == Level.SEVERE) {
            msg = "[ERROR] " + msg;
        }
        this.logger.logp(level, source.toString(), "", msg);
        if (this.streamHandler != null) {
            this.streamHandler.flush();
        }
    }

    private void write(Level level, String message, Job job, Object ... args) {
        String name = job == null ? "--no-name--" : job.getName();
        this.write(level, message, name, args);
    }

    private void write(Level level, String message, Object ... args) {
        this.write(level, message, "", args);
    }

    public Logger getLogger() {
        return this.logger;
    }
}

