/*
 * Decompiled with CFR 0.152.
 */
package com.ribose.jenkins.plugin.awscodecommittrigger;

import com.amazonaws.services.sqs.model.Message;
import com.ribose.jenkins.plugin.awscodecommittrigger.SQSActivityAction;
import com.ribose.jenkins.plugin.awscodecommittrigger.logging.Log;
import com.ribose.jenkins.plugin.awscodecommittrigger.model.job.SQSJob;
import hudson.model.Cause;
import hudson.model.TaskListener;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SQSTriggerBuilder
implements Runnable {
    private final SQSJob job;
    private final Log log;
    private final TaskListener listener;
    private final Message message;
    private final String messageId;
    private final String userarns;

    public SQSTriggerBuilder(SQSJob job, Message message, List<String> userarns) throws IOException {
        this.job = job;
        this.message = message;
        SQSActivityAction activityAction = (SQSActivityAction)this.job.getJenkinsJob().getAction(SQSActivityAction.class);
        this.listener = new StreamTaskListener(activityAction.getActivityLogFile(), true, Charset.forName("UTF-8"));
        this.log = Log.get(SQSTriggerBuilder.class, this.listener.getLogger(), true);
        this.messageId = message.getMessageId();
        this.userarns = StringUtils.join(userarns, (String)"");
        this.log.info("Try to trigger the build for message: %s", this.messageId);
        this.log.debug("Print out message-body: %s", message.getBody());
    }

    @Override
    public void run() {
        boolean hasChanges = this.job.poll(this.listener).hasChanges();
        this.log.debug("Any code changes found in SCM? %s", hasChanges);
        if (hasChanges) {
            this.startJob();
        } else {
            this.log.info("Cancel the build since no change found", new Object[0]);
        }
    }

    private void startJob() {
        Cause.RemoteCause cause = new Cause.RemoteCause("SQSTrigger", String.format("User invoked: %s", this.userarns));
        boolean scheduled = this.job.scheduleBuild((Cause)cause);
        this.log.info("The build is scheduled? %s by Message: %s", scheduled, this.messageId);
    }
}

