/*
 * Decompiled with CFR 0.152.
 */
package com.ribose.jenkins.plugin.awscodecommittrigger;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.sqs.model.Message;
import com.cloudbees.jenkins.plugins.awscredentials.AWSCredentialsImpl;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.ribose.jenkins.plugin.awscodecommittrigger.Context;
import com.ribose.jenkins.plugin.awscodecommittrigger.PluginInfo;
import com.ribose.jenkins.plugin.awscodecommittrigger.SQSActivityAction;
import com.ribose.jenkins.plugin.awscodecommittrigger.SQSScmConfig;
import com.ribose.jenkins.plugin.awscodecommittrigger.SQSTriggerBuilder;
import com.ribose.jenkins.plugin.awscodecommittrigger.SQSTriggerQueue;
import com.ribose.jenkins.plugin.awscodecommittrigger.credentials.AwsCredentialsHelper;
import com.ribose.jenkins.plugin.awscodecommittrigger.credentials.StandardAwsCredentials;
import com.ribose.jenkins.plugin.awscodecommittrigger.exception.UnexpectedException;
import com.ribose.jenkins.plugin.awscodecommittrigger.i18n.sqstrigger.Messages;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.Event;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.EventTriggerMatcher;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.MessageParser;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.MessageParserFactory;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.SQSQueue;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.SQSQueueListener;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.SQSQueueMonitorScheduler;
import com.ribose.jenkins.plugin.awscodecommittrigger.logging.Log;
import com.ribose.jenkins.plugin.awscodecommittrigger.model.events.ConfigurationChangedEvent;
import com.ribose.jenkins.plugin.awscodecommittrigger.model.events.EventBroker;
import com.ribose.jenkins.plugin.awscodecommittrigger.model.job.RepoInfo;
import com.ribose.jenkins.plugin.awscodecommittrigger.model.job.SQSJob;
import com.ribose.jenkins.plugin.awscodecommittrigger.model.job.SQSJobFactory;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.security.AccessDeniedException2;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.SequentialExecutionQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class SQSTrigger
extends Trigger<Job<?, ?>>
implements SQSQueueListener {
    private static final Log log = Log.get(SQSTrigger.class);
    private String queueUuid;
    private List<SQSScmConfig> sqsScmConfigs;
    private boolean subscribeInternalScm;
    @Inject
    private transient SQSQueueMonitorScheduler scheduler;
    @Inject
    private transient MessageParserFactory messageParserFactory;
    @Inject
    private transient EventTriggerMatcher eventTriggerMatcher;
    @Inject
    private transient SQSJobFactory sqsJobFactory;
    @Inject
    private transient ExecutorService executor;
    private transient SQSJob sqsJob;
    private transient List<SQSActivityAction> actions;

    @DataBoundConstructor
    public SQSTrigger(String queueUuid, boolean subscribeInternalScm, List<SQSScmConfig> sqsScmConfigs) {
        this.queueUuid = queueUuid;
        this.sqsScmConfigs = sqsScmConfigs;
        this.subscribeInternalScm = subscribeInternalScm;
    }

    public Collection<? extends Action> getProjectActions() {
        if (this.job != null && CollectionUtils.isEmpty(this.actions)) {
            this.actions = Collections.singletonList(new SQSActivityAction((Job)this.job));
        }
        if (this.actions == null) {
            this.actions = Collections.emptyList();
        }
        return this.actions;
    }

    private void loadSqsJob() {
        Context.injector().injectMembers((Object)this);
        log.debug("Job is AbstractProject? %s or WorkflowJob? %s", (Job)this.job, new Object[]{this.job instanceof AbstractProject, this.job instanceof WorkflowJob});
        this.sqsJob = this.sqsJobFactory.createSqsJob((Job)this.job, this);
    }

    public void start(@Nonnull Job<?, ?> job, boolean newInstance) {
        super.start(job, newInstance);
        this.loadSqsJob();
        DescriptorImpl descriptor = (DescriptorImpl)this.getDescriptor();
        descriptor.queue.execute(new Runnable(){

            @Override
            public void run() {
                boolean succeed = SQSTrigger.this.scheduler.register(SQSTrigger.this);
                log.debug("Register trigger for %s? %s", (Job)SQSTrigger.this.job, new Object[]{SQSTrigger.this.getQueueUuid(), succeed});
            }
        });
    }

    public void stop() {
        super.stop();
        DescriptorImpl descriptor = (DescriptorImpl)this.getDescriptor();
        descriptor.queue.execute(new Runnable(){

            @Override
            public void run() {
                boolean succeed = SQSTrigger.this.scheduler.unregister(SQSTrigger.this);
                log.debug("Unregister trigger %s", (Job)SQSTrigger.this.job, new Object[]{succeed});
            }
        });
    }

    @Override
    public List<Message> handleMessages(List<Message> messages) {
        ArrayList<Message> proceedMessages = new ArrayList<Message>();
        for (Message message : messages) {
            if (!this.handleMessage(message)) continue;
            proceedMessages.add(message);
        }
        return proceedMessages;
    }

    @Override
    public String getQueueUuid() {
        return this.queueUuid;
    }

    @CheckForNull
    public List<SQSScmConfig> getSqsScmConfigs() {
        return this.sqsScmConfigs;
    }

    public boolean isSubscribeInternalScm() {
        return this.subscribeInternalScm;
    }

    private boolean handleMessage(Message message) {
        log.debug("Parse and do match against events, message: %s", (Job)this.job, new Object[]{message.getBody()});
        MessageParser parser = this.messageParserFactory.createParser(message);
        List<Event> events = parser.parseMessage(message);
        boolean matched = this.eventTriggerMatcher.matches(events, this.sqsJob);
        log.info("Any event matched? %s. Message: %s", (Job)this.job, new Object[]{matched, message.getMessageId()});
        if (matched) {
            log.debug("Hurray! Execute it", (Job)this.job, new Object[0]);
            ArrayList<String> userarns = new ArrayList<String>();
            for (Event event : events) {
                userarns.add(event.getUser());
            }
            this.execute(message, userarns);
            return true;
        }
        return false;
    }

    private void execute(final @Nonnull Message message, final List<String> userarns) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    new SQSTriggerBuilder(SQSTrigger.this.sqsJob, message, userarns).run();
                }
                catch (Exception e) {
                    UnexpectedException error = new UnexpectedException(e);
                    log.error("Unable to execute job for this message %s, cause: %s", (Job)SQSTrigger.this.job, new Object[]{message.getMessageId(), error});
                    throw error;
                }
            }
        });
    }

    public boolean isWorkflowJob() {
        return this.job instanceof WorkflowJob;
    }

    public String getJobName() {
        assert (this.job != null);
        return ((Job)this.job).getName();
    }

    public void setScheduler(SQSQueueMonitorScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setMessageParserFactory(MessageParserFactory messageParserFactory) {
        this.messageParserFactory = messageParserFactory;
    }

    public void setEventTriggerMatcher(EventTriggerMatcher eventTriggerMatcher) {
        this.eventTriggerMatcher = eventTriggerMatcher;
    }

    public void setSqsJobFactory(SQSJobFactory sqsJobFactory) {
        this.sqsJobFactory = sqsJobFactory;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void setSqsScmConfigs(List<SQSScmConfig> sqsScmConfigs) {
        this.sqsScmConfigs = sqsScmConfigs;
    }

    public void setSubscribeInternalScm(boolean subscribeInternalScm) {
        this.subscribeInternalScm = subscribeInternalScm;
    }

    public void setSqsJob(SQSJob sqsJob) {
        this.sqsJob = sqsJob;
    }

    public void setQueueUuid(String queueUuid) {
        this.queueUuid = queueUuid;
    }

    public void setActions(List<SQSActivityAction> actions) {
        this.actions = actions;
    }

    @Extension
    public static final class DescriptorImpl
    extends TriggerDescriptor {
        private volatile List<SQSTriggerQueue> sqsQueues;
        private volatile transient Map<String, SQSTriggerQueue> sqsQueueMap;
        private transient boolean isLoaded;
        private final transient SequentialExecutionQueue queue = new SequentialExecutionQueue(Executors.newSingleThreadExecutor());
        private transient SQSJobFactory sqsJobFactory = (SQSJobFactory)Context.injector().getBinding(SQSJobFactory.class).getProvider().get();

        public DescriptorImpl() {
            super(SQSTrigger.class);
        }

        public Trigger newInstance(StaplerRequest req, @Nonnull JSONObject jsonObject) throws Descriptor.FormException {
            if (jsonObject.has("subscribeInternalScm")) {
                jsonObject.put("subscribeInternalScm", (Object)Boolean.TRUE);
            }
            return (Trigger)super.newInstance(req, jsonObject);
        }

        public synchronized void load() {
            super.load();
            this.initQueueMap();
            this.isLoaded = true;
        }

        public boolean isApplicable(Item item) {
            return item instanceof Job;
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.displayName();
        }

        public RepoInfo getRepoInfo(Job job) {
            SQSJob sqsJob = this.sqsJobFactory.createSqsJob(job, null);
            return RepoInfo.fromSqsJob(sqsJob);
        }

        public ListBoxModel doFillQueueUuidItems() {
            List<SQSTriggerQueue> queues = this.getSqsQueues();
            ListBoxModel items = new ListBoxModel();
            for (SQSTriggerQueue queue : queues) {
                items.add(queue.getName(), queue.getUuid());
            }
            return items;
        }

        public FormValidation doCheckQueueUuid(@QueryParameter String value) {
            if (this.getSqsQueues().size() == 0) {
                return FormValidation.error((String)Messages.errorQueueUnavailable());
            }
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.ok((String)Messages.infoQueueDefault());
            }
            SQSQueue queue = this.getSqsQueue(value);
            if (queue == null) {
                return FormValidation.error((String)Messages.errorQueueUuidUnknown());
            }
            return FormValidation.ok();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            Object sqsQueues = json.get("sqsQueues");
            if (json.size() == 1) {
                String key = json.keys().next().toString();
                sqsQueues = json.getJSONObject(key).get("sqsQueues");
            }
            this.sqsQueues = req.bindJSONToList(SQSTriggerQueue.class, sqsQueues);
            this.initQueueMap();
            this.save();
            EventBroker.getInstance().post(new ConfigurationChangedEvent());
            return true;
        }

        public List<SQSTriggerQueue> getSqsQueues() {
            if (!this.isLoaded) {
                this.load();
            }
            if (this.sqsQueues == null) {
                return Collections.emptyList();
            }
            return this.sqsQueues;
        }

        public SQSQueue getSqsQueue(String uuid) {
            if (!this.isLoaded) {
                this.load();
            }
            if (this.sqsQueueMap == null) {
                return null;
            }
            return this.sqsQueueMap.get(uuid);
        }

        private void initQueueMap() {
            if (this.sqsQueues == null) {
                return;
            }
            for (SQSTriggerQueue sqsQueue : this.sqsQueues) {
                String version = sqsQueue.getVersion();
                boolean compatible = PluginInfo.checkPluginCompatibility(version);
                sqsQueue.setCompatible(compatible);
            }
            this.sqsQueueMap = Maps.newHashMapWithExpectedSize((int)this.sqsQueues.size());
            for (SQSTriggerQueue queue : this.sqsQueues) {
                this.sqsQueueMap.put(queue.getUuid(), queue);
            }
        }

        public boolean checkCompatible() {
            if (!this.isLoaded) {
                this.load();
            }
            if (this.sqsQueues == null) {
                return true;
            }
            for (SQSTriggerQueue sqsQueue : this.sqsQueues) {
                if (sqsQueue.isCompatible()) continue;
                return false;
            }
            return true;
        }

        public FormValidation doMigration() {
            try {
                Jenkins jenkins = Jenkins.getInstanceOrNull();
                if (jenkins == null) {
                    return FormValidation.error((String)"No running Jenkins instance");
                }
                jenkins.checkPermission(CredentialsProvider.CREATE);
            }
            catch (AccessDeniedException2 e) {
                return FormValidation.error((String)"No Permission to Create new Credentials in the System");
            }
            SystemCredentialsProvider provider = SystemCredentialsProvider.getInstance();
            List globalCredentials = (List)provider.getDomainCredentialsMap().get(Domain.global());
            HashSet<StandardAwsCredentials> deprecates = new HashSet<StandardAwsCredentials>();
            for (SQSTriggerQueue sqsQueue : this.sqsQueues) {
                if (!sqsQueue.isCompatible()) {
                    if (StringUtils.isBlank((String)sqsQueue.getVersion())) {
                        log.debug("Detected config version is 1x", new Object[0]);
                        return FormValidation.error((String)"Unable to upgrade to %s, please upgrade to version 2x before using this version", (Object[])new Object[]{"3.0.12"});
                    }
                    StandardAwsCredentials cred = AwsCredentialsHelper.getCredentials(StandardAwsCredentials.class, sqsQueue.getCredentialsId());
                    if (cred == null) continue;
                    String accountId = cred.getAWSAccessKeyId();
                    String secret = cred.getAWSSecretKey();
                    Optional<Credentials> foundCredentials = globalCredentials.stream().filter(o -> {
                        if (o instanceof AmazonWebServicesCredentials) {
                            AWSCredentials c = ((AmazonWebServicesCredentials)o).getCredentials();
                            return c.getAWSAccessKeyId().equals(accountId) && c.getAWSSecretKey().equals(secret);
                        }
                        return false;
                    }).findFirst();
                    AmazonWebServicesCredentials credentials = null;
                    if (foundCredentials.isPresent()) {
                        credentials = (AmazonWebServicesCredentials)foundCredentials.get();
                    } else {
                        credentials = new AWSCredentialsImpl(CredentialsScope.GLOBAL, UUID.randomUUID().toString(), accountId, secret, "migrated from credential-id: " + sqsQueue.getCredentialsId());
                        globalCredentials.add(credentials);
                    }
                    sqsQueue.setCredentialsId(credentials.getId());
                    deprecates.add(cred);
                }
                sqsQueue.setVersion("3.0.12");
            }
            if (deprecates.size() > 0) {
                globalCredentials.removeAll(deprecates);
            }
            try {
                provider.save();
            }
            catch (IOException e) {
                return FormValidation.error((String)"Unable to create credentials in Global Scope");
            }
            this.save();
            this.load();
            EventBroker.getInstance().post(new ConfigurationChangedEvent());
            log.info("Migration successful for %s queues", this.sqsQueues.size());
            return FormValidation.ok((String)"Migration successful, click here to refresh the page");
        }
    }
}

