/*
 * Decompiled with CFR 0.152.
 */
package com.ribose.jenkins.plugin.awscodecommittrigger;

import com.google.inject.Inject;
import com.ribose.jenkins.plugin.awscodecommittrigger.Context;
import com.ribose.jenkins.plugin.awscodecommittrigger.i18n.sqsscmconfig.Messages;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.ScmFactory;
import com.ribose.jenkins.plugin.awscodecommittrigger.utils.StringUtils;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class SQSScmConfig
extends AbstractDescribableImpl<SQSScmConfig> {
    private String subscribedBranches;
    private Type type;
    private String url;
    private transient List<BranchSpec> branchSpecs;
    @Inject
    private transient ScmFactory scmFactory;

    @DataBoundConstructor
    public SQSScmConfig(String type, String url, String subscribedBranches) {
        this.subscribedBranches = subscribedBranches;
        this.type = "ER".equalsIgnoreCase(type) ? Type.ManualSubscription : ("IR".equalsIgnoreCase(type) ? Type.AutoSubscription : Type.valueOf(type));
        if (this.type == Type.AutoSubscription) {
            url = "";
        }
        this.url = url;
    }

    public String getSubscribedBranches() {
        return this.subscribedBranches;
    }

    public Type getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public ScmFactory getScmFactory() {
        if (this.scmFactory == null) {
            this.scmFactory = (ScmFactory)Context.injector().getBinding(ScmFactory.class).getProvider().get();
        }
        return this.scmFactory;
    }

    public List<BranchSpec> getBranchSpecs() {
        if (CollectionUtils.isEmpty(this.branchSpecs)) {
            this.branchSpecs = new ArrayList<BranchSpec>();
            List<String> branches = StringUtils.parseCsvString(this.subscribedBranches);
            for (String branch : branches) {
                this.branchSpecs.add(new BranchSpec(branch));
            }
        }
        return this.branchSpecs;
    }

    public GitSCM toGitSCM() {
        return this.getScmFactory().createGit(this.url, this.getBranchSpecs());
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<SQSScmConfig> {
        public SQSScmConfig newInstance(StaplerRequest req, @Nonnull JSONObject jsonObject) throws Descriptor.FormException {
            Object typeObject = jsonObject.get("type");
            if (typeObject.getClass().isAssignableFrom(JSONObject.class)) {
                JSONObject jsonType = jsonObject.getJSONObject("type");
                jsonObject.put("type", (Object)jsonType.getString("value"));
            }
            return (SQSScmConfig)super.newInstance(req, jsonObject);
        }

        public FormValidation doCheckUrl(@QueryParameter String url) {
            if (org.apache.commons.lang.StringUtils.isBlank((String)url)) {
                return FormValidation.warning((String)Messages.warningBlankUrl());
            }
            return StringUtils.isCodeCommitRepo(url) ? FormValidation.ok() : FormValidation.error((String)Messages.errorCodeCommitUrlInvalid());
        }
    }

    public static enum Type {
        AutoSubscription,
        ManualSubscription;

    }
}

