/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.authorizeproject.strategy;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.ApiTokenProperty;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectProperty;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectStrategy;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectStrategyDescriptor;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectUtil;
import org.jenkinsci.plugins.authorizeproject.strategy.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class SpecificUsersAuthorizationStrategy
extends AuthorizeProjectStrategy {
    private static Logger LOGGER = Logger.getLogger(SpecificUsersAuthorizationStrategy.class.getName());
    private final String userid;
    private static final Authentication[] BUILTIN_USERS = new Authentication[]{ACL.SYSTEM, Jenkins.ANONYMOUS};
    private transient Boolean noNeedReauthentication;
    private boolean dontRestrictJobConfiguration;

    public String getUserid() {
        return this.userid;
    }

    public boolean isDontRestrictJobConfiguration() {
        return this.dontRestrictJobConfiguration;
    }

    @DataBoundSetter
    public void setDontRestrictJobConfiguration(boolean dontRestrictPermission) {
        this.dontRestrictJobConfiguration = dontRestrictPermission;
    }

    public SpecificUsersAuthorizationStrategy(String userid) {
        this.userid = StringUtils.trim((String)userid);
        this.dontRestrictJobConfiguration = false;
        for (Authentication a : BUILTIN_USERS) {
            if (!AuthorizeProjectUtil.userIdEquals(this.userid, a.getPrincipal().toString())) continue;
            throw new IllegalArgumentException(Messages.SpecificUsersAuthorizationStrategy_userid_builtin());
        }
    }

    @DataBoundConstructor
    public SpecificUsersAuthorizationStrategy(String userid, boolean useApitoken, String apitoken, String password) throws AccessDeniedException {
        this(userid);
        if (SpecificUsersAuthorizationStrategy.isAuthenticationRequired(this.getUserid()) && !SpecificUsersAuthorizationStrategy.authenticate(this.getUserid(), useApitoken, apitoken, password)) {
            throw new AccessDeniedException(Messages.SpecificUsersAuthorizationStrategy_userid_authenticate());
        }
    }

    static boolean authenticate(String userId, boolean useApitoken, String apitoken, String password) {
        if (useApitoken) {
            ApiTokenProperty p;
            User u;
            if (apitoken != null && (u = User.get((String)userId, (boolean)false, Collections.emptyMap())) != null && (p = (ApiTokenProperty)u.getProperty(ApiTokenProperty.class)) != null && p.matchesPassword(apitoken)) {
                return true;
            }
        } else if (password != null) {
            try {
                Jenkins.get().getSecurityRealm().getSecurityComponents().manager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)userId, (Object)password));
                return true;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, String.format("Failed to authenticate %s", userId), e);
            }
        }
        return false;
    }

    protected static boolean isAuthenticationRequired(String userId) {
        if (Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return false;
        }
        User u = User.current();
        return u == null || !AuthorizeProjectUtil.userIdEquals(u.getId(), userId);
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Override
    public Authentication authenticate(Job<?, ?> project, Queue.Item item) {
        User u = User.get((String)this.getUserid(), (boolean)false, Collections.emptyMap());
        if (u == null) {
            return Jenkins.ANONYMOUS;
        }
        try {
            Authentication a = u.impersonate();
            return a;
        }
        catch (UsernameNotFoundException e) {
            LOGGER.log(Level.WARNING, String.format("Invalid User %s. Falls back to anonymous.", this.getUserid()), e);
            return Jenkins.ANONYMOUS;
        }
    }

    @Override
    public boolean hasJobConfigurePermission(AccessControlled context) {
        if (this.isDontRestrictJobConfiguration()) {
            return true;
        }
        return AuthorizeProjectUtil.userIdEquals(Jenkins.getAuthentication().getName(), this.userid);
    }

    @Override
    public boolean hasAuthorizationConfigurePermission(AccessControlled context) {
        return !SpecificUsersAuthorizationStrategy.isAuthenticationRequired(this.getUserid());
    }

    protected static SpecificUsersAuthorizationStrategy getCurrentStrategy(Job<?, ?> project) {
        if (project == null) {
            return null;
        }
        AuthorizeProjectProperty prop = (AuthorizeProjectProperty)project.getProperty(AuthorizeProjectProperty.class);
        if (prop == null) {
            return null;
        }
        if (!(prop.getStrategy() instanceof SpecificUsersAuthorizationStrategy)) {
            return null;
        }
        return (SpecificUsersAuthorizationStrategy)prop.getStrategy();
    }

    @Override
    protected Object readResolve() throws ObjectStreamException {
        SpecificUsersAuthorizationStrategy self = (SpecificUsersAuthorizationStrategy)((Object)super.readResolve());
        if (self.noNeedReauthentication != null) {
            self.setDontRestrictJobConfiguration(self.noNeedReauthentication);
        }
        return self;
    }

    @Extension
    public static class DescriptorImpl
    extends AuthorizeProjectStrategyDescriptor {
        public String getDisplayName() {
            return Messages.SpecificUsersAuthorizationStrategy_DisplayName();
        }

        @Restricted(value={NoExternalUse.class})
        public String calcCheckPasswordRequestedUrl() {
            return String.format("'%s/%s/checkPasswordRequested' + qs(this).nearBy('userid')", DescriptorImpl.getCurrentDescriptorByNameUrl(), this.getDescriptorUrl());
        }

        @Restricted(value={NoExternalUse.class})
        public String doCheckPasswordRequested(StaplerRequest req, @QueryParameter String userid) {
            return Boolean.toString(SpecificUsersAuthorizationStrategy.isAuthenticationRequired(userid.trim()));
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckUserid(@QueryParameter String userid) {
            if (StringUtils.isBlank((String)userid)) {
                return FormValidation.error((String)Messages.SpecificUsersAuthorizationStrategy_userid_required());
            }
            for (Authentication a : BUILTIN_USERS) {
                if (!AuthorizeProjectUtil.userIdEquals(userid, a.getPrincipal().toString())) continue;
                return FormValidation.error((String)Messages.SpecificUsersAuthorizationStrategy_userid_builtin());
            }
            return FormValidation.ok();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckPassword(StaplerRequest req, @QueryParameter String userid, @QueryParameter String password, @QueryParameter String apitoken, @QueryParameter boolean useApitoken) {
            if (!SpecificUsersAuthorizationStrategy.isAuthenticationRequired(userid.trim())) {
                return FormValidation.ok();
            }
            if (useApitoken ? StringUtils.isBlank((String)apitoken) : StringUtils.isBlank((String)password)) {
                return FormValidation.error((String)Messages.SpecificUsersAuthorizationStrategy_password_required());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDontRestrictJobConfiguration(@QueryParameter boolean dontRestrictJobConfiguration) {
            if (dontRestrictJobConfiguration) {
                return FormValidation.warning((String)Messages.SpecificUsersAuthorizationStrategy_dontRestrictJobConfiguration_usage());
            }
            return FormValidation.ok();
        }

        @Restricted(value={NoExternalUse.class})
        public boolean isUseApitoken() {
            return !(Jenkins.get().getSecurityRealm() instanceof AbstractPasswordBasedSecurityRealm);
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }
    }
}

