/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.authorizeproject;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Job;
import hudson.model.Queue;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import jenkins.security.QueueItemAuthenticator;
import jenkins.security.QueueItemAuthenticatorConfiguration;
import jenkins.security.QueueItemAuthenticatorDescriptor;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectProperty;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectStrategy;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectStrategyDescriptor;
import org.jenkinsci.plugins.authorizeproject.Messages;
import org.kohsuke.stapler.StaplerRequest;

public class ProjectQueueItemAuthenticator
extends QueueItemAuthenticator {
    private final Map<String, Boolean> strategyEnabledMap;

    @Deprecated
    public ProjectQueueItemAuthenticator() {
        this(Collections.emptyMap());
    }

    public ProjectQueueItemAuthenticator(Map<String, Boolean> strategyEnabledMap) {
        this.strategyEnabledMap = strategyEnabledMap;
    }

    protected Object readResolve() {
        if (this.strategyEnabledMap == null) {
            return new ProjectQueueItemAuthenticator(Collections.emptyMap());
        }
        return this;
    }

    @CheckForNull
    public Authentication authenticate(Queue.Item item) {
        AuthorizeProjectProperty prop;
        if (!(item.task instanceof Job)) {
            return null;
        }
        Job project = (Job)item.task;
        if (project instanceof AbstractProject) {
            project = ((AbstractProject)project).getRootProject();
        }
        if ((prop = (AuthorizeProjectProperty)project.getProperty(AuthorizeProjectProperty.class)) == null) {
            return null;
        }
        return prop.authenticate(item);
    }

    public Map<String, Boolean> getStrategyEnabledMap() {
        return this.strategyEnabledMap;
    }

    public boolean isStrategyEnabled(Descriptor<?> d) {
        Boolean b = this.getStrategyEnabledMap().get(d.getId());
        if (b != null) {
            return b;
        }
        if (!(d instanceof AuthorizeProjectStrategyDescriptor)) {
            return true;
        }
        return ((AuthorizeProjectStrategyDescriptor)d).isEnabledByDefault();
    }

    public static ProjectQueueItemAuthenticator getConfigured() {
        for (QueueItemAuthenticator authenticator : QueueItemAuthenticatorConfiguration.get().getAuthenticators()) {
            if (!(authenticator instanceof ProjectQueueItemAuthenticator)) continue;
            return (ProjectQueueItemAuthenticator)authenticator;
        }
        return null;
    }

    public static boolean isConfigured() {
        return ProjectQueueItemAuthenticator.getConfigured() != null;
    }

    @Extension
    public static class DescriptorVisibilityFilterImpl
    extends DescriptorVisibilityFilter {
        public boolean filter(Object context, Descriptor descriptor) {
            if (!(context instanceof ProjectQueueItemAuthenticator)) {
                return true;
            }
            return ((ProjectQueueItemAuthenticator)((Object)context)).isStrategyEnabled(descriptor);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends QueueItemAuthenticatorDescriptor {
        public String getDisplayName() {
            return Messages.ProjectQueueItemAuthenticator_DisplayName();
        }

        @Deprecated
        public List<AuthorizeProjectStrategyDescriptor> getDescriptorsForGlobalSecurityConfigPage() {
            return AuthorizeProjectStrategyDescriptor.getDescriptorsForGlobalSecurityConfigPage();
        }

        public List<Descriptor<AuthorizeProjectStrategy>> getAvailableDescriptorList() {
            return AuthorizeProjectStrategy.all();
        }

        public ProjectQueueItemAuthenticator newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            HashMap<String, Boolean> strategyEnabledMap = new HashMap<String, Boolean>();
            for (Descriptor<AuthorizeProjectStrategy> d : this.getAvailableDescriptorList()) {
                String name = d.getJsonSafeClassName();
                if (formData.has(name)) {
                    strategyEnabledMap.put(d.getId(), true);
                    if (!(d instanceof AuthorizeProjectStrategyDescriptor) || ((AuthorizeProjectStrategyDescriptor)d).getGlobalSecurityConfigPage() == null) continue;
                    ((AuthorizeProjectStrategyDescriptor)d).configureFromGlobalSecurity(req, formData.getJSONObject(name));
                    continue;
                }
                strategyEnabledMap.put(d.getId(), false);
            }
            return new ProjectQueueItemAuthenticator(strategyEnabledMap);
        }
    }
}

