/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.authorizeproject;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Queue;
import jenkins.security.QueueItemAuthenticator;
import jenkins.security.QueueItemAuthenticatorDescriptor;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectStrategy;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectStrategyDescriptor;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectUtil;
import org.jenkinsci.plugins.authorizeproject.Messages;
import org.jenkinsci.plugins.authorizeproject.strategy.AnonymousAuthorizationStrategy;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class GlobalQueueItemAuthenticator
extends QueueItemAuthenticator {
    private final AuthorizeProjectStrategy strategy;

    @DataBoundConstructor
    public GlobalQueueItemAuthenticator(AuthorizeProjectStrategy strategy) {
        this.strategy = strategy;
    }

    public AuthorizeProjectStrategy getStrategy() {
        return this.strategy;
    }

    public Authentication authenticate(Queue.Item item) {
        return this.strategy != null && item.task instanceof Job ? this.strategy.authenticate((Job)item.task, item) : null;
    }

    @Extension
    public static class DescriptorImpl
    extends QueueItemAuthenticatorDescriptor {
        public String getDisplayName() {
            return Messages.GlobalQueueItemAuthenticator_DisplayName();
        }

        public Iterable<Descriptor<AuthorizeProjectStrategy>> getStrategyDescriptors() {
            return Iterables.filter(AuthorizeProjectStrategy.all(), (Predicate)new Predicate<Descriptor<AuthorizeProjectStrategy>>(){

                public boolean apply(Descriptor<AuthorizeProjectStrategy> d) {
                    if (!(d instanceof AuthorizeProjectStrategyDescriptor)) {
                        return true;
                    }
                    return ((AuthorizeProjectStrategyDescriptor)d).isApplicableToGlobal();
                }
            });
        }

        public AuthorizeProjectStrategy getDefaultStrategy() {
            return new AnonymousAuthorizationStrategy();
        }

        public GlobalQueueItemAuthenticator newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (formData == null || formData.isNullObject()) {
                return null;
            }
            AuthorizeProjectStrategy strategy = AuthorizeProjectUtil.bindJSONWithDescriptor(req, formData, "strategy", AuthorizeProjectStrategy.class);
            return new GlobalQueueItemAuthenticator(strategy);
        }
    }
}

