/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.authorizeproject;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.security.AccessControlled;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectProperty;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectStrategy;
import org.jenkinsci.plugins.authorizeproject.ProjectQueueItemAuthenticator;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

@Restricted(value={NoExternalUse.class})
public class ConfigurationPermissionEnforcer
extends JobProperty<Job<?, ?>> {
    @DataBoundConstructor
    public ConfigurationPermissionEnforcer() {
    }

    @Extension(ordinal=1.7976931348623157E308)
    @Restricted(value={NoExternalUse.class})
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return "ConfigurationPermissionEnforcer";
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            Job job = (Job)req.findAncestorObject(Job.class);
            AccessControlled context = (AccessControlled)req.findAncestorObject(AccessControlled.class);
            this.checkConfigurePermission(job, context);
            return null;
        }

        private void checkConfigurePermission(@CheckForNull Job<?, ?> job, @CheckForNull AccessControlled context) {
            if (job == null) {
                return;
            }
            if (context == null) {
                context = job;
            }
            if (Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return;
            }
            AuthorizeProjectProperty property = (AuthorizeProjectProperty)job.getProperty(AuthorizeProjectProperty.class);
            if (property == null) {
                return;
            }
            if (!ProjectQueueItemAuthenticator.isConfigured()) {
                return;
            }
            AuthorizeProjectStrategy strategy = property.getStrategy();
            if (strategy == null) {
                return;
            }
            strategy.checkJobConfigurePermission((AccessControlled)context);
        }
    }
}

