/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.audit_trail;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.plugins.audit_trail.AuditLogger;
import hudson.plugins.audit_trail.AuditTrailFilter;
import hudson.plugins.audit_trail.LogFileAuditLogger;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Symbol(value={"audit-trail"})
@Extension
public class AuditTrailPlugin
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(AuditTrailPlugin.class.getName());
    private String pattern = ".*/(?:configSubmit|doDelete|postBuildResult|enable|disable|cancelQueue|stop|toggleLogKeep|doWipeOutWorkspace|createItem|createView|toggleOffline|cancelQuietDown|quietDown|restart|exit|safeExit)";
    private boolean logBuildCause = true;
    private List<AuditLogger> loggers = new ArrayList<AuditLogger>();
    private transient String log;

    public String getPattern() {
        return this.pattern;
    }

    public boolean getLogBuildCause() {
        return this.logBuildCause;
    }

    public List<AuditLogger> getLoggers() {
        return this.loggers;
    }

    public AuditTrailPlugin() {
        this.load();
    }

    public boolean configure(StaplerRequest req, JSONObject formData) {
        this.loggers.forEach(AuditLogger::cleanUp);
        req.bindJSON((Object)this, formData);
        return true;
    }

    @DataBoundSetter
    public void setPattern(String pattern) {
        this.pattern = Optional.ofNullable(pattern).orElse("");
        this.updateFilterPattern();
        this.save();
    }

    @DataBoundSetter
    public void setLogBuildCause(boolean logBuildCause) {
        this.logBuildCause = logBuildCause;
        this.save();
    }

    private void updateFilterPattern() {
        try {
            AuditTrailFilter.setPattern(this.pattern);
        }
        catch (PatternSyntaxException ex) {
            ex.printStackTrace();
        }
    }

    @Deprecated
    public DescriptorExtensionList<AuditLogger, Descriptor<AuditLogger>> getLoggerDescriptors() {
        return AuditLogger.all();
    }

    @DataBoundSetter
    public void setLoggers(List<AuditLogger> loggers) {
        this.loggers = Optional.ofNullable(loggers).orElse(Collections.emptyList());
    }

    @Restricted(value={DoNotUse.class})
    @Deprecated
    public void onFinalized(Run run) {
        LOGGER.warning("AuditTrailPlugin#onFinalized does nothing anymore, please update your script");
    }

    @Restricted(value={DoNotUse.class})
    @Deprecated
    public void onFinalized(AbstractBuild build) {
        LOGGER.warning("AuditTrailPlugin#onFinalized does nothing anymore, please update your script");
    }

    private Object readResolve() {
        if (this.log != null) {
            LogFileAuditLogger logger;
            if (this.loggers == null) {
                this.loggers = new ArrayList<AuditLogger>();
            }
            if (!this.loggers.contains(logger = new LogFileAuditLogger(this.log, 1, 1))) {
                this.loggers.add(logger);
            }
            this.log = null;
        }
        this.updateFilterPattern();
        return this;
    }

    public FormValidation doRegexCheck(@QueryParameter String value) throws IOException, ServletException {
        try {
            Pattern.compile(value);
            return FormValidation.ok();
        }
        catch (Exception ex) {
            return FormValidation.errorWithMarkup((String)("Invalid <a href=\"http://docs.oracle.com/javase/7/docs/api/java/util/regex/Pattern.html\">regular expression</a> (" + ex.getMessage() + ")"));
        }
    }

    protected XmlFile getConfigFile() {
        return new XmlFile(new File(Jenkins.get().getRootDir(), "audit-trail.xml"));
    }
}

