/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugin.assembla.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jenkins.plugin.assembla.api.AbstractAssemblaAPI;
import jenkins.plugin.assembla.api.AssemblaSite;
import jenkins.plugin.assembla.api.XmlDataParser;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssemblaTicketsAPI
extends AbstractAssemblaAPI {
    public AssemblaTicketsAPI(AssemblaSite assemblaSite) {
        super(assemblaSite);
    }

    public AssemblaTicket getTicket(String space, int ticketNumber) {
        this.space = space;
        LinkedList<AssemblaTicket> result = new LinkedList<AssemblaTicket>();
        try {
            int response = this.client.executeHttpGet(space, "tickets/" + ticketNumber);
            if (response != 200) {
                return null;
            }
            InputStream data = this.client.getResponseStream();
            AssemblaTicketsXmlDataParser parser = new AssemblaTicketsXmlDataParser(data, result);
            parser.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return (AssemblaTicket)result.get(0);
    }

    public List<AssemblaTicket> getTickets(String space) {
        this.space = space;
        LinkedList<AssemblaTicket> result = new LinkedList<AssemblaTicket>();
        try {
            int response = this.client.executeHttpGet(space, "tickets");
            if (response == 200) {
                InputStream data = this.client.getResponseStream();
                AssemblaTicketsXmlDataParser parser = new AssemblaTicketsXmlDataParser(data, result);
                parser.start();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean doCommentTicket(String space, int ticketNumber, String comment) {
        boolean result = false;
        this.space = space;
        try {
            int response = this.client.executeHttpPut(space, "tickets/" + ticketNumber, "<ticket><user-comment>" + comment + "</user-comment></ticket>");
            result = response == 200;
        }
        catch (IOException e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AssemblaTicketsXmlDataParser
    extends XmlDataParser {
        private List<AssemblaTicket> ticketsList;
        private AssemblaTicket currentTicket;

        public AssemblaTicketsXmlDataParser(InputStream instream, List<AssemblaTicket> ticketsList) {
            super(instream);
            this.ticketsList = ticketsList;
        }

        @Override
        protected void endElement(String elementName, String elementValue) {
            if ("ticket".equalsIgnoreCase(elementName)) {
                this.currentTicket.setUrl(AssemblaTicketsAPI.this.assemblaSite.getUrl() + "/spaces/" + AssemblaTicketsAPI.this.space + "/tickets/" + this.currentTicket.getNumber());
                this.ticketsList.add(this.currentTicket);
            } else if ("number".equalsIgnoreCase(elementName)) {
                this.currentTicket.setNumber(elementValue);
            } else if ("reporter".equalsIgnoreCase(elementName)) {
                this.currentTicket.setReportedBy(elementValue);
            } else if ("assigned-to".equalsIgnoreCase(elementName)) {
                this.currentTicket.setAssignedTo(elementValue);
            } else if ("description".equalsIgnoreCase(elementName)) {
                this.currentTicket.setDescription(elementValue);
            }
        }

        @Override
        protected void startElement(String elementName) {
            if ("ticket".equalsIgnoreCase(elementName)) {
                this.currentTicket = new AssemblaTicket();
            }
        }
    }

    public class AssemblaTicket {
        private String reportedBy;
        private String number;
        private String assignedTo;
        private String description;
        private String url;

        public String getReportedBy() {
            return this.reportedBy;
        }

        public void setReportedBy(String reportedBy) {
            this.reportedBy = reportedBy;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getAssignedTo() {
            return this.assignedTo;
        }

        public void setAssignedTo(String assignedTo) {
            this.assignedTo = assignedTo;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String toString() {
            return "Ticket #" + this.number + " Reported by:" + this.reportedBy + " Assigned to: " + this.assignedTo;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}

