/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugin.assembla.api;

import hudson.model.AbstractProject;
import jenkins.plugin.assembla.AssemblaProjectProperty;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssemblaSite {
    private String username;
    private String password;
    private String url;
    private String pattern;
    private static final String DEFAULT_PATTERN = "(#[0-9]+)( .*)";
    private transient String space;
    private transient boolean backtrackEnabled;
    private transient boolean pluginEnabled;

    @DataBoundConstructor
    public AssemblaSite(String username, String password, String url, String pattern) {
        this.password = password;
        this.username = username;
        this.url = url;
        this.pattern = pattern;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSpace() {
        return this.space;
    }

    public void setSpace(String space) {
        this.space = space;
    }

    public String getName() {
        return this.url;
    }

    public boolean isBacktrackEnabled() {
        return this.backtrackEnabled;
    }

    public void setBacktrackEnabled(boolean backtrackEnabled) {
        this.backtrackEnabled = backtrackEnabled;
    }

    public boolean isPluginEnabled() {
        return this.pluginEnabled;
    }

    public void setPluginEnabled(boolean pluginEnabled) {
        this.pluginEnabled = pluginEnabled;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getPatternInternal() {
        if (this.pattern == null || this.pattern.length() == 0) {
            return DEFAULT_PATTERN;
        }
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public static AssemblaSite get(AbstractProject<?, ?> p) {
        AssemblaSite site;
        AssemblaProjectProperty jpp = (AssemblaProjectProperty)p.getProperty(AssemblaProjectProperty.class);
        if (jpp != null && (site = jpp.getSite()) != null) {
            return site;
        }
        AssemblaSite[] sites = AssemblaProjectProperty.DESCRIPTOR.getSites();
        if (sites.length == 1) {
            return sites[0];
        }
        return null;
    }

    public String toString() {
        return "URL='" + this.url + "' - Space='" + this.space + "' Username='" + this.username + "' Password='xxxxxx'";
    }
}

