/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugin.assembla.api;

import java.io.IOException;
import java.io.InputStream;
import jenkins.plugin.assembla.api.AssemblaSite;
import jenkins.plugin.assembla.api.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public class AssemblaHttpClient {
    private String url;
    private String base64AuthString;
    private HttpClient httpClient;
    private InputStream responseStream;

    public AssemblaHttpClient(String url, String username, String password) {
        this.url = url;
        if (!url.startsWith("http")) {
            this.url = "http://" + url;
        }
        this.base64AuthString = new String(Base64.encode((username + ":" + password).getBytes()));
        this.httpClient = new HttpClient();
    }

    public AssemblaHttpClient(AssemblaSite assemblaSite) {
        this(assemblaSite.getUrl(), assemblaSite.getUsername(), assemblaSite.getPassword());
    }

    public InputStream getResponseStream() {
        return this.responseStream;
    }

    private GetMethod getHttpGet(String space, String resource) {
        String query = this.url;
        if (space != null) {
            query = query + "/spaces/" + space;
        }
        if (resource != null) {
            query = query + "/" + resource;
        }
        GetMethod getQuery = new GetMethod(query);
        getQuery.addRequestHeader("Accept", "application/xml");
        getQuery.addRequestHeader("Authorization", "Base " + this.base64AuthString);
        return getQuery;
    }

    private PutMethod getHttpPut(String space, String resource) {
        String query = this.url;
        if (space != null) {
            query = query + "/spaces/" + space;
        }
        if (resource != null) {
            query = query + "/" + resource;
        }
        PutMethod putQuery = new PutMethod(query);
        putQuery.addRequestHeader("Accept", "application/xml");
        putQuery.addRequestHeader("Authorization", "Base " + this.base64AuthString);
        return putQuery;
    }

    public int executeHttpGet(String space, String resource) throws IOException {
        GetMethod getQuery = this.getHttpGet(space, resource);
        int responseCode = this.httpClient.executeMethod((HttpMethod)getQuery);
        this.responseStream = getQuery.getResponseBodyAsStream();
        return responseCode;
    }

    public int executeHttpPut(String space, String resource, String data) throws IOException {
        PutMethod putQuery = this.getHttpPut(space, resource);
        putQuery.setRequestEntity((RequestEntity)new StringRequestEntity(data, "text/xml", "UTF-8"));
        int responseCode = this.httpClient.executeMethod((HttpMethod)putQuery);
        this.responseStream = putQuery.getResponseBodyAsStream();
        return responseCode;
    }
}

