/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugin.assembla;

import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.listeners.SCMListener;
import hudson.scm.ChangeLogSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.plugin.assembla.AssemblaPlugin;
import jenkins.plugin.assembla.api.AssemblaSite;
import jenkins.plugin.assembla.api.AssemblaTicketsAPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssemblaSCMListener
extends SCMListener {
    private static final Logger LOGGER = Logger.getLogger(AssemblaSCMListener.class.getName());
    private transient AssemblaSite site = null;

    public void onChangeLogParsed(AbstractBuild<?, ?> build, BuildListener listener, ChangeLogSet<?> changelog) throws Exception {
        this.site = AssemblaSite.get(build.getProject());
        if (this.site == null || !this.site.isPluginEnabled()) {
            return;
        }
        if (this.site.isBacktrackEnabled()) {
            LOGGER.info("ASSEMBLA backtrack enabled");
            for (ChangeLogSet.Entry changeEntry : changelog) {
                this.checkChangeForAssemblaTicketRef(build, changeEntry);
            }
        } else {
            LOGGER.info("ASSEMBLA backtrack not enabled");
        }
        super.onChangeLogParsed(build, listener, changelog);
    }

    private void checkChangeForAssemblaTicketRef(AbstractBuild<?, ?> build, ChangeLogSet.Entry change) {
        LOGGER.info("Checking for ASSEMBLA ticket pattern");
        String commitMessage = change.getMsg();
        Pattern pattern = Pattern.compile(this.site.getPatternInternal());
        Matcher m = pattern.matcher(commitMessage);
        AssemblaTicketsAPI ticketApi = new AssemblaTicketsAPI(this.site);
        while (m.find()) {
            int ticketNumber = AssemblaPlugin.getTicketNumber(m.group());
            LOGGER.info("ASSEMBLA ticket pattern matches");
            LOGGER.info("Getting ASSEMBLA ticket: '" + ticketNumber + "'");
            AssemblaTicketsAPI.AssemblaTicket ticket = ticketApi.getTicket(this.site.getSpace(), ticketNumber);
            if (ticket == null) continue;
            LOGGER.info("Posting comment to ASSEMBLA ticket: '" + ticketNumber + "'");
            ticketApi.doCommentTicket(this.site.getSpace(), ticketNumber, "Built on Jenkins [[url:" + Hudson.getInstance().getRootUrl() + "/" + build.getUrl() + "]] ");
        }
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof AssemblaSCMListener;
    }
}

