/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.assembla;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.StringParameterValue;
import hudson.model.queue.QueueTaskFuture;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.assembla.AssemblaBuildReporter;
import org.jenkinsci.plugins.assembla.SafeParametersAction;
import org.jenkinsci.plugins.assembla.api.AssemblaClient;
import org.jenkinsci.plugins.assembla.api.models.Space;
import org.jenkinsci.plugins.assembla.api.models.SpaceTool;
import org.jenkinsci.plugins.assembla.api.models.User;
import org.jenkinsci.plugins.assembla.cause.AssemblaCause;
import org.jenkinsci.plugins.assembla.cause.AssemblaMergeRequestCause;
import org.jenkinsci.plugins.assembla.cause.AssemblaPushCause;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class AssemblaBuildTrigger
extends Trigger<AbstractProject<?, ?>> {
    @Extension
    public static final AssemblaBuildTriggerDescriptor DESCRIPTOR = new AssemblaBuildTriggerDescriptor();
    private static final Logger LOGGER = Logger.getLogger(AssemblaBuildTrigger.class.getName());
    private static AssemblaClient assemblaClient = new AssemblaClient(DESCRIPTOR.getBotApiKey(), DESCRIPTOR.getBotApiSecret(), DESCRIPTOR.getAssemblaHost(), DESCRIPTOR.isIgnoreSSLErrors());
    private final String spaceName;
    private final String repoName;
    private String buildDescriptionTemplate;
    private String buildStartedTemplate;
    private String buildResultTemplate;
    private boolean buildOnMergeRequestEnabled;
    private boolean mergeRequestCommentsEnabled;
    private boolean ticketCommentsEnabled;
    private boolean notifyOnStartEnabled;
    private boolean buildOnMergeRequestMergedEnabled;
    private boolean buildOnMergeRequestIgnoredEnabled;
    private boolean triggerOnPushEnabled;
    private String branchesToBuild;
    private transient AssemblaBuildReporter buildReporter;

    @DataBoundConstructor
    public AssemblaBuildTrigger(String spaceName, String repoName, boolean buildOnMergeRequestEnabled, boolean mergeRequestCommentsEnabled, boolean ticketCommentsEnabled, boolean notifyOnStartEnabled, boolean buildOnMergeRequestMergedEnabled, boolean buildOnMergeRequestIgnoredEnabled, boolean triggerOnPushEnabled, String branchesToBuild, String buildDescriptionTemplate, String buildStartedTemplate, String buildResultTemplate) {
        this.buildDescriptionTemplate = buildDescriptionTemplate;
        this.buildStartedTemplate = buildStartedTemplate;
        this.buildResultTemplate = buildResultTemplate;
        this.spaceName = spaceName.trim();
        this.repoName = repoName.trim();
        this.buildOnMergeRequestEnabled = buildOnMergeRequestEnabled;
        this.mergeRequestCommentsEnabled = mergeRequestCommentsEnabled;
        this.ticketCommentsEnabled = ticketCommentsEnabled;
        this.notifyOnStartEnabled = notifyOnStartEnabled;
        this.buildOnMergeRequestMergedEnabled = buildOnMergeRequestMergedEnabled;
        this.buildOnMergeRequestIgnoredEnabled = buildOnMergeRequestIgnoredEnabled;
        this.triggerOnPushEnabled = triggerOnPushEnabled;
        this.branchesToBuild = branchesToBuild.trim();
    }

    public void start(AbstractProject<?, ?> project, boolean newInstance) {
        super.start(project, newInstance);
        String name = project.getFullName();
        if (project.isDisabled()) {
            LOGGER.info("Project is disabled, not starting trigger for job " + name);
            return;
        }
        DESCRIPTOR.addRepoTrigger(this, (AbstractProject)this.job);
        LOGGER.info("Trigger started for " + project.toString() + ". Repo name: " + this.repoName);
    }

    public void stop() {
        if (!StringUtils.isEmpty((String)this.repoName)) {
            DESCRIPTOR.removeRepoTrigger(this, (AbstractProject)this.job);
        }
        super.stop();
    }

    public QueueTaskFuture<?> handleMergeRequest(AssemblaMergeRequestCause cause) {
        if (!this.shouldMergeRequestTriggerBuild(cause).booleanValue()) {
            return null;
        }
        Map<String, ParameterValue> values = this.getDefaultParameters(cause);
        values.put("assemblaMergeRequestId", (ParameterValue)new StringParameterValue("assemblaMergeRequestId", String.valueOf(cause.getMergeRequestId())));
        values.put("assemblaSourceRepositoryName", (ParameterValue)new StringParameterValue("assemblaSourceRepositoryName", cause.getSourceRepositoryName()));
        values.put("assemblaTargetRepositoryUrl", (ParameterValue)new StringParameterValue("assemblaTargetRepositoryUrl", cause.getTargetRepositoryUrl()));
        values.put("assemblaTargetBranch", (ParameterValue)new StringParameterValue("assemblaTargetBranch", cause.getTargetBranch()));
        ArrayList<ParameterValue> listValues = new ArrayList<ParameterValue>(values.values());
        return ((AbstractProject)this.job).scheduleBuild2(0, (Cause)cause, new Action[]{new SafeParametersAction(listValues)});
    }

    public QueueTaskFuture<?> handlePush(AssemblaPushCause cause) {
        List<String> buildableBranches = Arrays.asList(this.branchesToBuild.split(","));
        if (this.triggerOnPushEnabled && (buildableBranches.contains(cause.getSourceBranch()) || this.branchesToBuild.isEmpty())) {
            Map<String, ParameterValue> values = this.getDefaultParameters(cause);
            ArrayList<ParameterValue> listValues = new ArrayList<ParameterValue>(values.values());
            return ((AbstractProject)this.job).scheduleBuild2(0, (Cause)cause, new Action[]{new SafeParametersAction(listValues)});
        }
        return null;
    }

    public AssemblaBuildTriggerDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public String getBuildDescriptionTemplate() {
        return this.buildDescriptionTemplate;
    }

    public String getBuildStartedTemplate() {
        return this.buildStartedTemplate;
    }

    public String getBuildResultTemplate() {
        return this.buildResultTemplate;
    }

    public boolean isMergeRequestCommentsEnabled() {
        return this.mergeRequestCommentsEnabled;
    }

    public boolean isTicketCommentsEnabled() {
        return this.ticketCommentsEnabled;
    }

    public boolean isNotifyOnStartEnabled() {
        return this.notifyOnStartEnabled;
    }

    public boolean isBuildOnMergeRequestEnabled() {
        return this.buildOnMergeRequestEnabled;
    }

    public boolean isTriggerOnPushEnabled() {
        return this.triggerOnPushEnabled;
    }

    public String getBranchesToBuild() {
        return this.branchesToBuild;
    }

    public AssemblaBuildReporter getBuildReporter() {
        if (this.buildReporter == null) {
            this.buildReporter = new AssemblaBuildReporter(this);
        }
        return this.buildReporter;
    }

    public void setBuildReporter(AssemblaBuildReporter reporter) {
        this.buildReporter = reporter;
    }

    public static AssemblaBuildTriggerDescriptor getDesc() {
        return DESCRIPTOR;
    }

    public static AssemblaClient getAssembla() {
        return assemblaClient.setConfig(AssemblaBuildTrigger.getDesc().getBotApiKey(), AssemblaBuildTrigger.getDesc().getBotApiSecret(), AssemblaBuildTrigger.getDesc().getAssemblaHost(), AssemblaBuildTrigger.getDesc().isIgnoreSSLErrors());
    }

    public static void setAssembla(AssemblaClient client) {
        assemblaClient = client;
    }

    public static AssemblaBuildTrigger getTrigger(AbstractProject project) {
        Trigger trigger = project.getTrigger(AssemblaBuildTrigger.class);
        if (trigger == null || !(trigger instanceof AssemblaBuildTrigger)) {
            return null;
        }
        return (AssemblaBuildTrigger)trigger;
    }

    private Map<String, ParameterValue> getDefaultParameters(AssemblaCause cause) {
        HashMap<String, ParameterValue> values = new HashMap<String, ParameterValue>();
        ParametersDefinitionProperty definitionProperty = (ParametersDefinitionProperty)((AbstractProject)this.job).getProperty(ParametersDefinitionProperty.class);
        if (definitionProperty != null) {
            for (ParameterDefinition definition : definitionProperty.getParameterDefinitions()) {
                values.put(definition.getName(), definition.getDefaultParameterValue());
            }
        }
        values.put("assemblaRefName", (ParameterValue)new StringParameterValue("assemblaRefName", cause.getCommitId()));
        values.put("assemblaSourceSpaceId", (ParameterValue)new StringParameterValue("assemblaSourceSpaceId", cause.getSourceSpaceId()));
        values.put("assemblaSourceRepositoryUrl", (ParameterValue)new StringParameterValue("assemblaSourceRepositoryUrl", cause.getSourceRepositoryUrl()));
        values.put("assemblaSourceBranch", (ParameterValue)new StringParameterValue("assemblaSourceBranch", cause.getSourceBranch()));
        values.put("assemblaAuthorName", (ParameterValue)new StringParameterValue("assemblaAuthorName", cause.getAuthorName()));
        String description = cause.getDescription();
        if (description == null) {
            values.put("assemblaDescription", (ParameterValue)new StringParameterValue("assemblaDescription", ""));
        } else {
            values.put("assemblaDescription", (ParameterValue)new StringParameterValue("assemblaDescription", description));
        }
        return values;
    }

    private Boolean shouldMergeRequestTriggerBuild(AssemblaMergeRequestCause cause) {
        if ((cause.isCreated().booleanValue() || cause.isUpdated().booleanValue()) && this.buildOnMergeRequestEnabled) {
            return true;
        }
        if (cause.isMerged().booleanValue() && this.buildOnMergeRequestMergedEnabled) {
            return true;
        }
        if (cause.isIgnored().booleanValue() && this.buildOnMergeRequestIgnoredEnabled) {
            return true;
        }
        return false;
    }

    public static final class AssemblaBuildTriggerDescriptor
    extends TriggerDescriptor {
        private String assemblaHost = "https://app.assembla.com/";
        private String botApiKey = "";
        private Secret botApiSecret;
        private boolean ignoreSSLErrors;
        private final transient Map<String, Set<AbstractProject<?, ?>>> repoJobs;

        public AssemblaBuildTriggerDescriptor() {
            this.load();
            this.repoJobs = new ConcurrentHashMap();
        }

        public boolean isApplicable(Item item) {
            return item instanceof AbstractProject;
        }

        public String getDisplayName() {
            return "Assembla Build Triggers";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.botApiKey = formData.getString("botApiKey");
            this.botApiSecret = Secret.fromString((String)formData.getString("botApiSecret"));
            this.assemblaHost = formData.getString("assemblaHost");
            this.ignoreSSLErrors = formData.getBoolean("ignoreSSLErrors");
            this.save();
            return super.configure(req, formData);
        }

        public FormValidation doCheckBotApiKey(@QueryParameter String value) {
            if (value == null || value.isEmpty()) {
                return FormValidation.error((String)"You must provide an API key for the Jenkins user");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckBotApiSecret(@QueryParameter String value) {
            if (value == null || value.isEmpty()) {
                return FormValidation.error((String)"You must provide an API secret for the Jenkins user");
            }
            return FormValidation.ok();
        }

        public FormValidation doTestCredentials(@QueryParameter(value="botApiKey") String key, @QueryParameter(value="botApiSecret") String secret, @QueryParameter(value="ignoreSSLErrors") boolean ignoreSSLErrors, @QueryParameter(value="assemblaHost") String assemblaHost) {
            User user;
            try {
                user = new AssemblaClient(key, secret, assemblaHost, ignoreSSLErrors).getUser();
            }
            catch (AssemblaClient.UnauthorizedError ex) {
                return FormValidation.error((String)"Invalid credentials");
            }
            catch (RuntimeException ex) {
                LOGGER.log(Level.SEVERE, "Failed to check credentials", ex);
                return FormValidation.error((String)("Could not connect to Assembla API: " + ex.toString()));
            }
            if (user == null) {
                return FormValidation.error((String)"Could not perform test request to Assembla API");
            }
            return FormValidation.ok((String)("Successfully logged in as: " + user.getLogin() + " (" + user.getName() + ")"));
        }

        public FormValidation doCheckSettings(@QueryParameter(value="spaceName") String spaceName, @QueryParameter(value="repoName") String repoName) {
            SpaceTool spaceTool;
            Space space;
            if (spaceName == null || spaceName.isEmpty()) {
                return FormValidation.error((String)"You must provide a space name");
            }
            if (repoName == null || repoName.isEmpty()) {
                return FormValidation.error((String)"You must provide a space name");
            }
            try {
                space = AssemblaBuildTrigger.getAssembla().getSpace(spaceName);
            }
            catch (AssemblaClient.UnauthorizedError ex) {
                return FormValidation.error((String)"Unable to authenticate. Please check API credentials on Jenkins system configuration page");
            }
            catch (AssemblaClient.ForbiddenError ex) {
                return FormValidation.error((String)"You do not have permissions to access this space. Are you a member?");
            }
            catch (AssemblaClient.NotFoundError ex) {
                return FormValidation.error((String)("Could not find space  " + spaceName));
            }
            if (space == null) {
                return FormValidation.error((String)"Failed to fetch space. Please check your connection settings");
            }
            try {
                spaceTool = AssemblaBuildTrigger.getAssembla().getTool(spaceName, repoName);
            }
            catch (AssemblaClient.UnauthorizedError ex) {
                return FormValidation.error((String)"Unable to authenticate. Please check API credentials on Jenkins system configuration page");
            }
            catch (AssemblaClient.ForbiddenError ex) {
                return FormValidation.error((String)"You do not have permissions to access this tool");
            }
            catch (AssemblaClient.NotFoundError ex) {
                return FormValidation.error((String)("Could not find repo with name " + repoName + " in space " + spaceName));
            }
            if (spaceTool == null) {
                return FormValidation.error((String)"Failed to fetch space tool. Please check your connection settings");
            }
            return FormValidation.ok((String)"It's all good!");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRepoTrigger(AssemblaBuildTrigger trigger, AbstractProject<?, ?> project) {
            String projectKey = this.getProjectKey(trigger);
            if (project == null || StringUtils.isEmpty((String)projectKey)) {
                return;
            }
            LOGGER.info("Adding trigger for repo: " + projectKey);
            Map<String, Set<AbstractProject<?, ?>>> map = this.repoJobs;
            synchronized (map) {
                Set<AbstractProject<?, ?>> projects = this.repoJobs.get(projectKey);
                if (projects == null) {
                    projects = new HashSet();
                    this.repoJobs.put(projectKey, projects);
                }
                projects.add(project);
            }
        }

        public void removeRepoTrigger(AssemblaBuildTrigger trigger, AbstractProject<?, ?> project) {
            String projectKey = this.getProjectKey(trigger);
            Set<AbstractProject<?, ?>> projects = this.repoJobs.get(projectKey);
            if (project == null || projects == null || StringUtils.isEmpty((String)projectKey)) {
                return;
            }
            LOGGER.info("Removing trigger for repo: " + projectKey);
            projects.remove(project);
        }

        public Set<AbstractProject<?, ?>> getRepoJobs(String spaceName, String repoName) {
            Set<AbstractProject<?, ?>> projects = this.repoJobs.get(this.getProjectKey(spaceName, repoName));
            if (projects == null) {
                projects = new HashSet();
            }
            return projects;
        }

        public String getBotApiKey() {
            return this.botApiKey;
        }

        public String getBotApiSecret() {
            if (this.botApiSecret == null) {
                return "";
            }
            return this.botApiSecret.getPlainText();
        }

        private String getProjectKey(AssemblaBuildTrigger trigger) {
            return this.getProjectKey(trigger.getSpaceName(), trigger.getRepoName());
        }

        private String getProjectKey(String spaceName, String repoName) {
            return (spaceName + ":" + repoName).toLowerCase();
        }

        public String getAssemblaHost() {
            return this.assemblaHost;
        }

        public boolean isIgnoreSSLErrors() {
            return this.ignoreSSLErrors;
        }
    }
}

