/*
 * Decompiled with CFR 0.152.
 */
package com.assembla.jenkinsci.plugin;

import com.assembla.jenkinsci.plugin.api.ApiService;
import com.assembla.jenkinsci.plugin.api.TokenAssembla;
import com.assembla.jenkinsci.plugin.api.UserAssembla;
import hudson.security.SecurityRealm;
import java.util.logging.Logger;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.AbstractAuthenticationToken;

public class AssemblaAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 6106269076155338045L;
    private static final Logger LOG = Logger.getLogger(AssemblaAuthenticationToken.class.getName());
    private UserAssembla user = null;
    private UserAssembla[] users;
    private transient TokenAssembla tokensAssembla;
    private long lastTimeApiCall;

    public AssemblaAuthenticationToken(TokenAssembla tokensAssembla, String spaceId) {
        super(new GrantedAuthority[0]);
        LOG.fine("*************** AssemblaAuthenticationToken() *****************");
        this.tokensAssembla = tokensAssembla;
        this.lastTimeApiCall = 0L;
        boolean authenticate = false;
        if (tokensAssembla != null) {
            this.user = ApiService.getUserByToken(tokensAssembla.access_token);
            if (this.user != null) {
                authenticate = true;
                this.user.setSpaceId(spaceId);
            }
        }
        this.setAuthenticated(authenticate);
    }

    public long getLastTimeApiCall() {
        return this.lastTimeApiCall;
    }

    public void setLastTimeApiCall(long lastTimeApiCall) {
        this.lastTimeApiCall = lastTimeApiCall;
    }

    public TokenAssembla getTokensAssembla() {
        return this.tokensAssembla;
    }

    public UserAssembla getUser() {
        return this.user;
    }

    public GrantedAuthority[] getAuthorities() {
        if (this.user == null) {
            return new GrantedAuthority[0];
        }
        return new GrantedAuthority[]{SecurityRealm.AUTHENTICATED_AUTHORITY, new GrantedAuthorityImpl(this.user.login)};
    }

    public Object getCredentials() {
        return "";
    }

    public Object getPrincipal() {
        return this.user != null ? this.user.login : null;
    }

    public String getName() {
        return this.user != null ? this.user.login : null;
    }

    public UserAssembla[] getUsers() {
        return (UserAssembla[])this.users.clone();
    }

    public UserAssembla getUserByUsername(String login) {
        UserAssembla result = null;
        for (UserAssembla u : this.users) {
            if (!u.login.equalsIgnoreCase(login)) continue;
            result = u;
            break;
        }
        return result;
    }
}

