/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.aquadockerscannerbuildstep;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.aquadockerscannerbuildstep.AquaScannerAction;
import org.jenkinsci.plugins.aquadockerscannerbuildstep.ScannerExecuter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class AquaDockerScannerBuilder
extends Builder
implements SimpleBuildStep {
    public static final int OK_CODE = 0;
    public static final int DISALLOWED_CODE = 4;
    private final String imageName;
    private final String onDisallowed;
    private final String notCompliesCmd;
    private final String outputFormat;
    private static int count;
    private static int buildId;

    public static synchronized void setCount(int count) {
        AquaDockerScannerBuilder.count = count;
    }

    public static synchronized void setBuildId(int buildId) {
        AquaDockerScannerBuilder.buildId = buildId;
    }

    @DataBoundConstructor
    public AquaDockerScannerBuilder(String imageName, String onDisallowed, String notCompliesCmd, String outputFormat) {
        this.imageName = imageName;
        this.onDisallowed = onDisallowed;
        this.notCompliesCmd = notCompliesCmd;
        this.outputFormat = "json".equalsIgnoreCase(outputFormat) ? outputFormat : "html";
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getOnDisallowed() {
        return this.onDisallowed;
    }

    public String getNotCompliesCmd() {
        return this.notCompliesCmd;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public String isOnDisallowed(String state) {
        if (this.onDisallowed == null) {
            return "ignore".equals(state) ? "true" : "false";
        }
        return this.onDisallowed.equals(state) ? "true" : "false";
    }

    public String isOnOutputFormat(String state) {
        if (this.outputFormat == null) {
            return "html".equals(state) ? "true" : "false";
        }
        return this.outputFormat.equals(state) ? "true" : "false";
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws AbortException, InterruptedException {
        String artifactName;
        String artifactSuffix;
        String microScannerToken = this.getDescriptor().getMicroScannerToken();
        boolean caCertificates = this.getDescriptor().getCaCertificates();
        if (microScannerToken == null || microScannerToken.trim().equals("")) {
            throw new AbortException("Missing configuration. Please set the global configuration parameters in The \"Aqua Security\" section under  \"Manage Jenkins/Configure System\", before continuing.\n");
        }
        if (build.hashCode() != buildId) {
            AquaDockerScannerBuilder.setBuildId(build.hashCode());
            AquaDockerScannerBuilder.setCount(1);
            artifactSuffix = null;
            artifactName = "scanout." + this.outputFormat;
        } else {
            AquaDockerScannerBuilder.setCount(count + 1);
            artifactSuffix = Integer.toString(count);
            artifactName = "scanout-" + artifactSuffix + "." + this.outputFormat;
        }
        int exitCode = ScannerExecuter.execute(build, workspace, launcher, listener, artifactName, microScannerToken, this.imageName, this.notCompliesCmd, this.outputFormat == null ? "html" : this.outputFormat, this.onDisallowed == null || !this.onDisallowed.equals("fail"), caCertificates);
        build.addAction((Action)new AquaScannerAction(build, artifactSuffix, artifactName, this.imageName));
        this.archiveArtifacts(build, workspace, launcher, listener);
        System.out.println("exitCode: " + exitCode);
        String failedMessage = "Scanning failed.";
        switch (exitCode) {
            case 0: {
                System.out.println("Scanning success.");
                break;
            }
            case 4: {
                throw new AbortException(failedMessage);
            }
            default: {
                throw new AbortException(failedMessage);
            }
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void archiveArtifacts(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException {
        ArtifactArchiver artifactArchiver = new ArtifactArchiver("scanout*");
        artifactArchiver.perform(build, workspace, launcher, listener);
        ArtifactArchiver styleArtifactArchiver = new ArtifactArchiver("styles.css");
        styleArtifactArchiver.perform(build, workspace, launcher, listener);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    static {
        buildId = 0;
    }

    @Symbol(value={"aquaMicroscanner"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String microScannerToken;
        private boolean caCertificates;

        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) throws IOException, ServletException {
            try {
                Integer.parseInt(value);
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Must be a number");
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Aqua MicroScanner";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.microScannerToken = formData.getString("microScannerToken");
            this.caCertificates = formData.getBoolean("caCertificates");
            this.save();
            return super.configure(req, formData);
        }

        public String getMicroScannerToken() {
            return this.microScannerToken;
        }

        public boolean getCaCertificates() {
            return this.caCertificates;
        }
    }
}

