/*
 * Decompiled with CFR 0.152.
 */
package jfullam.vfabric.jenkins.plugin.rest;

import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Iterator;
import jfullam.vfabric.jenkins.plugin.rest.ServiceException;
import jfullam.vfabric.jenkins.plugin.rest.UserInterfaceDataService;
import jfullam.vfabric.rest.appdir.RestProvider;
import org.codehaus.jackson.JsonNode;

public class UserInterfaceDataRestService
implements UserInterfaceDataService {
    private RestProvider restProvider;
    private JsonNode lastComponentsFetch;

    public ListBoxModel getDeployments() throws ServiceException {
        JsonNode jsonDeployments = this.restProvider.getDeployments();
        ArrayList<ListBoxModel.Option> options = new ArrayList<ListBoxModel.Option>();
        Iterator resultsNodes = jsonDeployments.get("results").getElements();
        while (resultsNodes.hasNext()) {
            JsonNode deployment = (JsonNode)resultsNodes.next();
            if (!this.isRunning(deployment)) continue;
            String key = deployment.get("applicationName").asText() + " - " + deployment.get("deploymentProfileName").asText();
            String value = deployment.get("id").asText();
            options.add(new ListBoxModel.Option(key, value));
        }
        return new ListBoxModel(options);
    }

    private boolean isRunning(JsonNode deployment) {
        return deployment.get("deploymentState").asText().equals("DEPLOYMENT_SUCCESS");
    }

    public ListBoxModel getComponents(String deploymentId) throws ServiceException {
        ArrayList<ListBoxModel.Option> options = new ArrayList<ListBoxModel.Option>();
        JsonNode jsonUpdateProps = this.restProvider.getDeploymentUpdateProperties(deploymentId);
        this.lastComponentsFetch = jsonUpdateProps.get("result").get("profileNodeComponents");
        if (this.lastComponentsFetch != null) {
            Iterator resultsNodes = this.lastComponentsFetch.getElements();
            while (resultsNodes.hasNext()) {
                JsonNode component = (JsonNode)resultsNodes.next();
                String keyValue = component.get("name").asText();
                options.add(new ListBoxModel.Option(keyValue));
            }
        }
        return new ListBoxModel(options);
    }

    public ListBoxModel getUpdateProperties(String component) {
        ArrayList<ListBoxModel.Option> options = new ArrayList<ListBoxModel.Option>();
        if (this.lastComponentsFetch != null) {
            Iterator componentNodes = this.lastComponentsFetch.getElements();
            while (componentNodes.hasNext()) {
                JsonNode jsonComponent = (JsonNode)componentNodes.next();
                if (!jsonComponent.get("name").asText().equals(component)) continue;
                Iterator propertyNodes = jsonComponent.get("property").getElements();
                while (propertyNodes.hasNext()) {
                    JsonNode jsonProperty = (JsonNode)propertyNodes.next();
                    String keyValue = jsonProperty.get("key").asText();
                    options.add(new ListBoxModel.Option(keyValue));
                }
            }
        }
        return new ListBoxModel(options);
    }

    public ListBoxModel getApplications() throws ServiceException {
        ArrayList<ListBoxModel.Option> options = new ArrayList<ListBoxModel.Option>();
        JsonNode jsonApplications = this.restProvider.getApplications();
        Iterator resultsNodes = jsonApplications.get("results").getElements();
        while (resultsNodes.hasNext()) {
            JsonNode application = (JsonNode)resultsNodes.next();
            String appName = application.get("name").asText();
            String appId = application.get("id").asText();
            options.add(new ListBoxModel.Option(appName, appName + "," + appId));
        }
        return new ListBoxModel(options);
    }

    public ListBoxModel getDeploymentProfiles(String applicationId) throws ServiceException {
        ArrayList<ListBoxModel.Option> options = new ArrayList<ListBoxModel.Option>();
        JsonNode deploymentProfiles = this.restProvider.getDeploymentProfiles(applicationId);
        if (deploymentProfiles != null) {
            Iterator resultsNodes = deploymentProfiles.get("results").getElements();
            while (resultsNodes.hasNext()) {
                JsonNode profile = (JsonNode)resultsNodes.next();
                String profileName = profile.get("name").asText();
                String profileId = profile.get("id").asText();
                options.add(new ListBoxModel.Option(profileName, profileName + "," + profileId));
            }
        }
        return new ListBoxModel(options);
    }

    public void setRestProvider(RestProvider restProvider) {
        this.restProvider = restProvider;
    }
}

