/*
 * Decompiled with CFR 0.152.
 */
package jfullam.vfabric.jenkins.plugin.rest;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import jfullam.vfabric.jenkins.plugin.rest.ConnectionValidationRestService;
import jfullam.vfabric.jenkins.plugin.rest.ConnectionValidationService;
import jfullam.vfabric.jenkins.plugin.rest.ProvisioningRestService;
import jfullam.vfabric.jenkins.plugin.rest.ProvisioningService;
import jfullam.vfabric.jenkins.plugin.rest.ServiceException;
import jfullam.vfabric.jenkins.plugin.rest.UpdateRestService;
import jfullam.vfabric.jenkins.plugin.rest.UpdateService;
import jfullam.vfabric.jenkins.plugin.rest.UserInterfaceDataRestService;
import jfullam.vfabric.jenkins.plugin.rest.UserInterfaceDataService;
import jfullam.vfabric.rest.appdir.DefaultRestProvider;
import jfullam.vfabric.rest.appdir.RestProvider;

public class ServiceManager {
    private static ProvisioningService provisioningService;
    private static RestProvider appDirRestProvider;
    private static UserInterfaceDataService userInterfaceDataService;
    private static UpdateService updateService;
    private static ConnectionValidationService connectionValidationService;

    public static void configureApplicationDirectorClient(String appDirBaseURI, String userName, String password) throws ServiceException {
        try {
            ServiceManager.initializeRestProvider(appDirBaseURI, userName, password);
            ServiceManager.initializeProvisioningService();
            ServiceManager.initializeUserInterfaceService();
            ServiceManager.initializeUpdateService();
            ServiceManager.initializeConnectionValidationService();
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
    }

    public static ProvisioningService provisioningService() {
        return provisioningService;
    }

    public static UserInterfaceDataService userInterfaceService() {
        return userInterfaceDataService;
    }

    public static UpdateService updateService() {
        return updateService;
    }

    public static ConnectionValidationService connectionValidationService() {
        return connectionValidationService;
    }

    private static synchronized void initializeProvisioningService() {
        if (provisioningService == null) {
            provisioningService = new ProvisioningRestService();
        }
        provisioningService.setRestProvider(appDirRestProvider);
    }

    private static void initializeRestProvider(String appDirBaseURI, String userName, String password) throws KeyManagementException, NoSuchAlgorithmException {
        appDirRestProvider = new DefaultRestProvider(appDirBaseURI, userName, password);
    }

    private static synchronized void initializeConnectionValidationService() {
        if (connectionValidationService == null) {
            connectionValidationService = new ConnectionValidationRestService();
        }
        connectionValidationService.setRestProvider(appDirRestProvider);
    }

    private static synchronized void initializeUpdateService() {
        if (updateService == null) {
            updateService = new UpdateRestService();
        }
        updateService.setRestProvider(appDirRestProvider);
    }

    private static synchronized void initializeUserInterfaceService() {
        if (userInterfaceDataService == null) {
            userInterfaceDataService = new UserInterfaceDataRestService();
        }
        userInterfaceDataService.setRestProvider(appDirRestProvider);
    }
}

