/*
 * Decompiled with CFR 0.152.
 */
package jfullam.vfabric.jenkins.plugin;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.StringTokenizer;
import jfullam.vfabric.jenkins.plugin.rest.ServiceException;
import jfullam.vfabric.jenkins.plugin.rest.ServiceManager;
import jfullam.vfabric.jenkins.plugin.rest.ServiceResult;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ApplicationDirectorPostBuildDeployer
extends BuildWrapper {
    private static final Log log = LogFactory.getLog(ApplicationDirectorPostBuildDeployer.class);
    private static final String PROVISION = "provision";
    private String application;
    private String deploymentProfile;
    private String deployment;
    private String component;
    private String updateProperty;
    private String updatePropertyValue;
    private String provisionOrUpdate;

    @DataBoundConstructor
    public ApplicationDirectorPostBuildDeployer(String provisionOrUpdate, String application, String deploymentProfile, String deployment, String component, String updateProperty, String updatePropertyValue) {
        this.application = application;
        this.deploymentProfile = deploymentProfile;
        this.deployment = deployment;
        this.component = component;
        this.updateProperty = updateProperty;
        this.updatePropertyValue = updatePropertyValue;
        this.provisionOrUpdate = provisionOrUpdate;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        BuildWrapper.Environment applicationDirectorEnv = new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                listener.getLogger().println("Application Director base REST uri:  " + ApplicationDirectorPostBuildDeployer.this.getDescriptor().getAppDirBaseURI());
                listener.getLogger().println("Applicatin Director REST API user:  " + ApplicationDirectorPostBuildDeployer.this.getDescriptor().getUserName());
                try {
                    if (ApplicationDirectorPostBuildDeployer.this.provisionOrUpdate.equals(ApplicationDirectorPostBuildDeployer.PROVISION)) {
                        listener.getLogger().println("Calling Applicaiton Director to re-deploy an application blueprint.");
                        listener.getLogger().println("Application:  " + ApplicationDirectorPostBuildDeployer.this.application);
                        listener.getLogger().println("Deployment Profile:  " + ApplicationDirectorPostBuildDeployer.this.deploymentProfile);
                        StringTokenizer profileParser = new StringTokenizer(ApplicationDirectorPostBuildDeployer.this.deploymentProfile, ",");
                        StringTokenizer applicationParser = new StringTokenizer(ApplicationDirectorPostBuildDeployer.this.application, ",");
                        listener.getLogger().println("Looking for an existing deployment to teardown.");
                        ServiceResult teardownResult = ServiceManager.provisioningService().tearDown(applicationParser.nextToken(), profileParser.nextToken());
                        ApplicationDirectorPostBuildDeployer.this.handleResult(teardownResult, listener, build);
                        if (!teardownResult.isSuccess()) {
                            return false;
                        }
                        listener.getLogger().println("Deploying based on the configured deployment profile.");
                        ServiceResult deployResult = ServiceManager.provisioningService().scheduleDeployment(profileParser.nextToken());
                        ApplicationDirectorPostBuildDeployer.this.handleResult(deployResult, listener, build);
                        if (!deployResult.isSuccess()) {
                            return false;
                        }
                    } else {
                        listener.getLogger().println("Calling Application Director to update an existing deployment.");
                        listener.getLogger().println("Existing deployment:  " + ApplicationDirectorPostBuildDeployer.this.deployment);
                        listener.getLogger().println("component:  " + ApplicationDirectorPostBuildDeployer.this.component);
                        listener.getLogger().println("property to update:  " + ApplicationDirectorPostBuildDeployer.this.updateProperty + " value:  " + ApplicationDirectorPostBuildDeployer.this.updatePropertyValue);
                        ServiceResult updateResult = ServiceManager.updateService().updateDeployment(ApplicationDirectorPostBuildDeployer.this.deployment, ApplicationDirectorPostBuildDeployer.this.component, ApplicationDirectorPostBuildDeployer.this.updateProperty, ApplicationDirectorPostBuildDeployer.this.updatePropertyValue);
                        ApplicationDirectorPostBuildDeployer.this.handleResult(updateResult, listener, build);
                        if (!updateResult.isSuccess()) {
                            return false;
                        }
                    }
                }
                catch (ServiceException e) {
                    listener.getLogger().println("Error while integrating with Appplication Director");
                    listener.getLogger().println(e.getMessage());
                    build.setResult(Result.FAILURE);
                    return false;
                }
                return true;
            }
        };
        return applicationDirectorEnv;
    }

    private void handleResult(ServiceResult result, BuildListener listener, AbstractBuild build) {
        if (result.isSuccess()) {
            for (String msg : result.getMessages()) {
                listener.getLogger().println(msg);
            }
        } else {
            build.setResult(Result.FAILURE);
            for (String msg : result.getMessages()) {
                listener.error(msg);
            }
        }
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getProvisionOrUpdate() {
        return this.provisionOrUpdate;
    }

    public void setProvisionOrUpdate(String provisionOrUpdate) {
        this.provisionOrUpdate = provisionOrUpdate;
    }

    public String getDeploymentProfile() {
        return this.deploymentProfile;
    }

    public void setDeploymentProfile(String deploymentProfile) {
        this.deploymentProfile = deploymentProfile;
    }

    public String getDeployment() {
        return this.deployment;
    }

    public void setDeployment(String deployment) {
        this.deployment = deployment;
    }

    public String getUpdateProperty() {
        return this.updateProperty;
    }

    public void setUpdateProperty(String updateProperty) {
        this.updateProperty = updateProperty;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getUpdatePropertyValue() {
        return this.updatePropertyValue;
    }

    public void setUpdatePropertyValue(String updatePropertyValue) {
        this.updatePropertyValue = updatePropertyValue;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class Descriptor
    extends BuildWrapperDescriptor {
        private String appDirBaseURI;
        private String userName;
        private String password;

        public Descriptor() {
            this.load();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return "Application Director Client";
        }

        public FormValidation doValidateConnection(@QueryParameter(value="appDirBaseURI") String appDirBaseURI, @QueryParameter(value="userName") String userName, @QueryParameter(value="password") String password) {
            try {
                ServiceManager.configureApplicationDirectorClient(appDirBaseURI, userName, password);
                if (ServiceManager.connectionValidationService().connectionValid()) {
                    return FormValidation.ok((String)"Validated Successfully!");
                }
                return FormValidation.error((String)"Validation Failed!");
            }
            catch (ServiceException e) {
                return FormValidation.error((String)"Error During Validation");
            }
        }

        public ListBoxModel doFillDeploymentItems() {
            try {
                return ServiceManager.userInterfaceService().getDeployments();
            }
            catch (ServiceException e) {
                log.error((Object)"Problem calling REST service for deployments select box.", (Throwable)e);
                return new ListBoxModel();
            }
        }

        public ListBoxModel doFillComponentItems(@QueryParameter String deployment) {
            try {
                return ServiceManager.userInterfaceService().getComponents(deployment);
            }
            catch (ServiceException e) {
                log.error((Object)"Problem calling REST service for components select box.", (Throwable)e);
                return new ListBoxModel();
            }
        }

        public ListBoxModel doFillUpdatePropertyItems(@QueryParameter String component) {
            return ServiceManager.userInterfaceService().getUpdateProperties(component);
        }

        public ListBoxModel doFillApplicationItems() {
            try {
                return ServiceManager.userInterfaceService().getApplications();
            }
            catch (ServiceException e) {
                log.error((Object)"Problem calling REST service for applications select box.", (Throwable)e);
                return new ListBoxModel();
            }
        }

        public ListBoxModel doFillDeploymentProfileItems(@QueryParameter String application) {
            if (StringUtils.isNotBlank((String)application)) {
                StringTokenizer applicationParser = new StringTokenizer(application, ",");
                applicationParser.nextToken();
                try {
                    return ServiceManager.userInterfaceService().getDeploymentProfiles(applicationParser.nextToken());
                }
                catch (ServiceException e) {
                    log.error((Object)"Problem calling REST service for deployment profile select box.", (Throwable)e);
                }
            }
            return new ListBoxModel();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.appDirBaseURI = formData.getJSONObject("vfabric").getString("appDirBaseURI");
            this.userName = formData.getJSONObject("vfabric").getString("userName");
            this.password = formData.getJSONObject("vfabric").getString("password");
            try {
                ServiceManager.configureApplicationDirectorClient(this.appDirBaseURI, this.userName, this.password);
            }
            catch (ServiceException e) {
                throw new Descriptor.FormException((Throwable)e, "Problem configuring the REST service.");
            }
            this.save();
            return super.configure(req, formData);
        }

        public String getAppDirBaseURI() {
            return this.appDirBaseURI;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

