/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import com.google.common.collect.Lists;
import com.sun.jndi.ldap.LdapCtxFactory;
import com4j.typelibs.ado20.ClassFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.Binding;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AdministrativeMonitor;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.active_directory.AbstractActiveDirectoryAuthenticationProvider;
import hudson.plugins.active_directory.ActiveDirectoryDomain;
import hudson.plugins.active_directory.ActiveDirectoryUnixAuthenticationProvider;
import hudson.plugins.active_directory.CacheConfiguration;
import hudson.plugins.active_directory.GroupLookupStrategy;
import hudson.plugins.active_directory.Messages;
import hudson.plugins.active_directory.SocketInfo;
import hudson.plugins.active_directory.TlsConfiguration;
import hudson.plugins.active_directory.TrustAllSocketFactory;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.TokenBasedRememberMeServices2;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import hudson.util.spring.BeanBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.ui.rememberme.RememberMeServices;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.io.IOUtils;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.web.context.WebApplicationContext;

public class ActiveDirectorySecurityRealm
extends AbstractPasswordBasedSecurityRealm {
    public transient String domain;
    public transient String server;
    public List<ActiveDirectoryDomain> domains;
    public final transient String site;
    public transient String bindName;
    public transient Secret bindPassword;
    public Boolean startTls;
    private GroupLookupStrategy groupLookupStrategy;
    public final boolean removeIrrelevantGroups;
    protected CacheConfiguration cache;
    protected List<EnvironmentProperty> environmentProperties;
    protected TlsConfiguration tlsConfiguration;
    protected transient ExecutorService threadPoolExecutor;
    private static final Logger LOGGER = Logger.getLogger(ActiveDirectorySecurityRealm.class.getName());
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Diagnostic fields are left mutable so that groovy console can be used to dynamically turn/off probes.")
    public static String DOMAIN_CONTROLLERS = System.getProperty(ActiveDirectorySecurityRealm.class.getName() + ".domainControllers");
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Diagnostic fields are left mutable so that groovy console can be used to dynamically turn/off probes.")
    public static boolean FORCE_LDAPS = Boolean.getBoolean(ActiveDirectorySecurityRealm.class.getName() + ".forceLdaps");
    @Extension
    public static final TlsConfigurationAdministrativeMonitor NOTICE = new TlsConfigurationAdministrativeMonitor();

    public ActiveDirectorySecurityRealm(String domain, String site, String bindName, String bindPassword, String server) {
        this(domain, site, bindName, bindPassword, server, GroupLookupStrategy.AUTO, false);
    }

    public ActiveDirectorySecurityRealm(String domain, String site, String bindName, String bindPassword, String server, GroupLookupStrategy groupLookupStrategy) {
        this(domain, site, bindName, bindPassword, server, groupLookupStrategy, false);
    }

    public ActiveDirectorySecurityRealm(String domain, String site, String bindName, String bindPassword, String server, GroupLookupStrategy groupLookupStrategy, boolean removeIrrelevantGroups) {
        this(domain, site, bindName, bindPassword, server, groupLookupStrategy, removeIrrelevantGroups, null);
    }

    public ActiveDirectorySecurityRealm(String domain, String site, String bindName, String bindPassword, String server, GroupLookupStrategy groupLookupStrategy, boolean removeIrrelevantGroups, CacheConfiguration cache) {
        this(domain, Lists.newArrayList((Object[])new ActiveDirectoryDomain[]{new ActiveDirectoryDomain(domain, server)}), site, bindName, bindPassword, server, groupLookupStrategy, removeIrrelevantGroups, domain != null, cache, true);
    }

    public ActiveDirectorySecurityRealm(String domain, List<ActiveDirectoryDomain> domains, String site, String bindName, String bindPassword, String server, GroupLookupStrategy groupLookupStrategy, boolean removeIrrelevantGroups, Boolean customDomain, CacheConfiguration cache, Boolean startTls) {
        this(domain, domains, site, bindName, bindPassword, server, groupLookupStrategy, removeIrrelevantGroups, customDomain, cache, startTls, TlsConfiguration.TRUST_ALL_CERTIFICATES);
    }

    @DataBoundConstructor
    public ActiveDirectorySecurityRealm(String domain, List<ActiveDirectoryDomain> domains, String site, String bindName, String bindPassword, String server, GroupLookupStrategy groupLookupStrategy, boolean removeIrrelevantGroups, Boolean customDomain, CacheConfiguration cache, Boolean startTls, TlsConfiguration tlsConfiguration) {
        if (customDomain != null && !customDomain.booleanValue()) {
            domains = null;
        }
        this.domain = Util.fixEmpty((String)domain);
        this.server = Util.fixEmpty((String)server);
        this.domains = domains;
        this.site = Util.fixEmpty((String)site);
        this.bindName = Util.fixEmpty((String)bindName);
        this.bindPassword = Secret.fromString((String)Util.fixEmpty((String)bindPassword));
        this.groupLookupStrategy = groupLookupStrategy;
        this.removeIrrelevantGroups = removeIrrelevantGroups;
        this.cache = cache;
        this.tlsConfiguration = tlsConfiguration;
        this.startTls = startTls;
    }

    @DataBoundSetter
    public void setEnvironmentProperties(List<EnvironmentProperty> environmentProperties) {
        this.environmentProperties = environmentProperties;
    }

    @Restricted(value={NoExternalUse.class})
    public CacheConfiguration getCache() {
        if (this.cache != null && (this.cache.getSize() == 0 || this.cache.getTtl() == 0)) {
            return null;
        }
        return this.cache;
    }

    @Restricted(value={NoExternalUse.class})
    public Boolean isStartTls() {
        return this.startTls;
    }

    public Integer getSize() {
        return this.cache == null ? null : Integer.valueOf(this.cache.getSize());
    }

    public Integer getTtl() {
        return this.cache == null ? null : Integer.valueOf(this.cache.getTtl());
    }

    @Restricted(value={NoExternalUse.class})
    public List<EnvironmentProperty> getEnvironmentProperties() {
        return this.environmentProperties;
    }

    public GroupLookupStrategy getGroupLookupStrategy() {
        if (this.groupLookupStrategy == null) {
            return GroupLookupStrategy.AUTO;
        }
        return this.groupLookupStrategy;
    }

    @Restricted(value={NoExternalUse.class})
    public TlsConfiguration getTlsConfiguration() {
        return this.tlsConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityRealm.SecurityComponents createSecurityComponents() {
        BeanBuilder builder = new BeanBuilder(((Object)((Object)this)).getClass().getClassLoader());
        Binding binding = new Binding();
        binding.setVariable("realm", (Object)this);
        InputStream i = ((Object)((Object)this)).getClass().getResourceAsStream("ActiveDirectory.groovy");
        try {
            builder.parse(i, binding);
        }
        finally {
            IOUtils.closeQuietly((InputStream)i);
        }
        WebApplicationContext context = builder.createApplicationContext();
        ActiveDirectorySecurityRealm.findBean(AbstractActiveDirectoryAuthenticationProvider.class, (ApplicationContext)context);
        UserDetailsService uds = (UserDetailsService)ActiveDirectorySecurityRealm.findBean(UserDetailsService.class, (ApplicationContext)context);
        TokenBasedRememberMeServices2 rms = new TokenBasedRememberMeServices2(){

            public Authentication autoLogin(HttpServletRequest request, HttpServletResponse response) {
                try {
                    return super.autoLogin(request, response);
                }
                catch (Exception e) {
                    this.cancelCookie(request, response, "Failed to handle remember-me cookie: " + Functions.printThrowable((Throwable)e));
                    return null;
                }
            }
        };
        rms.setUserDetailsService(uds);
        rms.setKey(Hudson.getInstance().getSecretKey());
        rms.setParameter("remember_me");
        return new SecurityRealm.SecurityComponents((AuthenticationManager)ActiveDirectorySecurityRealm.findBean(AuthenticationManager.class, (ApplicationContext)context), uds, (RememberMeServices)rms);
    }

    @Restricted(value={NoExternalUse.class})
    public List<ActiveDirectoryDomain> getDomains() {
        return this.domains;
    }

    public Object readResolve() throws ObjectStreamException {
        List<ActiveDirectoryDomain> activeDirectoryDomains;
        if (this.domain != null) {
            String[] oldDomains;
            this.domains = new ArrayList<ActiveDirectoryDomain>();
            this.domain = this.domain.trim();
            for (String oldDomain : oldDomains = this.domain.split(",")) {
                oldDomain = oldDomain.trim();
                this.domains.add(new ActiveDirectoryDomain(oldDomain, this.server));
            }
        }
        if ((activeDirectoryDomains = this.getDomains()) != null) {
            if (this.bindName != null && this.bindPassword != null) {
                for (ActiveDirectoryDomain activeDirectoryDomain : activeDirectoryDomains) {
                    activeDirectoryDomain.bindName = this.bindName;
                    activeDirectoryDomain.bindPassword = this.bindPassword;
                }
            }
            if (this.site != null) {
                for (ActiveDirectoryDomain activeDirectoryDomain : activeDirectoryDomains) {
                    activeDirectoryDomain.site = this.site;
                }
            }
        }
        if (this.startTls == null) {
            this.startTls = true;
        }
        return this;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAuthTest(StaplerRequest req, StaplerResponse rsp, @QueryParameter String username, @QueryParameter String password) throws IOException, ServletException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        StringWriter out = new StringWriter();
        PrintWriter pw = new PrintWriter(out);
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            AbstractActiveDirectoryAuthenticationProvider uds = this.getAuthenticationProvider();
            if (uds instanceof ActiveDirectoryUnixAuthenticationProvider) {
                ActiveDirectoryUnixAuthenticationProvider p = (ActiveDirectoryUnixAuthenticationProvider)uds;
                DescriptorImpl descriptor = this.getDescriptor();
                for (ActiveDirectoryDomain domain : this.domains) {
                    try {
                        pw.println("Domain= " + domain.getName() + " site= " + domain.getSite());
                        List<SocketInfo> ldapServers = descriptor.obtainLDAPServer(domain);
                        pw.println("List of domain controllers: " + ldapServers);
                        for (SocketInfo ldapServer : ldapServers) {
                            pw.println("Trying a domain controller at " + ldapServer);
                            try {
                                UserDetails d = p.retrieveUser(username, password, domain, Collections.singletonList(ldapServer));
                                pw.println("Authenticated as " + d);
                            }
                            catch (org.acegisecurity.AuthenticationException e) {
                                e.printStackTrace(pw);
                            }
                        }
                    }
                    catch (NamingException e) {
                        pw.println("Failing to resolve domain controllers");
                        e.printStackTrace(pw);
                    }
                }
            } else {
                pw.println("Using Windows ADSI. No diagnostics available.");
            }
        }
        catch (Exception e) {
            e.printStackTrace(pw);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
        req.setAttribute("output", (Object)out.toString());
        req.getView((Object)this, "test.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @Restricted(value={DoNotUse.class})
    public void shutDownthreadPoolExecutors() {
        this.threadPoolExecutor.shutdown();
    }

    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        return this.getAuthenticationProvider().loadGroupByGroupname(groupname);
    }

    public AbstractActiveDirectoryAuthenticationProvider getAuthenticationProvider() {
        return (AbstractActiveDirectoryAuthenticationProvider)this.getSecurityComponents().userDetails;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        return this.getAuthenticationProvider().loadUserByUsername(username);
    }

    protected UserDetails authenticate(String username, String password) throws org.acegisecurity.AuthenticationException {
        return this.getAuthenticationProvider().retrieveUser(username, new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
    }

    public static final class TlsConfigurationAdministrativeMonitor
    extends AdministrativeMonitor {
        public boolean isActivated() {
            SecurityRealm securityRealm = Jenkins.getInstance().getSecurityRealm();
            if (securityRealm instanceof ActiveDirectorySecurityRealm) {
                ActiveDirectorySecurityRealm activeDirectorySecurityRealm = (ActiveDirectorySecurityRealm)securityRealm;
                if (activeDirectorySecurityRealm.tlsConfiguration == null) {
                    return true;
                }
            }
            return false;
        }

        public void doAct(StaplerRequest req, StaplerResponse rsp) throws IOException {
            if (req.hasParameter("correct")) {
                rsp.sendRedirect(req.getRootPath() + "/configureSecurity");
            }
        }

        public static TlsConfigurationAdministrativeMonitor get() {
            return (TlsConfigurationAdministrativeMonitor)((Object)AdministrativeMonitor.all().get(TlsConfigurationAdministrativeMonitor.class));
        }
    }

    public static class EnvironmentProperty
    extends AbstractDescribableImpl<EnvironmentProperty>
    implements Serializable {
        private final String name;
        private final String value;

        @DataBoundConstructor
        public EnvironmentProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public static Map<String, String> toMap(List<EnvironmentProperty> properties) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            if (properties != null) {
                for (EnvironmentProperty property : properties) {
                    result.put(property.getName(), property.getValue());
                }
                return result;
            }
            return result;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<EnvironmentProperty> {
            public String getDisplayName() {
                return null;
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        private static boolean WARNED = false;
        private static final List<String> CANDIDATES = Arrays.asList("_gc._tcp.", "_ldap._tcp.");

        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/active-directory/help/realm.html";
        }

        public boolean canDoNativeAuth() {
            if (!Functions.isWindows()) {
                return false;
            }
            try {
                ClassFactory.createConnection().dispose();
                return true;
            }
            catch (Throwable t) {
                if (!WARNED) {
                    LOGGER.log(Level.INFO, "COM4J isn't working. Falling back to non-native authentication", t);
                    WARNED = true;
                }
                return false;
            }
        }

        public ListBoxModel doFillSizeItems() {
            ListBoxModel listBoxModel = new ListBoxModel();
            listBoxModel.add("10 elements", "10");
            listBoxModel.add("20 elements", "20");
            listBoxModel.add("50 elements", "50");
            listBoxModel.add("100 elements", "100");
            listBoxModel.add("200 elements", "200");
            listBoxModel.add("256 elements", "256");
            listBoxModel.add("500 elements", "500");
            listBoxModel.add("1000 elements", "1000");
            return listBoxModel;
        }

        public ListBoxModel doFillTtlItems() {
            ListBoxModel listBoxModel = new ListBoxModel();
            listBoxModel.add("30 sec", "30");
            listBoxModel.add("1 min", "60");
            listBoxModel.add("5 min", "300");
            listBoxModel.add("10 min", "600");
            listBoxModel.add("15 min", "900");
            listBoxModel.add("30 min", "1800");
            listBoxModel.add("1 hour", "3600");
            return listBoxModel;
        }

        public ListBoxModel doFillGroupLookupStrategyItems() {
            ListBoxModel model = new ListBoxModel();
            for (GroupLookupStrategy e : GroupLookupStrategy.values()) {
                model.add(e.getDisplayName(), e.name());
            }
            return model;
        }

        public ListBoxModel doFillTlsConfigurationItems() {
            ListBoxModel model = new ListBoxModel();
            for (TlsConfiguration tlsConfiguration : TlsConfiguration.values()) {
                model.add(tlsConfiguration.getDisplayName(), tlsConfiguration.name());
            }
            return model;
        }

        private boolean isTrustAllCertificatesEnabled(TlsConfiguration tlsConfiguration) {
            return tlsConfiguration == null || TlsConfiguration.TRUST_ALL_CERTIFICATES.equals((Object)tlsConfiguration);
        }

        @Deprecated
        public DirContext bind(String principalName, String password, List<SocketInfo> ldapServers, Hashtable<String, String> props) {
            return this.bind(principalName, password, ldapServers, props, null);
        }

        public DirContext bind(String principalName, String password, List<SocketInfo> ldapServers, Hashtable<String, String> props, TlsConfiguration tlsConfiguration) {
            Hashtable<String, String> newProps = new Hashtable<String, String>();
            Boolean ignoreReferrals = Boolean.valueOf(System.getProperty("hudson.plugins.active_directory.referral.ignore", "false"));
            if (!ignoreReferrals.booleanValue()) {
                newProps.put("java.naming.referral", "follow");
            } else {
                newProps.put("java.naming.referral", "ignore");
            }
            newProps.put("java.naming.ldap.attributes.binary", "tokenGroups objectSid");
            if (FORCE_LDAPS && this.isTrustAllCertificatesEnabled(tlsConfiguration)) {
                newProps.put("java.naming.ldap.factory.socket", TrustAllSocketFactory.class.getName());
            }
            newProps.putAll(props);
            NamingException namingException = null;
            for (SocketInfo ldapServer : ldapServers) {
                try {
                    LdapContext context = this.bind(principalName, password, ldapServer, newProps);
                    LOGGER.fine("Bound to " + ldapServer);
                    return context;
                }
                catch (AuthenticationException e) {
                    LOGGER.log(Level.WARNING, "Failed to authenticate while binding to " + ldapServer, e);
                    throw new BadCredentialsException("Either no such user '" + principalName + "' or incorrect password", (Throwable)namingException);
                }
                catch (NamingException e) {
                    LOGGER.log(Level.WARNING, "Failed to bind to " + ldapServer, e);
                    namingException = e;
                }
            }
            throw new BadCredentialsException("Either no such user '" + principalName + "' or incorrect password", namingException);
        }

        @Deprecated
        public DirContext bind(String principalName, String password, List<SocketInfo> ldapServers) {
            return this.bind(principalName, password, ldapServers, new Hashtable<String, String>());
        }

        private void customizeLdapProperty(Hashtable<String, String> props, String propName) {
            String prop = System.getProperty(propName, null);
            if (prop != null) {
                props.put(propName, prop);
            }
        }

        private void customizeLdapProperties(Hashtable<String, String> props) {
            this.customizeLdapProperty(props, "com.sun.jndi.ldap.connect.timeout");
            this.customizeLdapProperty(props, "com.sun.jndi.ldap.read.timeout");
        }

        @Deprecated
        @IgnoreJRERequirement
        private LdapContext bind(String principalName, String password, SocketInfo server, Hashtable<String, String> props) throws NamingException {
            return this.bind(principalName, password, server, props, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @IgnoreJRERequirement
        private LdapContext bind(String principalName, String password, SocketInfo server, Hashtable<String, String> props, TlsConfiguration tlsConfiguration) throws NamingException {
            String ldapUrl = (FORCE_LDAPS ? "ldaps://" : "ldap://") + server + '/';
            String oldName = Thread.currentThread().getName();
            Thread.currentThread().setName("Connecting to " + ldapUrl + " : " + oldName);
            LOGGER.fine("Connecting to " + ldapUrl);
            try {
                props.put("java.naming.provider.url", ldapUrl);
                props.put("java.naming.ldap.version", "3");
                this.customizeLdapProperties(props);
                LdapContext context = (LdapContext)LdapCtxFactory.getLdapCtxInstance(ldapUrl, props);
                boolean isStartTls = true;
                SecurityRealm securityRealm = Jenkins.getInstance().getSecurityRealm();
                if (securityRealm instanceof ActiveDirectorySecurityRealm) {
                    ActiveDirectorySecurityRealm activeDirectorySecurityRealm = (ActiveDirectorySecurityRealm)securityRealm;
                    isStartTls = activeDirectorySecurityRealm.isStartTls();
                }
                if (!FORCE_LDAPS && isStartTls) {
                    try {
                        StartTlsResponse rsp = (StartTlsResponse)context.extendedOperation(new StartTlsRequest());
                        if (this.isTrustAllCertificatesEnabled(tlsConfiguration)) {
                            rsp.negotiate((SSLSocketFactory)TrustAllSocketFactory.getDefault());
                        } else {
                            rsp.negotiate();
                        }
                        LOGGER.fine("Connection upgraded to TLS");
                    }
                    catch (NamingException e) {
                        LOGGER.log(Level.FINE, "Failed to start TLS. Authentication will be done via plain-text LDAP", e);
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINE, "Failed to start TLS. Authentication will be done via plain-text LDAP", e);
                    }
                }
                if (principalName == null || password == null || password.equals("")) {
                    context.addToEnvironment("java.naming.security.authentication", "none");
                    LOGGER.fine("Binding anonymously to " + ldapUrl);
                } else {
                    context.addToEnvironment("java.naming.security.principal", principalName);
                    context.addToEnvironment("java.naming.security.credentials", password);
                    LOGGER.fine("Binding as " + principalName + " to " + ldapUrl);
                }
                context.reconnect(null);
                LdapContext ldapContext = context;
                return ldapContext;
            }
            finally {
                Thread.currentThread().setName(oldName);
            }
        }

        public DirContext createDNSLookupContext() throws NamingException {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            env.put("java.naming.provider.url", "dns:");
            return new InitialDirContext(env);
        }

        @Deprecated
        public List<SocketInfo> obtainLDAPServer(String domainName, String site, String preferredServer) throws NamingException {
            return this.obtainLDAPServer(this.createDNSLookupContext(), domainName, site, preferredServer);
        }

        public List<SocketInfo> obtainLDAPServer(ActiveDirectoryDomain activeDirectoryDomain) throws NamingException {
            return this.obtainLDAPServer(this.createDNSLookupContext(), activeDirectoryDomain.getName(), activeDirectoryDomain.getSite(), activeDirectoryDomain.getServers());
        }

        public List<SocketInfo> obtainLDAPServer(DirContext ictx, String domainName, String site, String preferredServers) throws NamingException {
            ArrayList<SocketInfo> result = new ArrayList<SocketInfo>();
            if (preferredServers == null || preferredServers.isEmpty()) {
                preferredServers = DOMAIN_CONTROLLERS;
            }
            if (preferredServers != null) {
                for (String token : preferredServers.split(",")) {
                    result.add(new SocketInfo(token.trim()));
                }
                return result;
            }
            String ldapServer = null;
            Attribute a = null;
            NamingException failure = null;
            for (String candidate : CANDIDATES) {
                ldapServer = candidate + (site != null ? site + "._sites." : "") + domainName;
                LOGGER.fine("Attempting to resolve " + ldapServer + " to SRV record");
                try {
                    Attributes attributes = ictx.getAttributes(ldapServer, new String[]{"SRV"});
                    a = attributes.get("SRV");
                    if (a == null) continue;
                    break;
                }
                catch (NamingException e) {
                    failure = e;
                }
                catch (NumberFormatException x) {
                    failure = (NamingException)new NamingException("JDK IPv6 bug encountered").initCause(x);
                }
            }
            if (a != null) {
                class PrioritizedSocketInfo
                implements Comparable<PrioritizedSocketInfo> {
                    SocketInfo socket;
                    int priority;

                    PrioritizedSocketInfo(SocketInfo socket, int priority) {
                        this.socket = socket;
                        this.priority = priority;
                    }

                    @Override
                    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"}, justification="Weird and unpredictable behaviour intentional for load balancing.")
                    public int compareTo(PrioritizedSocketInfo that) {
                        return that.priority - this.priority;
                    }
                }
                ArrayList<PrioritizedSocketInfo> plist = new ArrayList<PrioritizedSocketInfo>();
                NamingEnumeration<?> ne = a.getAll();
                while (ne.hasMoreElements()) {
                    String record = ne.next().toString();
                    LOGGER.fine("SRV record found: " + record);
                    String[] fields = record.split(" ");
                    String hostName = fields[3];
                    if (hostName.endsWith(".")) {
                        hostName = hostName.substring(0, hostName.length() - 1);
                    }
                    int port = Integer.parseInt(fields[2]);
                    if (FORCE_LDAPS) {
                        if (port == 389) {
                            port = 636;
                        }
                        if (port == 3268) {
                            port = 3269;
                        }
                    }
                    int p = Integer.parseInt(fields[0]);
                    plist.add(new PrioritizedSocketInfo(new SocketInfo(hostName, port), p));
                }
                Collections.sort(plist);
                for (PrioritizedSocketInfo psi : plist) {
                    result.add(psi.socket);
                }
            }
            if (result.isEmpty()) {
                NamingException x = new NamingException("No SRV record found for " + ldapServer);
                if (failure != null) {
                    x.initCause(failure);
                }
                throw x;
            }
            LOGGER.fine(ldapServer + " resolved to " + result);
            return result;
        }
    }
}

