/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.ManagementLink;
import hudson.plugins.active_directory.ActiveDirectoryDomain;
import hudson.plugins.active_directory.ActiveDirectorySecurityRealm;
import hudson.plugins.active_directory.Messages;
import hudson.plugins.active_directory.SocketInfo;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.util.ProgressiveRendering;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerProxy;
import org.springframework.security.core.userdetails.UserDetails;

@Extension
public class ActiveDirectoryStatus
extends ManagementLink
implements StaplerProxy {
    public String getIconFileName() {
        return "/plugin/active-directory/images/icon.png";
    }

    public String getDisplayName() {
        return Messages._ActiveDirectoryStatus_ActiveDirectoryHealthStatus().toString();
    }

    public String getUrlName() {
        return "ad-health";
    }

    @NonNull
    public Permission getRequiredPermission() {
        return Jenkins.ADMINISTER;
    }

    @Restricted(value={NoExternalUse.class})
    public static List<ActiveDirectoryDomain> getDomains() {
        SecurityRealm securityRealm = Jenkins.getActiveInstance().getSecurityRealm();
        if (securityRealm instanceof ActiveDirectorySecurityRealm) {
            ActiveDirectorySecurityRealm activeDirectorySecurityRealm = (ActiveDirectorySecurityRealm)securityRealm;
            return activeDirectorySecurityRealm.getDomains();
        }
        return Collections.emptyList();
    }

    @Restricted(value={NoExternalUse.class})
    public ProgressiveRendering startDomainHealthChecks(final String domain) {
        return new ProgressiveRendering(){
            final List<ServerHealth> domainHealth = new LinkedList<ServerHealth>();

            protected void compute() throws Exception {
                for (ActiveDirectoryDomain domainItem : ActiveDirectoryStatus.getDomains()) {
                    SecurityRealm securityRealm;
                    if (this.canceled()) {
                        return;
                    }
                    if (!domainItem.getName().equals(domain) || !((securityRealm = Jenkins.getActiveInstance().getSecurityRealm()) instanceof ActiveDirectorySecurityRealm)) continue;
                    ActiveDirectorySecurityRealm activeDirectorySecurityRealm = (ActiveDirectorySecurityRealm)securityRealm;
                    List<SocketInfo> servers = activeDirectorySecurityRealm.getDescriptor().obtainLDAPServer(domainItem);
                    for (SocketInfo socketInfo : servers) {
                        ServerHealth serverHealth = new ServerHealth(socketInfo);
                        this.domainHealth.add(serverHealth);
                    }
                }
            }

            protected synchronized JSON data() {
                JSONArray r = new JSONArray();
                for (ServerHealth serverHealth : this.domainHealth) {
                    r.add((Object)serverHealth);
                }
                this.domainHealth.clear();
                return new JSONObject().accumulate("domainHealth", (Object)r);
            }
        };
    }

    @Restricted(value={NoExternalUse.class})
    public ListBoxModel doFillDomainsItems() {
        ListBoxModel model = new ListBoxModel();
        for (ActiveDirectoryDomain domain : ActiveDirectoryStatus.getDomains()) {
            model.add(domain.getName());
        }
        return model;
    }

    public Object getTarget() {
        Jenkins.get().checkPermission(this.getRequiredPermission());
        return this;
    }

    @NonNull
    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.STATUS;
    }

    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
    public static class ServerHealth
    extends SocketInfo {
        private boolean canLogin;
        private long pingExecutionTime = this.computePingExecutionTime();
        private long loginExecutionTime = this.computeLoginExecutionTime();

        public ServerHealth(SocketInfo socketInfo) {
            super(socketInfo.getHost(), socketInfo.getPort());
        }

        @Restricted(value={NoExternalUse.class})
        public boolean isCanLogin() {
            return this.loginExecutionTime != -1L;
        }

        @Restricted(value={NoExternalUse.class})
        public long getPingExecutionTime() {
            return this.pingExecutionTime;
        }

        @Restricted(value={NoExternalUse.class})
        public long getLoginExecutionTime() {
            return this.loginExecutionTime;
        }

        private long computeLoginExecutionTime() {
            String username = Jenkins.getAuthentication().getName();
            long t0 = System.currentTimeMillis();
            UserDetails userDetails = Jenkins.getActiveInstance().getSecurityRealm().loadUserByUsername2(username);
            long t1 = System.currentTimeMillis();
            return userDetails != null ? t1 - t0 : -1L;
        }

        private long computePingExecutionTime() {
            try {
                long t0 = System.currentTimeMillis();
                super.connect().close();
                long t1 = System.currentTimeMillis();
                return t1 - t0;
            }
            catch (IOException iOException) {
                return -1L;
            }
        }
    }
}

