/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.UserProperty;
import hudson.plugins.active_directory.ActiveDirectorySecurityRealm;
import hudson.security.HudsonPrivateSecurityRealm;
import hudson.security.SecurityRealm;
import hudson.tasks.Mailer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;

public class ActiveDirectoryUserDetail
extends User {
    private final String displayName;
    private final String mail;
    private final String telephoneNumber;
    private String toStringValue;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ActiveDirectoryUserDetail.class.getName());

    public ActiveDirectoryUserDetail(String username, String password, boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, GrantedAuthority[] authorities, String displayName, String mail, String telephoneNumber) throws IllegalArgumentException {
        super(username, "redacted", enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities);
        this.displayName = displayName;
        this.mail = mail;
        this.telephoneNumber = telephoneNumber;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getMail() {
        return this.mail;
    }

    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    public String toString() {
        return this.toStringValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActiveDirectoryUserDetail)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ActiveDirectoryUserDetail that = (ActiveDirectoryUserDetail)((Object)o);
        if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) {
            return false;
        }
        if (this.mail != null ? !this.mail.equals(that.mail) : that.mail != null) {
            return false;
        }
        if (this.telephoneNumber != null ? !this.telephoneNumber.equals(that.telephoneNumber) : that.telephoneNumber != null) {
            return false;
        }
        return !(this.toStringValue == null ? that.toStringValue != null : !this.toStringValue.equals(that.toStringValue));
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
        result = 31 * result + (this.mail != null ? this.mail.hashCode() : 0);
        result = 31 * result + (this.telephoneNumber != null ? this.telephoneNumber.hashCode() : 0);
        result = 31 * result + (this.toStringValue != null ? this.toStringValue.hashCode() : 0);
        return result;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="https://github.com/jenkinsci/jenkins/pull/2094")
    protected void setAuthorities(GrantedAuthority[] authorities) {
        Jenkins jenkins = Jenkins.getActiveInstance();
        SecurityRealm realm = jenkins.getSecurityRealm();
        if (realm instanceof ActiveDirectorySecurityRealm) {
            ActiveDirectorySecurityRealm activeDirectoryRealm = (ActiveDirectorySecurityRealm)realm;
            if (activeDirectoryRealm.removeIrrelevantGroups) {
                HashSet<String> referencedGroups = new HashSet<String>();
                for (String group : jenkins.getAuthorizationStrategy().getGroups()) {
                    referencedGroups.add(group.toLowerCase());
                }
                if (!referencedGroups.isEmpty()) {
                    ArrayList<GrantedAuthority> relevantGroups = new ArrayList<GrantedAuthority>();
                    for (GrantedAuthority group : authorities) {
                        String groupName = group.getAuthority();
                        if (groupName == null || !referencedGroups.contains(groupName.toLowerCase())) continue;
                        relevantGroups.add(group);
                    }
                    authorities = relevantGroups.toArray(new GrantedAuthority[0]);
                }
            }
        }
        super.setAuthorities(authorities);
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append(": ");
        sb.append("Username: ").append(this.getUsername()).append("; ");
        sb.append("Password: [PROTECTED]; ");
        sb.append("Enabled: ").append(this.isEnabled()).append("; ");
        sb.append("AccountNonExpired: ").append(this.isAccountNonExpired()).append("; ");
        sb.append("credentialsNonExpired: ").append(this.isCredentialsNonExpired()).append("; ");
        sb.append("AccountNonLocked: ").append(this.isAccountNonLocked()).append("; ");
        if (this.getAuthorities() != null) {
            sb.append("Granted Authorities: ");
            for (int i = 0; i < this.getAuthorities().length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.getAuthorities()[i].toString());
            }
        } else {
            sb.append("Not granted any authorities");
        }
        this.toStringValue = sb.toString();
    }

    public static long getSerialVersionUID() {
        return 1L;
    }

    public hudson.model.User getJenkinsUser() {
        return hudson.model.User.getById((String)this.getUsername(), (boolean)true);
    }

    public UserDetails updateUserInfo() {
        Mailer.UserProperty existing;
        hudson.model.User u = this.getJenkinsUser();
        if (this.getDisplayName() != null && u.getId().equals(u.getFullName())) {
            u.setFullName(this.getDisplayName());
        }
        if ((existing = (Mailer.UserProperty)u.getProperty(Mailer.UserProperty.class)) == null || !existing.hasExplicitlyConfiguredAddress()) {
            try {
                u.addProperty((UserProperty)new Mailer.UserProperty(this.getMail()));
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to associate the e-mail address", e);
            }
        }
        return this;
    }

    protected void updatePasswordInJenkinsInternalDatabase(String username, String password) {
        LOGGER.log(Level.FINEST, String.format("Looking in Jenkins Internal Database for user %s", username));
        hudson.model.User internalUser = hudson.model.User.get((String)username);
        HudsonPrivateSecurityRealm.Details details = (HudsonPrivateSecurityRealm.Details)internalUser.getProperty(HudsonPrivateSecurityRealm.Details.class);
        try {
            Class[] paramString = new Class[]{String.class};
            Class<?> cls = Class.forName("hudson.security.HudsonPrivateSecurityRealm$Details");
            Method method = cls.getDeclaredMethod("fromPlainPassword", paramString);
            method.setAccessible(true);
            Object object = method.invoke((Object)details, password);
            if (object instanceof HudsonPrivateSecurityRealm.Details) {
                HudsonPrivateSecurityRealm.Details newDetails = (HudsonPrivateSecurityRealm.Details)object;
                internalUser.addProperty((UserProperty)newDetails);
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.log(Level.WARNING, String.format("Failed to update the password for user %s in the Jenkins Internal Database", username), e);
        }
    }
}

